/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.transport;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.transport.TGTransportCache;
import app.tuxguitar.app.util.MidiTickUtil;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.document.TGDocumentManager;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.player.base.MidiPlayerException;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.error.TGErrorManager;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;

public class TGTransport {
    private TGContext context;
    private TGTransportCache cache;

    public TGTransport(TGContext context) {
        this.context = context;
        this.cache = new TGTransportCache(context);
    }

    public TGTransportCache getCache() {
        return this.cache;
    }

    public TGSongManager getSongManager() {
        return TGDocumentManager.getInstance((TGContext)this.context).getSongManager();
    }

    public TGSong getSong() {
        return TGDocumentManager.getInstance((TGContext)this.context).getSong();
    }

    public void gotoFirst() {
        this.gotoMeasure(this.getSongManager().getFirstMeasureHeader(this.getSong()), true);
    }

    public void gotoLast() {
        this.gotoMeasure(this.getSongManager().getLastMeasureHeader(this.getSong()), true);
    }

    public void gotoNext() {
        MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
        TGMeasureHeader header = this.getSongManager().getMeasureHeaderAt(this.getSong(), MidiTickUtil.getStart(this.context, player.getTickPosition()));
        if (header != null) {
            this.gotoMeasure(this.getSongManager().getNextMeasureHeader(this.getSong(), header), true);
        }
    }

    public void gotoPrevious() {
        MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
        TGMeasureHeader header = this.getSongManager().getMeasureHeaderAt(this.getSong(), MidiTickUtil.getStart(this.context, player.getTickPosition()));
        if (header != null) {
            this.gotoMeasure(this.getSongManager().getPrevMeasureHeader(this.getSong(), header), true);
        }
    }

    public void gotoCaretPosition() {
        this.gotoMeasure(TablatureEditor.getInstance(this.context).getTablature().getCaret().getMeasure().getHeader(), false);
    }

    public void gotoMeasure(TGMeasureHeader header, boolean moveCaret) {
        if (header != null) {
            TGMeasureImpl playingMeasure = null;
            MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
            if (player.isRunning()) {
                this.getCache().updatePlayMode();
                playingMeasure = this.getCache().getPlayMeasure();
            }
            if (playingMeasure == null || playingMeasure.getHeader().getNumber() != header.getNumber()) {
                player.setTickPosition(MidiTickUtil.getTick(this.context, header.getStart()));
                if (moveCaret) {
                    this.goToTickPosition();
                }
            }
        }
    }

    public void gotoPlayerPosition() {
        MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
        TGMeasureHeader header = this.getSongManager().getMeasureHeaderAt(this.getSong(), MidiTickUtil.getStart(this.context, player.getTickPosition()));
        if (header != null) {
            player.setTickPosition(MidiTickUtil.getTick(this.context, header.getStart()));
        }
        this.goToTickPosition();
    }

    public void goToTickPosition() {
        TablatureEditor.getInstance(this.context).getTablature().getCaret().goToTickPosition();
        TuxGuitar.getInstance().updateCache(true);
    }

    public void playPause(TGBeat start, TGBeat end) {
        MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
        if (!player.isRunning()) {
            if (start != null) {
                player.setSelection(start, end);
            }
            this.play();
        } else {
            this.pause();
        }
    }

    public void playStop(TGBeat start, TGBeat end) {
        MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
        if (!player.isRunning()) {
            if (start != null) {
                player.setSelection(start, end);
            }
            this.play();
        } else {
            this.stop();
        }
    }

    private void play() {
        MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
        try {
            this.gotoCaretPosition();
            player.getMode().reset();
            player.play();
        }
        catch (MidiPlayerException e) {
            TGErrorManager.getInstance((TGContext)this.context).handleError((Throwable)e);
        }
    }

    private void pause() {
        MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
        this.gotoPlayerPosition();
        player.pause();
    }

    public void stop() {
        MidiPlayer player = MidiPlayer.getInstance((TGContext)this.context);
        if (player.isRunning()) {
            player.reset();
        }
    }

    public static TGTransport getInstance(TGContext context) {
        return (TGTransport)TGSingletonUtil.getInstance((TGContext)context, (String)TGTransport.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGTransport>(){

            public TGTransport createInstance(TGContext context) {
                return new TGTransport(context);
            }
        });
    }
}

