/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.tools.browser;

import app.tuxguitar.app.tools.browser.TGBrowserConnectionHandler;
import app.tuxguitar.app.tools.browser.base.TGBrowser;
import app.tuxguitar.app.tools.browser.base.TGBrowserCallBack;
import app.tuxguitar.app.tools.browser.base.TGBrowserElement;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGLock;
import java.io.InputStream;
import java.util.List;

public class TGBrowserConnection {
    private boolean locked;
    private TGLock lock;
    private TGBrowser browser;
    private TGBrowserConnectionHandler handler;

    public TGBrowserConnection(TGContext context, TGBrowserConnectionHandler handler) {
        this.handler = handler;
        this.lock = new TGLock(context);
    }

    public boolean isOpen() {
        return this.getBrowser() != null;
    }

    public void open(final TGBrowserCallBack<Object> callback, final TGBrowser browser) {
        if (this.tryLock()) {
            new Thread(new Runnable(){
                final /* synthetic */ TGBrowserConnection this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.internalClose(new TGBrowserCallBackWrapper<Object>(this, callback){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            super(callback2);
                        }

                        @Override
                        public void onSuccess(Object data) {
                            this.this$1.this$0.internalOpen(this.this$1.this$0.new TGBrowserCallBackUnlockWrapper(callback), browser);
                        }
                    });
                }
            }).start();
        }
    }

    public void close(final TGBrowserCallBack<Object> callback, boolean force) {
        if (this.tryLock() || force) {
            new Thread(new Runnable(){
                final /* synthetic */ TGBrowserConnection this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.internalClose(this.this$0.new TGBrowserCallBackUnlockWrapper(callback));
                }
            }).start();
        }
    }

    public void cdRoot(final TGBrowserCallBack<Object> callback) {
        if (this.tryLock()) {
            new Thread(new Runnable(){
                final /* synthetic */ TGBrowserConnection this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.internalCdRoot(this.this$0.new TGBrowserCallBackUnlockWrapper(callback));
                }
            }).start();
        }
    }

    public void cdUp(final TGBrowserCallBack<Object> callback) {
        if (this.tryLock()) {
            new Thread(new Runnable(){
                final /* synthetic */ TGBrowserConnection this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.internalCdUp(this.this$0.new TGBrowserCallBackUnlockWrapper(callback));
                }
            }).start();
        }
    }

    public void cdElement(final TGBrowserCallBack<Object> callback, final TGBrowserElement element) {
        if (this.tryLock()) {
            new Thread(new Runnable(){
                final /* synthetic */ TGBrowserConnection this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.internalCdElement(this.this$0.new TGBrowserCallBackUnlockWrapper(callback), element);
                }
            }).start();
        }
    }

    public void listElements(final TGBrowserCallBack<List<TGBrowserElement>> callback) {
        if (this.tryLock()) {
            new Thread(new Runnable(){
                final /* synthetic */ TGBrowserConnection this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.internalListElements(this.this$0.new TGBrowserCallBackUnlockWrapper(callback));
                }
            }).start();
        }
    }

    public void openStream(final TGBrowserCallBack<InputStream> callback, final TGBrowserElement element) {
        if (this.tryLock()) {
            new Thread(new Runnable(){
                final /* synthetic */ TGBrowserConnection this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.internalOpenStream(this.this$0.new TGBrowserCallBackUnlockWrapper(callback), element);
                }
            }).start();
        }
    }

    private void internalOpen(TGBrowserCallBack<Object> callback, final TGBrowser browser) {
        if (browser != null) {
            browser.open((TGBrowserCallBack<Object>)new TGBrowserCallBackWrapper<Object>(this, callback){
                final /* synthetic */ TGBrowserConnection this$0;
                {
                    this.this$0 = this$0;
                    super(callback);
                }

                @Override
                public void onSuccess(Object data) {
                    this.this$0.setBrowser(browser);
                    super.onSuccess(data);
                }
            });
        }
    }

    private void internalClose(TGBrowserCallBack<Object> callback) {
        if (this.browser != null) {
            this.browser.close((TGBrowserCallBack<Object>)new TGBrowserCallBackWrapper<Object>(callback){

                @Override
                public void onSuccess(Object data) {
                    TGBrowserConnection.this.setBrowser(null);
                    super.onSuccess(data);
                }
            });
        } else {
            callback.onSuccess(null);
        }
    }

    private void internalCdRoot(TGBrowserCallBack<Object> callback) {
        if (this.isOpen()) {
            this.getBrowser().cdRoot(callback);
        } else {
            callback.onSuccess(null);
        }
    }

    private void internalCdUp(TGBrowserCallBack<Object> callback) {
        if (this.isOpen()) {
            this.getBrowser().cdUp(callback);
        } else {
            callback.onSuccess(null);
        }
    }

    private void internalCdElement(TGBrowserCallBack<Object> callback, TGBrowserElement element) {
        if (this.isOpen()) {
            this.getBrowser().cdElement(callback, element);
        } else {
            callback.onSuccess(null);
        }
    }

    private void internalListElements(TGBrowserCallBack<List<TGBrowserElement>> callback) {
        if (this.isOpen()) {
            this.getBrowser().listElements(callback);
        } else {
            callback.onSuccess(null);
        }
    }

    private void internalOpenStream(TGBrowserCallBack<InputStream> callback, TGBrowserElement element) {
        if (this.isOpen() && element != null && !element.isFolder()) {
            this.getBrowser().getInputStream(callback, element);
        } else {
            callback.onSuccess(null);
        }
    }

    private boolean tryLock() {
        boolean lockAccess = false;
        if (this.lock.tryLock()) {
            boolean bl = lockAccess = !this.locked;
            if (lockAccess) {
                this.locked = true;
                this.handler.notifyLockStatusChanged();
            }
            this.lock.unlock();
        }
        return lockAccess;
    }

    private void unlock() {
        this.lock.lock();
        this.locked = false;
        this.handler.notifyLockStatusChanged();
        this.lock.unlock();
    }

    public boolean isLocked() {
        return this.locked;
    }

    private TGBrowser getBrowser() {
        return this.browser;
    }

    private void setBrowser(TGBrowser browser) {
        this.browser = browser;
    }

    private class TGBrowserCallBackUnlockWrapper<T>
    extends TGBrowserCallBackWrapper<T> {
        public TGBrowserCallBackUnlockWrapper(TGBrowserCallBack<T> callback) {
            super(callback);
        }

        @Override
        public void handleError(Throwable throwable) {
            TGBrowserConnection.this.unlock();
            super.handleError(throwable);
        }

        @Override
        public void onSuccess(T data) {
            TGBrowserConnection.this.unlock();
            super.onSuccess(data);
        }
    }

    private class TGBrowserCallBackWrapper<T>
    implements TGBrowserCallBack<T> {
        private TGBrowserCallBack<T> callback;

        public TGBrowserCallBackWrapper(TGBrowserCallBack<T> callback) {
            this.callback = callback;
        }

        public void handleError(Throwable throwable) {
            this.callback.handleError(throwable);
        }

        @Override
        public void onSuccess(T data) {
            this.callback.onSuccess(data);
        }
    }
}

