/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.system.keybindings;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.keybindings.KeyBindingAction;
import app.tuxguitar.app.system.keybindings.KeyBindingActionDefaults;
import app.tuxguitar.app.system.keybindings.KeyBindingListener;
import app.tuxguitar.app.system.keybindings.xml.KeyBindingReader;
import app.tuxguitar.app.system.keybindings.xml.KeyBindingWriter;
import app.tuxguitar.app.util.TGFileUtils;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.ui.event.UIKeyPressedListener;
import app.tuxguitar.ui.resource.UIKeyCombination;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class KeyBindingActionManager {
    private TGContext context;
    private List<KeyBindingAction> keyBindingsActions;
    private KeyBindingListener listener;

    private KeyBindingActionManager(TGContext context) {
        this.context = context;
        this.keyBindingsActions = new ArrayList<KeyBindingAction>();
        this.init();
    }

    public void init() {
        this.keyBindingsActions.addAll(this.merge(KeyBindingActionDefaults.getDefaultKeyBindings(this.context), KeyBindingReader.getKeyBindings(this.getUserFileName())));
        this.listener = new KeyBindingListener(this);
    }

    public List<KeyBindingAction> merge(List<KeyBindingAction> defaultsBindings, List<KeyBindingAction> userBindings) {
        if (userBindings == null) {
            return defaultsBindings;
        }
        List<KeyBindingAction> list = userBindings;
        for (KeyBindingAction defaultAction : defaultsBindings) {
            boolean conflict = false;
            for (KeyBindingAction userAction : userBindings) {
                conflict |= userAction.getAction().equals(defaultAction.getAction());
                if (!(conflict |= userAction.getCombination().equals((Object)defaultAction.getCombination()))) continue;
                break;
            }
            if (conflict) continue;
            list.add(defaultAction);
        }
        ArrayList<KeyBindingAction> toRemove = new ArrayList<KeyBindingAction>();
        for (KeyBindingAction action : list) {
            if (!action.getCombination().getKeys().isEmpty()) continue;
            toRemove.add(action);
        }
        for (KeyBindingAction action : toRemove) {
            list.remove(action);
        }
        return list;
    }

    private String getUserFileName() {
        return TGFileUtils.PATH_USER_CONFIG + File.separator + "shortcuts.xml";
    }

    public String getActionForKeyBinding(UIKeyCombination kb) {
        for (KeyBindingAction keyBindingAction : this.keyBindingsActions) {
            if (keyBindingAction.getCombination() == null || !kb.equals((Object)keyBindingAction.getCombination()) || !this.isKeyBindingAvailable(keyBindingAction)) continue;
            return keyBindingAction.getAction();
        }
        return null;
    }

    public UIKeyCombination getKeyBindingForAction(String action) {
        for (KeyBindingAction keyBindingAction : this.keyBindingsActions) {
            if (!action.equals(keyBindingAction.getAction()) || !this.isKeyBindingAvailable(keyBindingAction)) continue;
            return keyBindingAction.getCombination();
        }
        return null;
    }

    public boolean isKeyBindingAvailable(KeyBindingAction keyBindingAction) {
        String actionId = keyBindingAction.getAction();
        if (actionId != null) {
            return TuxGuitar.getInstance().getActionAdapterManager().getKeyBindingActionIds().hasActionId(actionId);
        }
        return false;
    }

    public void reset(List<KeyBindingAction> keyBindings) {
        this.keyBindingsActions.clear();
        this.keyBindingsActions.addAll(keyBindings);
    }

    public List<KeyBindingAction> getKeyBindingActions() {
        return this.keyBindingsActions;
    }

    public void saveKeyBindings() {
        KeyBindingWriter.setBindings(this.getKeyBindingActions(), this.getUserFileName());
    }

    public void appendListenersTo(UIControl control) {
        control.addKeyPressedListener((UIKeyPressedListener)this.listener);
    }

    public void processKeyBinding(UIKeyCombination kb) {
        String actionId = this.getActionForKeyBinding(kb);
        if (actionId != null) {
            new TGActionProcessor(this.context, actionId).process();
        }
    }

    public static KeyBindingActionManager getInstance(TGContext context) {
        return (KeyBindingActionManager)TGSingletonUtil.getInstance((TGContext)context, (String)KeyBindingActionManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<KeyBindingActionManager>(){

            public KeyBindingActionManager createInstance(TGContext context) {
                return new KeyBindingActionManager(context);
            }
        });
    }
}

