/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.system.icons;

import app.tuxguitar.app.system.icons.TGIconTheme;
import app.tuxguitar.app.system.icons.TGSkinManager;
import app.tuxguitar.app.util.TGFileUtils;
import app.tuxguitar.song.models.TGDivisionType;
import app.tuxguitar.ui.resource.UIImage;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TGIconManager {
    private TGContext context;
    private TGIconTheme theme;
    private Map<String, TGIconTheme> themeCache;
    public static final String SEPARATOR = "separator.png";
    public static final String FILE_NEW = "new.png";
    public static final String FILE_OPEN = "open.png";
    public static final String FILE_SAVE = "save.png";
    public static final String FILE_SAVE_AS = "save-as.png";
    public static final String FILE_CLOSE = "close.png";
    public static final String PRINT_PREVIEW = "print-preview.png";
    public static final String EDIT_CUT = "edit_cut.png";
    public static final String EDIT_COPY = "edit_copy.png";
    public static final String EDIT_PASTE = "edit_paste.png";
    public static final String EDIT_REPEAT = "edit_repeat.png";
    public static final String EDIT_MODE_SELECTION = "edit_mode_selection.png";
    public static final String EDIT_MODE_EDITION = "edit_mode_edition.png";
    public static final String EDIT_MODE_EDITION_NO_NATURAL = "edit_mode_edition_no_natural.png";
    public static final String EDIT_MODE_FREE = "edit_mode_free.png";
    public static final String EDIT_MEASURE_STATUS_CHECK = "measure_status_check.png";
    public static final String EDIT_VOICE_1 = "edit_voice_1.png";
    public static final String EDIT_VOICE_2 = "edit_voice_2.png";
    public static final String PRINT = "print.png";
    public static final String UNDO = "edit_undo.png";
    public static final String REDO = "edit_redo.png";
    public static final String TOOLBAR_EDIT = "toolbar_edit.png";
    public static final String TABLE_VIEWER = "table_viewer.png";
    public static final String FRETBOARD = "fretboard.png";
    public static final String INSTRUMENTS = "mixer.png";
    public static final String MATRIX = "matrix.png";
    public static final String PIANO = "piano.png";
    public static final String ZOOM_OUT = "zoom_out.png";
    public static final String ZOOM_RESET = "zoom_original.png";
    public static final String ZOOM_IN = "zoom_in.png";
    public static final String LAYOUT_PAGE = "layout_page.png";
    public static final String LAYOUT_LINEAR = "layout_linear.png";
    public static final String LAYOUT_MULTITRACK = "layout_multitrack.png";
    public static final String LAYOUT_SCORE = "layout_score.png";
    public static final String LAYOUT_TABLATURE = "layout_tablature.png";
    public static final String LAYOUT_COMPACT = "layout_compact.png";
    public static final String TIME_SIGNATURE = "timesignature.png";
    public static final String TEMPO = "tempoicon.png";
    public static final String TEMPO_INDICATOR_ICON = "tempoindicator.png";
    public static final String CLEF = "clef.png";
    public static final String KEY_SIGNATURE = "keysignature.png";
    public static final String TRIPLET_FEEL = "tripletfeel.png";
    public static final String REPEAT_OPEN = "openrepeat.png";
    public static final String REPEAT_CLOSE = "closerepeat.png";
    public static final String REPEAT_ALTERNATIVE = "repeat_alternative.png";
    public static final String SONG_PROPERTIES = "song_properties.png";
    public static final String TRACK_FIRST = "track_first.png";
    public static final String TRACK_LAST = "track_last.png";
    public static final String TRACK_PREVIOUS = "track_previous.png";
    public static final String TRACK_NEXT = "track_next.png";
    public static final String TRACK_ADD = "track_add.png";
    public static final String TRACK_CLONE = "track_clone.png";
    public static final String TRACK_REMOVE = "track_remove.png";
    public static final String TRACK_SOLO = "track_solo.png";
    public static final String TRACK_MUTE = "track_mute.png";
    public static final String MEASURE_FIRST = "measure_first.png";
    public static final String MEASURE_LAST = "measure_last.png";
    public static final String MEASURE_PREVIOUS = "measure_previous.png";
    public static final String MEASURE_NEXT = "measure_next.png";
    public static final String MEASURE_ADD = "measure_add.png";
    public static final String MEASURE_CLEAN = "measure_clean.png";
    public static final String MEASURE_REMOVE = "measure_remove.png";
    public static final String MEASURE_COPY = "measure_copy.png";
    public static final String MEASURE_PASTE = "measure_paste.png";
    public static final String MARKER_ADD = "marker_add.png";
    public static final String MARKER_LIST = "marker_list.png";
    public static final String MARKER_FIRST = "marker_first.png";
    public static final String MARKER_PREVIOUS = "marker_previous.png";
    public static final String MARKER_NEXT = "marker_next.png";
    public static final String MARKER_LAST = "marker_last.png";
    public static final String TRANSPORT = "transport.png";
    public static final String TRANSPORT_ICON_FIRST = "transport_icon_first.png";
    public static final String TRANSPORT_ICON_LAST = "transport_icon_last.png";
    public static final String TRANSPORT_ICON_PREVIOUS = "transport_icon_previous.png";
    public static final String TRANSPORT_ICON_NEXT = "transport_icon_next.png";
    public static final String TRANSPORT_ICON_STOP = "transport_icon_stop.png";
    public static final String TRANSPORT_ICON_PLAY = "transport_icon_play.png";
    public static final String TRANSPORT_ICON_PAUSE = "transport_icon_pause.png";
    public static final String TRANSPORT_TIME_COUNTER = "transport_time_counter.png";
    public static final String TRANSPORT_METRONOME = "transport_metronome.png";
    public static final String TRANSPORT_COUNT_IN = "transport_count_in.png";
    public static final String TRANSPORT_MODE = "transport_mode.png";
    public static final String TRANSPORT_LOOP_START = "transport_loop_start.png";
    public static final String TRANSPORT_LOOP_END = "transport_loop_end.png";
    public static final String TRANSPORT_HIGHLIGHT_PLAYED_BEAT = "highlight_played_beat.png";
    public static final String SETTINGS = "settings.png";
    public static final String LIST_REMOVE = "list_remove.png";
    public static final String ARROW_UP = "arrow_up.png";
    public static final String ARROW_DOWN = "arrow_down.png";
    public static final String ARROW_LEFT = "arrow_left.png";
    public static final String ARROW_RIGHT = "arrow_right.png";
    public static final String DURATION = "duration.png";
    public static final String WHOLE = "1.png";
    public static final String HALF = "2.png";
    public static final String QUARTER = "4.png";
    public static final String EIGHTH = "8.png";
    public static final String SIXTEENTH = "16.png";
    public static final String THIRTYSECOND = "32.png";
    public static final String SIXTYFOURTH = "64.png";
    public static final String DOTTED = "dotted.png";
    public static final String DOUBLE_DOTTED = "doubledotted.png";
    public static final String DIVISION_TYPE = "division-type.png";
    public static final String TIED_NOTE = "tiednote.png";
    public static final String DYNAMIC = "dynamic.png";
    public static final String DYNAMIC_PPP = "dynamic_ppp.png";
    public static final String DYNAMIC_PP = "dynamic_pp.png";
    public static final String DYNAMIC_P = "dynamic_p.png";
    public static final String DYNAMIC_MP = "dynamic_mp.png";
    public static final String DYNAMIC_MF = "dynamic_mf.png";
    public static final String DYNAMIC_F = "dynamic_f.png";
    public static final String DYNAMIC_FF = "dynamic_ff.png";
    public static final String DYNAMIC_FFF = "dynamic_fff.png";
    public static final String EFFECT_VIBRATO = "effect_vibrato.png";
    public static final String EFFECT_BEND = "effect_bend.png";
    public static final String EFFECT_TREMOLO_BAR = "effect_tremolo_bar.png";
    public static final String EFFECT_DEAD = "effect_dead.png";
    public static final String EFFECT_SLIDE = "effect_slide.png";
    public static final String EFFECT_HAMMER = "effect_hammer.png";
    public static final String EFFECT_GHOST = "effect_ghost.png";
    public static final String EFFECT_ACCENTUATED = "effect_accentuated.png";
    public static final String EFFECT_HEAVY_ACCENTUATED = "effect_heavy_accentuated.png";
    public static final String EFFECT_LET_RING = "effect_let_ring.png";
    public static final String EFFECT_HARMONIC = "effect_harmonic.png";
    public static final String EFFECT_GRACE = "effect_grace.png";
    public static final String EFFECT_TRILL = "effect_trill.png";
    public static final String EFFECT_TREMOLO_PICKING = "effect_tremolo_picking.png";
    public static final String EFFECT_PALM_MUTE = "effect_palm_mute.png";
    public static final String EFFECT_STACCATO = "effect_staccato.png";
    public static final String EFFECT_TAPPING = "effect_tapping.png";
    public static final String EFFECT_SLAPPING = "effect_slapping.png";
    public static final String EFFECT_POPPING = "effect_popping.png";
    public static final String EFFECT_FADE_IN = "effect_fade_in.png";
    public static final String CHORD = "chord.png";
    public static final String TEXT = "text.png";
    public static final String STROKE_UP = "stroke_up.png";
    public static final String STROKE_DOWN = "stroke_down.png";
    public static final String PICK_STROKE_UP = "pick_stroke_up.png";
    public static final String PICK_STROKE_DOWN = "pick_stroke_down.png";
    public static final String ALTERNATIVE_ENHARMONIC = "alt_enharmonic.png";
    public static final String TOOLS_PLUGINS = "tools_plugins.png";
    public static final String TOOLS_SHORTCUTS = "tools_shortcuts.png";
    public static final String TOOLS_SETTINGS = "tools_settings.png";
    public static final String HELP_DOC = "help_doc.png";
    public static final String HELP_ABOUT = "help_about.png";
    public static final String GO_HOME = "browser_root.png";
    private UIImage[] durations;
    private UIImage[] durationsDotted;
    private UIImage transportFirst;
    private UIImage transportLast;
    private UIImage transportPrevious;
    private UIImage transportNext;
    private UIImage transportStop;
    private UIImage transportPlay;
    private UIImage transportPause;
    private UIImage marker;
    private UIImage aboutDescription;
    private UIImage aboutLicense;
    private UIImage aboutAuthors;
    private UIImage appIcon;
    private UIImage appSplash;
    private UIImage optionMain;
    private UIImage optionStyle;
    private UIImage optionSound;
    private UIImage optionLanguage;
    private UIImage optionSkin;
    private UIImage fretboardFirstFret;
    private UIImage fretboardFret;
    private UIImage fretboardSmaller;
    private UIImage fretboardBigger;
    private Map<Integer, UIImage> divisionTypes;
    private UIImage fileImport;
    private UIImage fileExport;
    private UIImage fileHistory;
    private UIImage fileExit;
    private UIImage browserNew;
    private UIImage browserFile;
    private UIImage browserFolder;
    private UIImage browserFolderRemote;
    private UIImage browserCollection;
    private UIImage browserRoot;
    private UIImage browserBack;
    private UIImage browserRefresh;
    private UIImage statusQuestion;
    private UIImage statusError;
    private UIImage statusWarning;
    private UIImage statusInfo;
    private UIImage toolbarMain;
    private UIImage listAdd;
    private UIImage listEdit;
    private UIImage solo;
    private UIImage soloDisabled;
    private UIImage soloDim;
    private UIImage soloDisabledDim;
    private UIImage mute;
    private UIImage muteDisabled;
    private UIImage muteDim;
    private UIImage muteDisabledDim;
    private UIImage OK;
    private UIImage KO;

    private TGIconManager(TGContext context) {
        this.context = context;
        this.themeCache = new HashMap<String, TGIconTheme>();
        this.loadIcons();
    }

    public TGIconTheme findIconTheme(String theme) {
        if (this.themeCache.containsKey(theme)) {
            return this.themeCache.get(theme);
        }
        this.themeCache.put(theme, new TGIconTheme(theme));
        return this.findIconTheme(theme);
    }

    public String findConfiguredThemeName() {
        return TGSkinManager.getInstance(this.context).getCurrentSkin();
    }

    public void loadIcons() {
        this.theme = this.findIconTheme(this.findConfiguredThemeName());
        this.durations = new UIImage[]{this.loadIcon(WHOLE), this.loadIcon(HALF), this.loadIcon(QUARTER), this.loadIcon(EIGHTH), this.loadIcon(SIXTEENTH), this.loadIcon(THIRTYSECOND), this.loadIcon(SIXTYFOURTH)};
        this.loadIcon(DURATION);
        this.durationsDotted = new UIImage[]{this.loadIcon("2dotted.png"), this.loadIcon("4dotted.png"), this.loadIcon("8dotted.png")};
        this.loadIcon(LAYOUT_PAGE);
        this.loadIcon(LAYOUT_LINEAR);
        this.loadIcon(LAYOUT_MULTITRACK);
        this.loadIcon(LAYOUT_SCORE);
        this.loadIcon(LAYOUT_TABLATURE);
        this.loadIcon(LAYOUT_COMPACT);
        this.loadIcon(TRANSPORT_HIGHLIGHT_PLAYED_BEAT);
        this.loadIcon(SEPARATOR);
        this.loadIcon(FILE_NEW);
        this.loadIcon(FILE_OPEN);
        this.loadIcon(FILE_CLOSE);
        this.loadIcon(FILE_SAVE);
        this.loadIcon(FILE_SAVE_AS);
        this.fileImport = this.loadIcon("import.png");
        this.fileExport = this.loadIcon("export.png");
        this.loadIcon(PRINT);
        this.loadIcon(PRINT_PREVIEW);
        this.fileHistory = this.loadIcon("history.png");
        this.fileExit = this.loadIcon("exit.png");
        this.loadIcon(EDIT_CUT);
        this.loadIcon(EDIT_COPY);
        this.loadIcon(EDIT_PASTE);
        this.loadIcon(EDIT_REPEAT);
        this.loadIcon(UNDO);
        this.loadIcon(REDO);
        this.loadIcon(EDIT_VOICE_1);
        this.loadIcon(EDIT_VOICE_2);
        this.loadIcon(EDIT_MODE_SELECTION);
        this.loadIcon(EDIT_MODE_EDITION);
        this.loadIcon(EDIT_MODE_EDITION_NO_NATURAL);
        this.loadIcon(EDIT_MODE_FREE);
        this.loadIcon(EDIT_MEASURE_STATUS_CHECK);
        this.loadIcon(HELP_DOC);
        this.loadIcon(HELP_ABOUT);
        this.loadIcon(GO_HOME);
        this.appIcon = this.loadIcon("icon.png");
        this.appSplash = this.loadIcon("splash.png");
        this.aboutDescription = this.loadIcon("about_description.png");
        this.aboutLicense = this.loadIcon("about_license.png");
        this.aboutAuthors = this.loadIcon("about_authors.png");
        this.optionMain = this.loadIcon("option_view.png");
        this.optionStyle = this.loadIcon("option_style.png");
        this.optionSound = this.loadIcon("option_sound.png");
        this.optionSkin = this.loadIcon("option_skin.png");
        this.optionLanguage = this.loadIcon("option_language.png");
        this.loadIcon(TIME_SIGNATURE);
        this.loadIcon(TEMPO);
        this.loadIcon(TEMPO_INDICATOR_ICON);
        this.loadIcon(CLEF);
        this.loadIcon(KEY_SIGNATURE);
        this.loadIcon(TRIPLET_FEEL);
        this.loadIcon(REPEAT_OPEN);
        this.loadIcon(REPEAT_CLOSE);
        this.loadIcon(REPEAT_ALTERNATIVE);
        this.loadIcon(SONG_PROPERTIES);
        this.loadIcon(TRACK_FIRST);
        this.loadIcon(TRACK_LAST);
        this.loadIcon(TRACK_PREVIOUS);
        this.loadIcon(TRACK_NEXT);
        this.loadIcon(TRACK_ADD);
        this.loadIcon(TRACK_CLONE);
        this.loadIcon(TRACK_REMOVE);
        this.loadIcon(TRACK_SOLO);
        this.loadIcon(TRACK_MUTE);
        this.loadIcon(DOTTED);
        this.loadIcon(DOUBLE_DOTTED);
        this.loadIcon(DIVISION_TYPE);
        this.divisionTypes = new HashMap<Integer, UIImage>();
        for (int i = 0; i < TGDivisionType.DIVISION_TYPES.length; ++i) {
            Integer enters = TGDivisionType.DIVISION_TYPES[i].getEnters();
            this.divisionTypes.put(enters, this.loadIcon(TGIconManager.getDivisionTypeIconFileName(enters)));
        }
        this.loadIcon(FRETBOARD);
        this.fretboardFirstFret = this.loadIcon("firstfret.png");
        this.fretboardFret = this.loadIcon("fret.png");
        this.fretboardSmaller = this.loadIcon("fretboard_smaller.png");
        this.fretboardBigger = this.loadIcon("fretboard_bigger.png");
        this.loadIcon(CHORD);
        this.loadIcon(TEXT);
        this.loadIcon(TIED_NOTE);
        this.loadIcon(TRANSPORT);
        this.transportFirst = this.loadIcon("transport_first.png");
        this.transportLast = this.loadIcon("transport_last.png");
        this.transportPrevious = this.loadIcon("transport_previous.png");
        this.transportNext = this.loadIcon("transport_next.png");
        this.transportStop = this.loadIcon("transport_stop.png");
        this.transportPlay = this.loadIcon("transport_play.png");
        this.transportPause = this.loadIcon("transport_pause.png");
        this.loadIcon(TRANSPORT_ICON_FIRST);
        this.loadIcon(TRANSPORT_ICON_LAST);
        this.loadIcon(TRANSPORT_ICON_PREVIOUS);
        this.loadIcon(TRANSPORT_ICON_NEXT);
        this.loadIcon(TRANSPORT_ICON_STOP);
        this.loadIcon(TRANSPORT_ICON_PLAY);
        this.loadIcon(TRANSPORT_ICON_PAUSE);
        this.loadIcon(TRANSPORT_TIME_COUNTER);
        this.loadIcon(TRANSPORT_METRONOME);
        this.loadIcon(TRANSPORT_COUNT_IN);
        this.loadIcon(TRANSPORT_MODE);
        this.loadIcon(TRANSPORT_LOOP_START);
        this.loadIcon(TRANSPORT_LOOP_END);
        this.loadIcon(MARKER_LIST);
        this.marker = this.loadIcon("marker.png");
        this.loadIcon(MARKER_ADD);
        this.loadIcon(MARKER_FIRST);
        this.loadIcon(MARKER_LAST);
        this.loadIcon(MARKER_PREVIOUS);
        this.loadIcon(MARKER_NEXT);
        this.loadIcon(MEASURE_FIRST);
        this.loadIcon(MEASURE_LAST);
        this.loadIcon(MEASURE_PREVIOUS);
        this.loadIcon(MEASURE_NEXT);
        this.loadIcon(MEASURE_ADD);
        this.loadIcon(MEASURE_CLEAN);
        this.loadIcon(MEASURE_REMOVE);
        this.loadIcon(MEASURE_COPY);
        this.loadIcon(MEASURE_PASTE);
        this.loadIcon(INSTRUMENTS);
        this.loadIcon(MATRIX);
        this.loadIcon(PIANO);
        this.loadIcon(DYNAMIC);
        this.loadIcon(DYNAMIC_PPP);
        this.loadIcon(DYNAMIC_PP);
        this.loadIcon(DYNAMIC_P);
        this.loadIcon(DYNAMIC_MP);
        this.loadIcon(DYNAMIC_MF);
        this.loadIcon(DYNAMIC_F);
        this.loadIcon(DYNAMIC_FF);
        this.loadIcon(DYNAMIC_FFF);
        this.loadIcon(EFFECT_VIBRATO);
        this.loadIcon(EFFECT_BEND);
        this.loadIcon(EFFECT_TREMOLO_BAR);
        this.loadIcon(EFFECT_DEAD);
        this.loadIcon(EFFECT_SLIDE);
        this.loadIcon(EFFECT_HAMMER);
        this.loadIcon(EFFECT_GHOST);
        this.loadIcon(EFFECT_ACCENTUATED);
        this.loadIcon(EFFECT_HEAVY_ACCENTUATED);
        this.loadIcon(EFFECT_LET_RING);
        this.loadIcon(EFFECT_HARMONIC);
        this.loadIcon(EFFECT_GRACE);
        this.loadIcon(EFFECT_TRILL);
        this.loadIcon(EFFECT_TREMOLO_PICKING);
        this.loadIcon(EFFECT_PALM_MUTE);
        this.loadIcon(EFFECT_STACCATO);
        this.loadIcon(EFFECT_TAPPING);
        this.loadIcon(EFFECT_SLAPPING);
        this.loadIcon(EFFECT_POPPING);
        this.loadIcon(EFFECT_FADE_IN);
        this.browserNew = this.loadIcon("browser_new.png");
        this.browserFile = this.loadIcon("browser_file.png");
        this.browserFolder = this.loadIcon("browser_folder.png");
        this.browserFolderRemote = this.loadIcon("browser_folder_remote.png");
        this.browserCollection = this.loadIcon("browser_collection.png");
        this.browserRoot = this.loadIcon(GO_HOME);
        this.browserBack = this.loadIcon("browser_back.png");
        this.browserRefresh = this.loadIcon("browser_refresh.png");
        this.loadIcon(ARROW_UP);
        this.loadIcon(ARROW_DOWN);
        this.loadIcon(ARROW_LEFT);
        this.loadIcon(ARROW_RIGHT);
        this.statusQuestion = this.loadIcon("status_question.png");
        this.statusError = this.loadIcon("status_error.png");
        this.statusWarning = this.loadIcon("status_warning.png");
        this.statusInfo = this.loadIcon("status_info.png");
        this.loadIcon(STROKE_UP);
        this.loadIcon(STROKE_DOWN);
        this.loadIcon(PICK_STROKE_UP);
        this.loadIcon(PICK_STROKE_DOWN);
        this.loadIcon(ALTERNATIVE_ENHARMONIC);
        this.loadIcon(SETTINGS);
        this.toolbarMain = this.loadIcon("toolbar_main.png");
        this.loadIcon(TOOLBAR_EDIT);
        this.loadIcon(TABLE_VIEWER);
        this.listAdd = this.loadIcon("list_add.png");
        this.listEdit = this.loadIcon("list_edit.png");
        this.loadIcon(LIST_REMOVE);
        this.solo = this.loadIcon("solo.png");
        this.soloDisabled = this.loadIcon("solo-disabled.png");
        this.soloDim = this.loadIcon("solo-dim.png");
        this.soloDisabledDim = this.loadIcon("solo-disabled-dim.png");
        this.loadIcon(TOOLS_PLUGINS);
        this.loadIcon(TOOLS_SHORTCUTS);
        this.loadIcon(TOOLS_SETTINGS);
        this.mute = this.loadIcon("mute.png");
        this.muteDisabled = this.loadIcon("mute-disabled.png");
        this.muteDim = this.loadIcon("mute-dim.png");
        this.muteDisabledDim = this.loadIcon("mute-disabled-dim.png");
        this.loadIcon(ZOOM_OUT);
        this.loadIcon(ZOOM_RESET);
        this.loadIcon(ZOOM_IN);
        this.OK = this.loadIcon("measure_status_ok.png");
        this.KO = this.loadIcon("measure_status_error.png");
    }

    private UIImage loadIcon(String name) {
        UIImage image = this.theme.getResource(name);
        if (image == null) {
            image = TGFileUtils.loadImage(this.context, this.theme.getName(), name);
            this.theme.setResource(name, image);
        }
        return image;
    }

    public void disposeThemes() {
        ArrayList<String> themes = new ArrayList<String>(this.themeCache.keySet());
        for (String theme : themes) {
            this.disposeTheme(this.themeCache.remove(theme));
        }
    }

    public void disposeTheme(TGIconTheme theme) {
        ArrayList<UIImage> uiImages = new ArrayList<UIImage>(theme.getResources().values());
        for (UIImage uiImage : uiImages) {
            uiImage.dispose();
        }
    }

    public void onSkinDisposed() {
        this.disposeThemes();
    }

    public void onSkinChange() {
        this.loadIcons();
    }

    public UIImage getDuration(int value, boolean dotted) {
        return dotted ? this.getDurationDotted(value) : this.getDuration(value);
    }

    public UIImage getDuration(int value) {
        switch (value) {
            case 1: {
                return this.durations[0];
            }
            case 2: {
                return this.durations[1];
            }
            case 4: {
                return this.durations[2];
            }
            case 8: {
                return this.durations[3];
            }
            case 16: {
                return this.durations[4];
            }
            case 32: {
                return this.durations[5];
            }
            case 64: {
                return this.durations[6];
            }
        }
        return null;
    }

    public UIImage getDurationDotted(int value) {
        switch (value) {
            case 2: {
                return this.durationsDotted[0];
            }
            case 4: {
                return this.durationsDotted[1];
            }
            case 8: {
                return this.durationsDotted[2];
            }
        }
        return null;
    }

    public UIImage getAboutAuthors() {
        return this.aboutAuthors;
    }

    public UIImage getAboutDescription() {
        return this.aboutDescription;
    }

    public UIImage getAboutLicense() {
        return this.aboutLicense;
    }

    public UIImage getAppIcon() {
        return this.appIcon;
    }

    public UIImage getAppSplash() {
        return this.appSplash;
    }

    public UIImage getDivisionType(int divisionTypeEnters) {
        return this.divisionTypes.get(divisionTypeEnters);
    }

    public static String getDivisionTypeIconFileName(int divisionTypeEnters) {
        return "division-type-" + String.valueOf(divisionTypeEnters) + ".png";
    }

    public UIImage getFileHistory() {
        return this.fileHistory;
    }

    public UIImage getFileExit() {
        return this.fileExit;
    }

    public UIImage getFileImport() {
        return this.fileImport;
    }

    public UIImage getFileExport() {
        return this.fileExport;
    }

    public UIImage getFretboardFirstFret() {
        return this.fretboardFirstFret;
    }

    public UIImage getFretboardFret() {
        return this.fretboardFret;
    }

    public UIImage getFretboardSmaller() {
        return this.fretboardSmaller;
    }

    public UIImage getFretboardBigger() {
        return this.fretboardBigger;
    }

    public UIImage getMarker() {
        return this.marker;
    }

    public UIImage getOptionLanguage() {
        return this.optionLanguage;
    }

    public UIImage getOptionMain() {
        return this.optionMain;
    }

    public UIImage getOptionSound() {
        return this.optionSound;
    }

    public UIImage getOptionStyle() {
        return this.optionStyle;
    }

    public UIImage getOptionSkin() {
        return this.optionSkin;
    }

    public UIImage getTransportFirst() {
        return this.transportFirst;
    }

    public UIImage getTransportLast() {
        return this.transportLast;
    }

    public UIImage getTransportNext() {
        return this.transportNext;
    }

    public UIImage getTransportPause() {
        return this.transportPause;
    }

    public UIImage getTransportPlay() {
        return this.transportPlay;
    }

    public UIImage getTransportPrevious() {
        return this.transportPrevious;
    }

    public UIImage getTransportStop() {
        return this.transportStop;
    }

    public UIImage getBrowserBack() {
        return this.browserBack;
    }

    public UIImage getBrowserFile() {
        return this.browserFile;
    }

    public UIImage getBrowserFolder() {
        return this.browserFolder;
    }

    public UIImage getBrowserFolderRemote() {
        return this.browserFolderRemote;
    }

    public UIImage getBrowserCollection() {
        return this.browserCollection;
    }

    public UIImage getBrowserRefresh() {
        return this.browserRefresh;
    }

    public UIImage getBrowserRoot() {
        return this.browserRoot;
    }

    public UIImage getBrowserNew() {
        return this.browserNew;
    }

    public UIImage getToolbarMain() {
        return this.toolbarMain;
    }

    public UIImage getStatusQuestion() {
        return this.statusQuestion;
    }

    public UIImage getStatusError() {
        return this.statusError;
    }

    public UIImage getStatusWarning() {
        return this.statusWarning;
    }

    public UIImage getStatusInfo() {
        return this.statusInfo;
    }

    public UIImage getListAdd() {
        return this.listAdd;
    }

    public UIImage getListEdit() {
        return this.listEdit;
    }

    public UIImage getSolo() {
        return this.solo;
    }

    public UIImage getSoloDisabled() {
        return this.soloDisabled;
    }

    public UIImage getSoloDim() {
        return this.soloDim;
    }

    public UIImage getSoloDisabledDim() {
        return this.soloDisabledDim;
    }

    public UIImage getMute() {
        return this.mute;
    }

    public UIImage getMuteDisabled() {
        return this.muteDisabled;
    }

    public UIImage getMuteDim() {
        return this.muteDim;
    }

    public UIImage getMuteDisabledDim() {
        return this.muteDisabledDim;
    }

    public UIImage getOK() {
        return this.OK;
    }

    public UIImage getKO() {
        return this.KO;
    }

    public UIImage getImageByName(String name) {
        return this.theme.getResource(name);
    }

    public static TGIconManager getInstance(TGContext context) {
        return (TGIconManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGIconManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGIconManager>(){

            public TGIconManager createInstance(TGContext context) {
                return new TGIconManager(context);
            }
        });
    }
}

