/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.listener.lock;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionException;
import app.tuxguitar.action.TGActionInterceptor;
import app.tuxguitar.app.action.listener.thread.TGSyncThreadAction;
import app.tuxguitar.editor.TGEditorManager;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.List;

public class TGLockableActionListener
extends TGSyncThreadAction
implements TGActionInterceptor,
TGEventListener {
    private static final String INTERCEPTOR_BY_PASS = TGLockableActionListener.class.getSimpleName() + "-interceptor-by-pass";
    private List<String> actionIds = new ArrayList<String>();

    public TGLockableActionListener(TGContext context) {
        super(context);
    }

    public boolean containsActionId(String id) {
        return this.actionIds.contains(id);
    }

    public void addActionId(String id) {
        this.actionIds.add(id);
    }

    public void removeActionId(String id) {
        this.actionIds.remove(id);
    }

    public void checkForLock(String actionId) {
        if (this.containsActionId(actionId)) {
            TGEditorManager.getInstance((TGContext)this.getContext()).lock();
        }
    }

    public void checkForUnlock(String actionId) {
        if (this.containsActionId(actionId)) {
            TGEditorManager.getInstance((TGContext)this.getContext()).unlock();
        }
    }

    public void setByPassInContext(TGActionContext context, boolean byPass) {
        context.setAttribute(INTERCEPTOR_BY_PASS, (Object)byPass);
    }

    public boolean isByPassInContext(TGActionContext context) {
        return Boolean.TRUE.equals(context.getAttribute(INTERCEPTOR_BY_PASS));
    }

    public void processEvent(TGEvent event) {
        if ("action-pre-execution".equals(event.getEventType())) {
            this.checkForLock((String)event.getAttribute("actionId"));
        } else if ("action-post-execution".equals(event.getEventType())) {
            this.checkForUnlock((String)event.getAttribute("actionId"));
        } else if ("action-error".equals(event.getEventType())) {
            this.checkForUnlock((String)event.getAttribute("actionId"));
        }
    }

    public boolean intercept(String id, TGActionContext context) throws TGActionException {
        if (!this.isByPassInContext(context) && this.isUiThread() && this.containsActionId(id)) {
            this.runInUiThread(id, context);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeInterceptedAction(String actionId, TGActionContext context) {
        TGEditorManager editor = TGEditorManager.getInstance((TGContext)this.getContext());
        if (editor.tryLock()) {
            try {
                this.setByPassInContext(context, true);
                super.executeInterceptedAction(actionId, context);
                this.setByPassInContext(context, false);
            }
            finally {
                editor.unlock();
            }
        } else {
            this.runInUiThread(actionId, context);
        }
    }
}

