/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.impl.tools;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGContext;

public class TGTransposeAction
extends TGActionBase {
    public static final String NAME = "action.tools.transpose-notes";
    public static final String ATTRIBUTE_TRANSPOSITION = "transposition";
    public static final String ATTRIBUTE_TRY_KEEP_STRING = "tryKeepString";
    public static final String ATTRIBUTE_APPLY_TO_CHORDS = "applyToChords";
    public static final String ATTRIBUTE_APPLY_TO_ALL_TRACKS = "applyToAllTracks";
    public static final String ATTRIBUTE_APPLY_TO_ALL_MEASURES = "applyToAllMeasures";

    public TGTransposeAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        TGSongManager songManager = (TGSongManager)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        TGTrack contextTrack = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        TGMeasure contextMeasure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        Integer transposition = (Integer)context.getAttribute(ATTRIBUTE_TRANSPOSITION);
        Boolean tryKeepString = Boolean.TRUE.equals(context.getAttribute(ATTRIBUTE_TRY_KEEP_STRING));
        Boolean applyToChords = Boolean.TRUE.equals(context.getAttribute(ATTRIBUTE_APPLY_TO_CHORDS));
        Boolean applyToAllTracks = Boolean.TRUE.equals(context.getAttribute(ATTRIBUTE_APPLY_TO_ALL_TRACKS));
        Boolean applyToAllMeasures = Boolean.TRUE.equals(context.getAttribute(ATTRIBUTE_APPLY_TO_ALL_MEASURES));
        if (applyToAllMeasures.booleanValue()) {
            if (applyToAllTracks.booleanValue()) {
                for (int i = 0; i < song.countTracks(); ++i) {
                    this.transposeTrack(songManager, song, song.getTrack(i), transposition, tryKeepString, applyToChords);
                }
            } else {
                this.transposeTrack(songManager, song, contextTrack, transposition, tryKeepString, applyToChords);
            }
        } else if (applyToAllTracks.booleanValue()) {
            for (int i = 0; i < song.countTracks(); ++i) {
                TGTrack track = song.getTrack(i);
                TGMeasure measure = songManager.getTrackManager().getMeasure(track, contextMeasure.getNumber());
                if (measure == null) continue;
                this.transposeMeasure(songManager, song, measure, transposition, tryKeepString, applyToChords);
            }
        } else {
            this.transposeMeasure(songManager, song, contextMeasure, transposition, tryKeepString, applyToChords);
        }
    }

    public void transposeMeasure(TGSongManager songManager, TGSong song, TGMeasure measure, int transposition, boolean tryKeepString, boolean applyToChords) {
        if (transposition != 0 && !songManager.isPercussionChannel(song, measure.getTrack().getChannelId())) {
            songManager.getMeasureManager().transposeNotes(measure, transposition, tryKeepString, applyToChords, -1);
        }
    }

    public void transposeTrack(TGSongManager songManager, TGSong song, TGTrack track, int transposition, boolean tryKeepString, boolean applyToChords) {
        if (transposition != 0 && !songManager.isPercussionChannel(song, track.getChannelId())) {
            songManager.getTrackManager().transposeNotes(track, transposition, tryKeepString, applyToChords, -1);
        }
    }
}

