/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.impl.caret;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.config.TGConfigManager;
import app.tuxguitar.app.transport.TGTransport;
import app.tuxguitar.app.view.component.tab.Caret;
import app.tuxguitar.app.view.component.tab.Tablature;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.graphics.control.TGBeatImpl;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.util.TGContext;

public class TGGoRightAction
extends TGActionBase {
    public static final String NAME = "action.caret.go-right";

    public TGGoRightAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        if (MidiPlayer.getInstance((TGContext)this.getContext()).isRunning()) {
            TGTransport.getInstance(this.getContext()).gotoNext();
        } else {
            TGBeatImpl beat;
            boolean playWhenMoving;
            Caret caret;
            Tablature tablature = TablatureEditor.getInstance(this.getContext()).getTablature();
            if (!Boolean.TRUE.equals(context.getAttribute("keep-selection"))) {
                tablature.getSelector().clearSelection();
            }
            if (!(caret = tablature.getCaret()).moveRight()) {
                TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
                context.setAttribute("measureNumber", (Object)(song.countMeasureHeaders() + 1));
                TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
                tgActionManager.execute("action.measure.add", context);
                caret.moveRight();
            }
            if ((playWhenMoving = TGConfigManager.getInstance(this.getContext()).getBooleanValue("play.when.moving")) && (beat = caret.getSelectedBeat()) != null) {
                TuxGuitar tuxguitar = TuxGuitar.getInstance();
                tuxguitar.playBeat((TGBeat)beat);
            }
        }
    }
}

