/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.lilypond;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.io.lilypond.LilypondSettings;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UICheckBox;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UITextField;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;

public class LilypondSettingsDialog {
    private TGContext context;
    private TGSong song;

    public LilypondSettingsDialog(TGContext context, TGSong song) {
        this.context = context;
        this.song = song;
    }

    public void open(final LilypondSettings settings, final Runnable onSuccess) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UIWindow uiParent = TGWindow.getInstance((TGContext)this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty((String)"lilypond.options"));
        UITableLayout columnLeftLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel columnLeft = uiFactory.createPanel((UIContainer)dialog, false);
        columnLeft.setLayout((UILayout)columnLeftLayout);
        dialogLayout.set((UIControl)columnLeft, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(200.0f), null, Float.valueOf(0.0f));
        UITableLayout columnRightLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel columnRight = uiFactory.createPanel((UIContainer)dialog, false);
        columnRight.setLayout((UILayout)columnRightLayout);
        dialogLayout.set((UIControl)columnRight, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(200.0f), null, Float.valueOf(0.0f));
        UITableLayout trackLayout = new UITableLayout();
        UILegendPanel trackGroup = uiFactory.createLegendPanel((UIContainer)columnLeft);
        trackGroup.setLayout((UILayout)trackLayout);
        trackGroup.setText(TuxGuitar.getProperty((String)"lilypond.options.select-track.tip"));
        columnLeftLayout.set((UIControl)trackGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UILabel trackLabel = uiFactory.createLabel((UIContainer)trackGroup);
        trackLabel.setText(TuxGuitar.getProperty((String)"lilypond.options.select-track") + ":");
        trackLayout.set((UIControl)trackLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIDropDownSelect trackCombo = uiFactory.createDropDownSelect((UIContainer)trackGroup);
        for (int number = 1; number <= this.song.countTracks(); ++number) {
            trackCombo.addItem(new UISelectItem(TuxGuitar.getInstance().getSongManager().getTrack(this.song, number).getName(), (Object)number));
        }
        trackCombo.setSelectedValue((Object)TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber());
        trackCombo.setEnabled(settings.getTrack() != -1);
        trackLayout.set((UIControl)trackCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(120.0f), null, null);
        final UICheckBox trackAllCheck = uiFactory.createCheckBox((UIContainer)trackGroup);
        trackAllCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.select-all-tracks"));
        trackAllCheck.setSelected(settings.getTrack() == -1);
        trackLayout.set((UIControl)trackAllCheck, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        UITableLayout measureRangeLayout = new UITableLayout();
        UILegendPanel measureRange = uiFactory.createLegendPanel((UIContainer)columnLeft);
        measureRange.setLayout((UILayout)measureRangeLayout);
        measureRange.setText(TuxGuitar.getProperty((String)"lilypond.options.measure-range.tip"));
        columnLeftLayout.set((UIControl)measureRange, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        boolean minSelection = true;
        final int maxSelection = this.song.countMeasureHeaders();
        UILabel measureFromLabel = uiFactory.createLabel((UIContainer)measureRange);
        measureFromLabel.setText(TuxGuitar.getProperty((String)"lilypond.options.measure-range.from") + ":");
        measureRangeLayout.set((UIControl)measureFromLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UISpinner measureFromSpinner = uiFactory.createSpinner((UIContainer)measureRange);
        measureFromSpinner.setMaximum(maxSelection);
        measureFromSpinner.setMinimum(1);
        measureFromSpinner.setValue(1);
        measureRangeLayout.set((UIControl)measureFromSpinner, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(60.0f), null, null);
        UILabel measureToLabel = uiFactory.createLabel((UIContainer)measureRange);
        measureToLabel.setText(TuxGuitar.getProperty((String)"lilypond.options.measure-range.to") + ":");
        measureRangeLayout.set((UIControl)measureToLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UISpinner measureToSpinner = uiFactory.createSpinner((UIContainer)measureRange);
        measureToSpinner.setMinimum(1);
        measureToSpinner.setMaximum(maxSelection);
        measureToSpinner.setValue(maxSelection);
        measureRangeLayout.set((UIControl)measureToSpinner, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(60.0f), null, null);
        measureFromSpinner.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ LilypondSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                int fromSelection = measureFromSpinner.getValue();
                int toSelection = measureToSpinner.getValue();
                if (fromSelection < 1) {
                    measureFromSpinner.setValue(1);
                } else if (fromSelection > toSelection) {
                    measureFromSpinner.setValue(toSelection);
                }
            }
        });
        measureToSpinner.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ LilypondSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                int fromSelection;
                int toSelection = measureToSpinner.getValue();
                if (toSelection < (fromSelection = measureFromSpinner.getValue())) {
                    measureToSpinner.setValue(fromSelection);
                } else if (toSelection > maxSelection) {
                    measureToSpinner.setValue(maxSelection);
                }
            }
        });
        UITableLayout versionLayout = new UITableLayout();
        UILegendPanel versionGroup = uiFactory.createLegendPanel((UIContainer)columnRight);
        versionGroup.setLayout((UILayout)versionLayout);
        versionGroup.setText(TuxGuitar.getProperty((String)"lilypond.options.format-version"));
        columnRightLayout.set((UIControl)versionGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UITextField lilyVersion = uiFactory.createTextField((UIContainer)versionGroup);
        lilyVersion.setText(settings.getLilypondVersion());
        versionLayout.set((UIControl)lilyVersion, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout layoutGroupLayout = new UITableLayout();
        UILegendPanel layoutGroup = uiFactory.createLegendPanel((UIContainer)columnRight);
        layoutGroup.setLayout((UILayout)layoutGroupLayout);
        layoutGroup.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.tip"));
        columnRightLayout.set((UIControl)layoutGroup, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox scoreCheck = uiFactory.createCheckBox((UIContainer)layoutGroup);
        scoreCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-score"));
        scoreCheck.setSelected(settings.isScoreEnabled());
        layoutGroupLayout.set((UIControl)scoreCheck, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        final UICheckBox tablatureCheck = uiFactory.createCheckBox((UIContainer)layoutGroup);
        tablatureCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-tablature"));
        tablatureCheck.setSelected(settings.isTablatureEnabled());
        layoutGroupLayout.set((UIControl)tablatureCheck, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        final UICheckBox trackGroupCheck = uiFactory.createCheckBox((UIContainer)layoutGroup);
        trackGroupCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-track-groups"));
        trackGroupCheck.setSelected(settings.isTrackGroupEnabled());
        trackGroupCheck.setEnabled(settings.getTrack() == -1);
        layoutGroupLayout.set((UIControl)trackGroupCheck, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        final UICheckBox trackNameCheck = uiFactory.createCheckBox((UIContainer)layoutGroup);
        trackNameCheck.setSelected(settings.isTrackNameEnabled());
        trackNameCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-track-names"));
        layoutGroupLayout.set((UIControl)trackNameCheck, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        final UICheckBox lyricsCheck = uiFactory.createCheckBox((UIContainer)layoutGroup);
        lyricsCheck.setSelected(settings.isLyricsEnabled());
        lyricsCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-lyrics"));
        layoutGroupLayout.set((UIControl)lyricsCheck, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        final UICheckBox textsCheck = uiFactory.createCheckBox((UIContainer)layoutGroup);
        textsCheck.setSelected(settings.isTextEnabled());
        textsCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-texts"));
        layoutGroupLayout.set((UIControl)textsCheck, Integer.valueOf(6), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        final UICheckBox chordDiagramsCheck = uiFactory.createCheckBox((UIContainer)layoutGroup);
        chordDiagramsCheck.setSelected(settings.isChordDiagramEnabled());
        chordDiagramsCheck.setText(TuxGuitar.getProperty((String)"lilypond.options.layout.enable-chord-diagrams"));
        layoutGroupLayout.set((UIControl)chordDiagramsCheck, Integer.valueOf(7), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        tablatureCheck.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ LilypondSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                if (!tablatureCheck.isSelected()) {
                    scoreCheck.setSelected(true);
                }
            }
        });
        scoreCheck.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ LilypondSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                if (!scoreCheck.isSelected()) {
                    tablatureCheck.setSelected(true);
                }
            }
        });
        trackAllCheck.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ LilypondSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                trackLabel.setEnabled(!trackAllCheck.isSelected());
                trackCombo.setEnabled(!trackAllCheck.isSelected());
                trackGroupCheck.setEnabled(trackAllCheck.isSelected());
            }
        });
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(2));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ LilypondSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                Integer selectedTrack = (Integer)trackCombo.getSelectedValue();
                settings.setTrack(trackAllCheck.isSelected() || selectedTrack == null ? -1 : selectedTrack);
                settings.setTrackGroupEnabled(trackAllCheck.isSelected() ? trackGroupCheck.isSelected() : false);
                settings.setTrackNameEnabled(trackNameCheck.isSelected());
                settings.setMeasureFrom(measureFromSpinner.getValue());
                settings.setMeasureTo(measureToSpinner.getValue());
                settings.setScoreEnabled(scoreCheck.isSelected());
                settings.setTablatureEnabled(tablatureCheck.isSelected());
                settings.setChordDiagramEnabled(chordDiagramsCheck.isSelected());
                settings.setLyricsEnabled(lyricsCheck.isSelected());
                settings.setTextEnabled(textsCheck.isSelected());
                settings.setLilypondVersion(lilyVersion.getText());
                settings.check();
                dialog.dispose();
                onSuccess.run();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ LilypondSettingsDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }
}

