/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.track;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGLyric;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGContext;

public class TGUndoableTrackLyrics
extends TGUndoableTrackBase {
    private int doAction;
    private int trackNumber;
    private TGLyric undoLyric;
    private TGLyric redoLyric;

    private TGUndoableTrackLyrics(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.setTrackLyrics(actionContext, this.getTrack(this.trackNumber), this.redoLyric.clone(this.getSongManager().getFactory()));
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.setTrackLyrics(actionContext, this.getTrack(this.trackNumber), this.undoLyric.clone(this.getSongManager().getFactory()));
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTrackLyrics startUndo(TGContext context, TGTrack track) {
        TGUndoableTrackLyrics undoable = new TGUndoableTrackLyrics(context);
        undoable.doAction = 1;
        undoable.trackNumber = track.getNumber();
        undoable.undoLyric = track.getLyrics().clone(new TGFactory());
        return undoable;
    }

    public TGUndoableTrackLyrics endUndo(TGTrack track) {
        this.redoLyric = track.getLyrics().clone(new TGFactory());
        return this;
    }

    public TGTrack getTrack(int number) {
        return this.getSongManager().getTrack(this.getSong(), number);
    }

    public TGChannel getChannel(int channelId) {
        return this.getSongManager().getChannel(this.getSong(), channelId);
    }
}

