/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.custom;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.util.TGContext;

public class TGUndoableCloseRepeat
extends TGUndoableEditBase {
    private int doAction;
    private long position;
    private int undoRepeatClose;
    private int redoRepeatClose;

    private TGUndoableCloseRepeat(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeCloseRepeat(actionContext, this.getMeasureHeaderAt(this.position), this.redoRepeatClose);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.changeCloseRepeat(actionContext, this.getMeasureHeaderAt(this.position), this.undoRepeatClose);
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableCloseRepeat startUndo(TGContext context, TGMeasureHeader header) {
        TGUndoableCloseRepeat undoable = new TGUndoableCloseRepeat(context);
        undoable.doAction = 1;
        undoable.position = header.getStart();
        undoable.undoRepeatClose = header.getRepeatClose();
        return undoable;
    }

    public TGUndoableCloseRepeat endUndo(int redoRepeatClose) {
        this.redoRepeatClose = redoRepeatClose;
        return this;
    }

    public TGMeasureHeader getMeasureHeaderAt(Long start) {
        return this.getSongManager().getMeasureHeaderAt(this.getSong(), start.longValue());
    }

    public void changeCloseRepeat(TGActionContext context, TGMeasureHeader header, Integer repeatCount) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.insert.close-repeat");
        tgActionProcessor.setAttribute("repeatCount", repeatCount);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, header);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }
}

