/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.action.note;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.song.managers.TGMeasureManager;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGNoteRange;
import java.util.Iterator;

public abstract class TGTransposeNoteSemitoneAction
extends TGActionBase {
    public TGTransposeNoteSemitoneAction(TGContext context, String name) {
        super(context, name);
    }

    protected abstract boolean transposeSemiTone(TGMeasureManager var1, TGMeasure var2, TGBeat var3, TGNote var4);

    protected abstract boolean canTransposeSemiTone(TGMeasureManager var1, TGMeasure var2, TGBeat var3, TGNote var4);

    @Override
    protected void processAction(TGActionContext context) {
        TGNoteRange noteRange = (TGNoteRange)context.getAttribute("note-range");
        TGSongManager songManager = this.getSongManager(context);
        if (noteRange != null && !noteRange.isEmpty()) {
            boolean success;
            TGNote note;
            TGBeat beat;
            TGMeasure measure;
            Iterator it = noteRange.getNotes().iterator();
            for (success = true; it.hasNext() && success; success &= this.canTransposeSemiTone(songManager.getMeasureManager(), measure, beat, note)) {
                note = (TGNote)it.next();
                beat = note.getVoice().getBeat();
                measure = beat.getMeasure();
            }
            if (success) {
                boolean moreThanOneBeat = false;
                TGBeat refBeat = null;
                for (TGNote note2 : noteRange.getNotes()) {
                    TGBeat beat2 = note2.getVoice().getBeat();
                    TGMeasure measure2 = beat2.getMeasure();
                    moreThanOneBeat |= refBeat != null && beat2 != refBeat;
                    refBeat = beat2;
                    this.transposeSemiTone(songManager.getMeasureManager(), measure2, beat2, note2);
                }
                if (!moreThanOneBeat) {
                    context.setAttribute("success", (Object)Boolean.TRUE);
                }
            }
        }
    }
}

