/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.action.composition;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGTempo;
import app.tuxguitar.util.TGContext;

public class TGChangeTempoRangeAction
extends TGActionBase {
    public static final String NAME = "action.composition.change-tempo-range";
    public static final String ATTRIBUTE_APPLY_TO = "applyTo";
    public static final String ATTRIBUTE_TEMPO = "tempoValue";
    public static final String ATTRIBUTE_TEMPO_BASE = "tempoBase";
    public static final String ATTRIBUTE_TEMPO_BASE_DOTTED = "tempoBaseDotted";
    public static final int MIN_TEMPO = 1;
    public static final int MAX_TEMPO = 320;
    public static final int APPLY_TO_ALL = 1;
    public static final int APPLY_TO_END = 2;
    public static final int APPLY_TO_NEXT = 3;

    public TGChangeTempoRangeAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        int applyTo = (Integer)context.getAttribute(ATTRIBUTE_APPLY_TO);
        int tempoValue = (Integer)context.getAttribute(ATTRIBUTE_TEMPO);
        int tempoBase = (Integer)context.getAttribute(ATTRIBUTE_TEMPO_BASE);
        boolean tempoBaseDotted = (Boolean)context.getAttribute(ATTRIBUTE_TEMPO_BASE_DOTTED);
        if (tempoValue >= 1 && tempoValue <= 320) {
            TGSongManager tgSongManager = this.getSongManager(context);
            TGSong tgSong = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
            TGMeasureHeader tgHeader = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
            TGTempo tgTempo = tgSongManager.getFactory().newTempo();
            tgTempo.setValueBase(tempoValue, tempoBase, tempoBaseDotted);
            long start = applyTo == 1 ? 960L : ((TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER)).getStart();
            boolean toEnd = applyTo == 1 || applyTo == 2;
            TGMeasureHeader startHeader = tgSongManager.getMeasureHeaderAt(tgSong, start);
            if (startHeader != null) {
                TGTempo oldTempo = startHeader.getTempo();
                for (TGMeasureHeader nextHeader : tgSongManager.getMeasureHeadersAfter(tgSong, startHeader.getNumber() - 1)) {
                    if (!toEnd && !nextHeader.getTempo().isEqual(oldTempo)) break;
                    context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)nextHeader);
                    context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TEMPO, (Object)tgTempo);
                    TGActionManager.getInstance((TGContext)this.getContext()).execute("action.composition.change-tempo", context);
                }
            }
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)tgHeader);
        }
    }
}

