/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.action.channel;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.editor.event.TGUpdateEvent;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventManager;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGChannelParameter;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.util.TGAbstractContext;
import app.tuxguitar.util.TGContext;
import java.util.List;

public class TGUpdateChannelAction
extends TGActionBase {
    public static final String NAME = "action.channel.update";
    public static final String ATTRIBUTE_BANK = "bank";
    public static final String ATTRIBUTE_PROGRAM = "program";
    public static final String ATTRIBUTE_VOLUME = "volume";
    public static final String ATTRIBUTE_BALANCE = "balance";
    public static final String ATTRIBUTE_CHORUS = "chorus";
    public static final String ATTRIBUTE_REVERB = "reverb";
    public static final String ATTRIBUTE_PHASER = "phaser";
    public static final String ATTRIBUTE_TREMOLO = "tremolo";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_PARAMETERS = "parameters";

    public TGUpdateChannelAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        TGSongManager songManager = this.getSongManager(context);
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        TGChannel channel = (TGChannel)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL);
        TGChannel channelClone = channel.clone(songManager.getFactory());
        short oldVolume = channel.getVolume();
        channelClone.setBank(((Short)this.findAttribute(context, ATTRIBUTE_BANK, channel.getBank())).shortValue());
        channelClone.setProgram(((Short)this.findAttribute(context, ATTRIBUTE_PROGRAM, channel.getProgram())).shortValue());
        channelClone.setVolume(((Short)this.findAttribute(context, ATTRIBUTE_VOLUME, channel.getVolume())).shortValue());
        channelClone.setBalance(((Short)this.findAttribute(context, ATTRIBUTE_BALANCE, channel.getBalance())).shortValue());
        channelClone.setChorus(((Short)this.findAttribute(context, ATTRIBUTE_CHORUS, channel.getChorus())).shortValue());
        channelClone.setReverb(((Short)this.findAttribute(context, ATTRIBUTE_REVERB, channel.getReverb())).shortValue());
        channelClone.setPhaser(((Short)this.findAttribute(context, ATTRIBUTE_PHASER, channel.getPhaser())).shortValue());
        channelClone.setTremolo(((Short)this.findAttribute(context, ATTRIBUTE_TREMOLO, channel.getTremolo())).shortValue());
        channelClone.setName((String)this.findAttribute(context, ATTRIBUTE_NAME, channel.getName()));
        List parameters = (List)context.getAttribute(ATTRIBUTE_PARAMETERS);
        if (parameters != null) {
            channelClone.removeParameters();
            for (TGChannelParameter parameter : parameters) {
                channelClone.addParameter(parameter);
            }
        }
        songManager.updateChannel(song, channelClone);
        if (oldVolume != channelClone.getVolume()) {
            TGEventManager.getInstance((TGContext)this.getContext()).fireEvent((TGEvent)new TGUpdateEvent(7, (TGAbstractContext)this.getContext()));
        }
    }

    private Object findAttribute(TGActionContext context, String attribute, Object defaultValue) {
        Object value = context.getAttribute(attribute);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

