/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.action;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionException;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.thread.TGThreadManager;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.error.TGErrorHandler;
import java.util.HashMap;
import java.util.Map;

public class TGActionProcessor {
    private TGContext context;
    private String actionName;
    private Map<String, Object> attributes;
    private Runnable onFinish;
    private TGErrorHandler errorHandler;

    public TGActionProcessor(TGContext context, String actionName) {
        this.context = context;
        this.actionName = actionName;
        this.attributes = new HashMap<String, Object>();
    }

    public TGContext getContext() {
        return this.context;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void setOnFinish(Runnable onFinish) {
        this.onFinish = onFinish;
    }

    public void setErrorHandler(TGErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public TGActionContext createActionContext() {
        return TGActionManager.getInstance((TGContext)this.getContext()).createActionContext();
    }

    public TGActionContext fillActionContext(TGActionContext actionContext, Map<String, Object> customAttributes) {
        this.appendAttributes(actionContext, this.attributes);
        this.appendAttributes(actionContext, customAttributes);
        return actionContext;
    }

    public void appendAttributes(TGActionContext actionContext, Map<String, Object> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                actionContext.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void processOnCurrentThread(TGActionContext actionContext, Map<String, Object> customAttributes) {
        try {
            TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
            tgActionManager.execute(this.getActionName(), this.fillActionContext(actionContext, customAttributes));
            this.onFinish();
        }
        catch (TGActionException e) {
            this.onError(e);
        }
    }

    public void processOnCurrentThread(TGActionContext actionContext) {
        this.processOnCurrentThread(actionContext, null);
    }

    public void processOnCurrentThread(Map<String, Object> customAttributes) {
        this.processOnCurrentThread(this.createActionContext(), customAttributes);
    }

    public void processOnCurrentThread() {
        this.processOnCurrentThread(this.createActionContext());
    }

    public void processOnNewThread(final Map<String, Object> customAttributes) {
        TGThreadManager.getInstance((TGContext)this.context).start(new Runnable(){
            final /* synthetic */ TGActionProcessor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.processOnCurrentThread(customAttributes);
            }
        });
    }

    public void processOnNewThread() {
        this.processOnNewThread(null);
    }

    public void process(Map<String, Object> customAttributes) {
        this.processOnNewThread(customAttributes);
    }

    public void process() {
        this.process(null);
    }

    public void onFinish() {
        if (this.onFinish != null) {
            this.onFinish.run();
        }
    }

    public void onError(TGActionException e) {
        if (this.errorHandler != null) {
            this.errorHandler.handleError((Throwable)e);
        }
    }
}

