/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor;

import app.tuxguitar.editor.event.TGDestroyEvent;
import app.tuxguitar.editor.event.TGRedrawEvent;
import app.tuxguitar.editor.event.TGUpdateEvent;
import app.tuxguitar.editor.event.TGUpdateMeasuresEvent;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.event.TGEventManager;
import app.tuxguitar.thread.TGThreadManager;
import app.tuxguitar.util.TGAbstractContext;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGLock;
import app.tuxguitar.util.error.TGErrorManager;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.List;

public class TGEditorManager {
    private TGContext context;
    private TGLock lockControl;

    public TGEditorManager(TGContext context) {
        this.context = context;
    }

    public void setLockControl(TGLock lockControl) {
        this.lockControl = lockControl;
    }

    public TGLock getLockControl() {
        return this.lockControl;
    }

    public void redraw() {
        this.redraw(null);
    }

    public void redraw(final TGAbstractContext sourceContext) {
        this.asyncRunLocked(new Runnable(){
            final /* synthetic */ TGEditorManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.doRedraw(1, sourceContext);
            }
        });
    }

    public void redrawPlayingThread() {
        this.redrawPlayingThread(null);
    }

    public void redrawPlayingThread(final TGAbstractContext sourceContext) {
        this.asyncRunLocked(new Runnable(){
            final /* synthetic */ TGEditorManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.doRedraw(2, sourceContext);
            }
        });
    }

    public void redrawPlayingNewBeat() {
        this.redrawPlayingNewBeat(null);
    }

    public void redrawPlayingNewBeat(final TGAbstractContext sourceContext) {
        this.asyncRunLocked(new Runnable(){
            final /* synthetic */ TGEditorManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.doRedraw(3, sourceContext);
            }
        });
    }

    public void updateSelection() {
        this.updateSelection(null);
    }

    public void updateSelection(final TGAbstractContext sourceContext) {
        this.asyncRunLocked(new Runnable(){
            final /* synthetic */ TGEditorManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.doUpdate(1, sourceContext);
            }
        });
    }

    public void updateMeasures(List<Integer> numbers) {
        this.updateMeasures(numbers, null);
    }

    public void updateMeasures(final List<Integer> numbers, final TGAbstractContext sourceContext) {
        this.runLocked(new Runnable(){
            final /* synthetic */ TGEditorManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.doUpdateMeasures(numbers, sourceContext);
            }
        });
    }

    public void updateSong() {
        this.updateSong(null);
    }

    public void updateSong(final TGAbstractContext sourceContext) {
        this.runLocked(new Runnable(){
            final /* synthetic */ TGEditorManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.doUpdate(3, sourceContext);
            }
        });
    }

    public void updateSavedSong() {
        this.updateSavedSong(null);
    }

    public void updateSavedSong(final TGAbstractContext sourceContext) {
        this.runLocked(new Runnable(){
            final /* synthetic */ TGEditorManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.doUpdate(5, sourceContext);
            }
        });
    }

    public void updateLoadedSong() {
        this.updateLoadedSong(null);
    }

    public void updateLoadedSong(final TGAbstractContext context) {
        this.runLocked(new Runnable(){
            final /* synthetic */ TGEditorManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.doUpdate(4, context);
            }
        });
    }

    public void destroy(final TGAbstractContext context) {
        this.runLocked(new Runnable(){
            final /* synthetic */ TGEditorManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.doDestroy(context);
            }
        });
    }

    public void addRedrawListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).addListener("ui-redraw", listener);
    }

    public void removeRedrawListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).removeListener("ui-redraw", listener);
    }

    public void addUpdateListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).addListener("ui-update", listener);
    }

    public void removeUpdateListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).removeListener("ui-update", listener);
    }

    public void addDestroyListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).addListener("ui-destroy", listener);
    }

    public void removeDestroyListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).removeListener("ui-destroy", listener);
    }

    private void doRedraw(int type, TGAbstractContext context) {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGRedrawEvent(type, context));
    }

    private void doUpdate(int type, TGAbstractContext context) {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGUpdateEvent(type, context));
    }

    private void doUpdateMeasures(List<Integer> numbers, TGAbstractContext context) {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGUpdateMeasuresEvent(numbers, context));
    }

    private void doDestroy(TGAbstractContext context) {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGDestroyEvent(context));
    }

    public void lock() {
        if (this.lockControl != null) {
            this.lockControl.lock();
        }
    }

    public boolean tryLock() {
        if (this.lockControl != null) {
            return this.lockControl.tryLock();
        }
        return true;
    }

    public void unlock() {
        if (this.lockControl != null) {
            this.lockControl.unlock();
        }
    }

    public boolean isLocked() {
        if (this.lockControl != null) {
            return this.lockControl.isLocked();
        }
        return false;
    }

    public boolean isUnderLockControl() {
        if (this.lockControl != null) {
            return this.lockControl.isUnderLockControl();
        }
        return false;
    }

    public void runLocked(Runnable runnable) {
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    public void asyncRunLocked(final Runnable runnable) {
        TGThreadManager.getInstance((TGContext)this.context).start(new Runnable(){
            final /* synthetic */ TGEditorManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.this$0.runLocked(runnable);
                }
                catch (Throwable throwable) {
                    TGErrorManager.getInstance((TGContext)this.this$0.context).handleError(throwable);
                }
            }
        });
    }

    public static TGEditorManager getInstance(TGContext context) {
        return (TGEditorManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGEditorManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGEditorManager>(){

            public TGEditorManager createInstance(TGContext context) {
                return new TGEditorManager(context);
            }
        });
    }
}

