/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.tools.custom.converter;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.tools.custom.converter.TGConverterFormat;
import app.tuxguitar.app.tools.custom.converter.TGConverterProcess;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.util.TGMessageDialogUtil;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGFileFormatManager;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.chooser.UIDirectoryChooser;
import app.tuxguitar.ui.chooser.UIDirectoryChooserHandler;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UITextField;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TGConverterDialog
implements TGEventListener {
    private TGContext context;
    private UIWindow dialog;
    private UILegendPanel group;
    private UILabel outputFormatLabel;
    private UILabel outputFolderLabel;
    private UILabel inputFolderLabel;
    private UIButton inputFolderChooser;
    private UIButton outputFolderChooser;
    private UIButton buttonOK;
    private UIButton buttonCancel;

    public TGConverterDialog(TGContext context) {
        this.context = context;
    }

    public TGContext getContext() {
        return this.context;
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance((TGContext)this.context).getFactory();
    }

    public void show() {
        final UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UIWindow uiParent = TGWindow.getInstance((TGContext)this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, false, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TuxGuitar.getInstance().getSkinManager().removeLoader((TGEventListener)TGConverterDialog.this);
                TuxGuitar.getInstance().getLanguageManager().removeLoader((TGEventListener)TGConverterDialog.this);
            }
        });
        UITableLayout groupLayout = new UITableLayout();
        this.group = uiFactory.createLegendPanel((UIContainer)this.dialog);
        this.group.setLayout((UILayout)groupLayout);
        dialogLayout.set((UIControl)this.group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(500.0f), null, null);
        this.outputFormatLabel = uiFactory.createLabel((UIContainer)this.group);
        groupLayout.set((UIControl)this.outputFormatLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIDropDownSelect outputFormat = uiFactory.createDropDownSelect((UIContainer)this.group);
        groupLayout.set((UIControl)outputFormat, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        groupLayout.set((UIControl)outputFormat, "packed_width", (Object)Float.valueOf(0.0f));
        this.addFileFormats((UIDropDownSelect<TGConverterFormat>)outputFormat);
        this.inputFolderLabel = uiFactory.createLabel((UIContainer)this.group);
        groupLayout.set((UIControl)this.inputFolderLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField inputFolder = uiFactory.createTextField((UIContainer)this.group);
        groupLayout.set((UIControl)inputFolder, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.inputFolderChooser = uiFactory.createButton((UIContainer)this.group);
        this.inputFolderChooser.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGConverterDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                String defaultPath = inputFolder.getText();
                UIDirectoryChooser chooser = uiFactory.createDirectoryChooser(this.this$0.dialog);
                chooser.setDefaultPath(defaultPath != null ? new File(defaultPath) : null);
                chooser.choose(new UIDirectoryChooserHandler(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void onSelectDirectory(File file) {
                        if (file != null) {
                            inputFolder.setText(file.getAbsolutePath());
                        }
                    }
                });
            }
        });
        groupLayout.set((UIControl)this.inputFolderChooser, Integer.valueOf(2), Integer.valueOf(3), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.outputFolderLabel = uiFactory.createLabel((UIContainer)this.group);
        groupLayout.set((UIControl)this.outputFolderLabel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField outputFolder = uiFactory.createTextField((UIContainer)this.group);
        groupLayout.set((UIControl)outputFolder, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.outputFolderChooser = uiFactory.createButton((UIContainer)this.group);
        this.outputFolderChooser.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGConverterDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                String defaultPath = outputFolder.getText();
                UIDirectoryChooser chooser = uiFactory.createDirectoryChooser(this.this$0.dialog);
                chooser.setDefaultPath(defaultPath != null ? new File(defaultPath) : null);
                chooser.choose(new UIDirectoryChooserHandler(){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void onSelectDirectory(File file) {
                        if (file != null) {
                            outputFolder.setText(file.getAbsolutePath());
                        }
                    }
                });
            }
        });
        groupLayout.set((UIControl)this.outputFolderChooser, Integer.valueOf(3), Integer.valueOf(3), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.buttonOK = uiFactory.createButton((UIContainer)buttons);
        this.buttonOK.setDefaultButton();
        this.buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGConverterDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                String inputFolderValue = inputFolder.getText();
                String outputFolderValue = outputFolder.getText();
                TGConverterFormat outputFormatValue = (TGConverterFormat)outputFormat.getSelectedValue();
                if (inputFolderValue == null || inputFolderValue.trim().length() == 0) {
                    TGMessageDialogUtil.errorMessage((TGContext)this.this$0.context, (UIWindow)this.this$0.dialog, (String)TuxGuitar.getProperty((String)"batch.converter.input.folder.invalid"));
                } else if (outputFolderValue == null || outputFolderValue.trim().length() == 0) {
                    TGMessageDialogUtil.errorMessage((TGContext)this.this$0.context, (UIWindow)this.this$0.dialog, (String)TuxGuitar.getProperty((String)"batch.converter.output.folder.invalid"));
                } else if (outputFormatValue == null) {
                    TGMessageDialogUtil.errorMessage((TGContext)this.this$0.context, (UIWindow)this.this$0.dialog, (String)TuxGuitar.getProperty((String)"batch.converter.output.format.invalid"));
                } else {
                    TGConverterProcess process = new TGConverterProcess(this.this$0.getContext());
                    process.start(inputFolderValue.trim(), outputFolderValue.trim(), outputFormatValue);
                    this.this$0.dialog.dispose();
                }
            }
        });
        buttonsLayout.set((UIControl)this.buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        this.buttonCancel = uiFactory.createButton((UIContainer)buttons);
        this.buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGConverterDialog.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)this.buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)this.buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        this.loadIcons(false);
        this.loadProperties(false);
        TuxGuitar.getInstance().getSkinManager().addLoader((TGEventListener)this);
        TuxGuitar.getInstance().getLanguageManager().addLoader((TGEventListener)this);
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)5);
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    private void addFileFormats(UIDropDownSelect<TGConverterFormat> combo) {
        ArrayList<UISelectItem<TGConverterFormat>> selectItems = new ArrayList<UISelectItem<TGConverterFormat>>();
        List fileFormats = TGFileFormatManager.getInstance((TGContext)this.context).findWriteFileFormats(null);
        for (TGFileFormat tGFileFormat : fileFormats) {
            this.addFileFormats(selectItems, tGFileFormat);
        }
        for (UISelectItem uISelectItem : selectItems) {
            combo.addItem(uISelectItem);
        }
        if (selectItems.size() > 0) {
            combo.setSelectedItem((UISelectItem)selectItems.get(0));
        }
    }

    private void addFileFormats(List<UISelectItem<TGConverterFormat>> items, TGFileFormat format) {
        String[] extensions;
        if (format.getSupportedFormats() != null && (extensions = format.getSupportedFormats()) != null && extensions.length > 0) {
            for (int i = 0; i < extensions.length; ++i) {
                String label = format.getName() + " (*." + extensions[i] + ")";
                items.add((UISelectItem<TGConverterFormat>)new UISelectItem(label, (Object)new TGConverterFormat(format, extensions[i].trim())));
            }
        }
    }

    public void loadProperties() {
        this.loadProperties(true);
    }

    public void loadProperties(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty((String)"batch.converter"));
            this.group.setText(TuxGuitar.getProperty((String)"batch.converter.settings"));
            this.inputFolderLabel.setText(TuxGuitar.getProperty((String)"batch.converter.input.folder") + ":");
            this.outputFolderLabel.setText(TuxGuitar.getProperty((String)"batch.converter.output.folder") + ":");
            this.outputFormatLabel.setText(TuxGuitar.getProperty((String)"batch.converter.output.format") + ":");
            this.buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
            this.buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
            if (layout) {
                this.dialog.layout();
            }
        }
    }

    public void loadIcons() {
        this.loadIcons(true);
    }

    public void loadIcons(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            this.inputFolderChooser.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("open.png"));
            this.outputFolderChooser.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("open.png"));
            if (layout) {
                this.dialog.layout();
            }
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-skin".equals(event.getEventType())) {
            this.loadIcons();
        } else if ("language".equals(event.getEventType())) {
            this.loadProperties();
        }
    }
}

