/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.tools.custom.converter;

import app.tuxguitar.app.tools.custom.converter.TGConverterFormat;
import app.tuxguitar.app.tools.custom.converter.TGConverterListener;
import app.tuxguitar.io.base.TGFileFormatException;
import app.tuxguitar.io.base.TGFileFormatManager;
import app.tuxguitar.io.base.TGFileFormatUtils;
import app.tuxguitar.io.base.TGSongReaderHandle;
import app.tuxguitar.io.base.TGSongStreamContext;
import app.tuxguitar.io.base.TGSongWriterHandle;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.util.TGContext;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class TGConverter {
    public static final int SLEEP_TIME = 20;
    public static final int FILE_OK = 250;
    public static final int FILE_OK_NEW_VERSION = 251;
    public static final int FILE_BAD = 403;
    public static final int FILE_COULDNT_WRITE = 401;
    public static final int FILE_NOT_FOUND = 404;
    public static final int OUT_OF_MEMORY = 500;
    public static final int EXPORTER_NOT_FOUND = 590;
    public static final int UNKNOWN_ERROR = 666;
    private TGContext context;
    private String sourceFolder;
    private String destinationFolder;
    private TGConverterFormat format;
    private TGConverterListener listener;
    private boolean cancelled;

    public TGConverter(TGContext context, String sourceFolder, String destinationFolder) {
        this.context = context;
        this.sourceFolder = sourceFolder;
        this.destinationFolder = destinationFolder;
    }

    public void convert(String fileName, String convertFileName) {
        block10: {
            try {
                this.getListener().notifyFileProcess(convertFileName);
                TGSongManager manager = new TGSongManager();
                TGSong song = null;
                TGSongReaderHandle tgSongLoaderHandle = new TGSongReaderHandle();
                try {
                    tgSongLoaderHandle.setFactory(manager.getFactory());
                    tgSongLoaderHandle.setInputStream((InputStream)new FileInputStream(fileName));
                    tgSongLoaderHandle.setContext(new TGSongStreamContext());
                    tgSongLoaderHandle.getContext().setAttribute("formatCode", (Object)TGFileFormatUtils.getFileFormatCode((String)fileName));
                    TGFileFormatManager.getInstance((TGContext)this.context).read(tgSongLoaderHandle);
                    song = tgSongLoaderHandle.getSong();
                }
                catch (TGFileFormatException e) {
                    e.printStackTrace();
                    this.getListener().notifyFileResult(fileName, 403);
                }
                if (song == null) break block10;
                try {
                    manager.updatePreciseStart(song);
                    manager.autoCompleteSilences(song);
                    new File(new File(convertFileName).getParent()).mkdirs();
                    if (this.format != null) {
                        TGSongWriterHandle tgSongWriterHandle = new TGSongWriterHandle();
                        tgSongWriterHandle.setSong(song);
                        tgSongWriterHandle.setFactory(manager.getFactory());
                        tgSongWriterHandle.setFormat(this.format.getFileFormat());
                        tgSongWriterHandle.setOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(convertFileName)));
                        tgSongWriterHandle.setContext(new TGSongStreamContext());
                        TGFileFormatManager.getInstance((TGContext)this.context).write(tgSongWriterHandle);
                    }
                    if (tgSongLoaderHandle.isNewerFileFormatDetected()) {
                        this.getListener().notifyFileResult(convertFileName, 251);
                        break block10;
                    }
                    this.getListener().notifyFileResult(convertFileName, 250);
                }
                catch (TGFileFormatException e) {
                    this.getListener().notifyFileResult(fileName, 401);
                }
            }
            catch (FileNotFoundException ex) {
                this.getListener().notifyFileResult(fileName, 404);
            }
            catch (OutOfMemoryError e) {
                this.getListener().notifyFileResult(convertFileName, 500);
            }
            catch (Throwable throwable) {
                this.getListener().notifyFileResult(convertFileName, 666);
            }
        }
    }

    private String checkIfExists(String convertFileName, int level) {
        if (new File(convertFileName).exists()) {
            String tmpName = convertFileName;
            String tmpExtension = "";
            String tmpLevel = "(" + (level + 1) + ")";
            String lastLevel = "(" + level + ")";
            int index = convertFileName.lastIndexOf((String)(level == 0 ? "." : lastLevel + "."));
            if (index != -1) {
                tmpExtension = tmpName.substring(index + (level == 0 ? 0 : lastLevel.length()), tmpName.length());
                tmpName = tmpName.substring(0, index);
            }
            return this.checkIfExists(tmpName + tmpLevel + tmpExtension, level + 1);
        }
        return convertFileName;
    }

    public void process() {
        this.getListener().notifyStart();
        this.process(new File(this.sourceFolder));
        this.getListener().notifyFinish();
    }

    private void process(File folder) {
        String[] fileNames;
        if (!this.isCancelled() && (fileNames = folder.list()) != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                File file = new File(folder.getPath() + "/" + fileNames[i]);
                if (file.isDirectory()) {
                    this.process(file);
                } else if (!this.isCancelled()) {
                    String fileName = file.getAbsolutePath();
                    String convertFileName = this.getConvertFileName(fileName);
                    this.convert(fileName, convertFileName);
                    this.sleep();
                }
                fileNames[i] = null;
            }
        }
    }

    private String getConvertFileName(String path) {
        String convertPath = this.destinationFolder + File.separator + path.substring(this.sourceFolder.length());
        int lastDot = convertPath.lastIndexOf(".");
        if (lastDot != -1) {
            convertPath = convertPath.substring(0, lastDot) + "." + this.format.getExtension();
        }
        return this.checkIfExists(new File(convertPath).getAbsolutePath(), 0);
    }

    private void sleep() {
        try {
            Thread.sleep(20L);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setFormat(TGConverterFormat format) {
        this.format = format;
    }

    public TGConverterListener getListener() {
        return this.listener;
    }

    public void setListener(TGConverterListener listener) {
        this.listener = listener;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

