/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.midiport.lv2.ui;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.event.TGEventManager;
import app.tuxguitar.midi.synth.ui.TGAudioProcessorUICallback;
import app.tuxguitar.player.impl.midiport.lv2.LV2AudioProcessor;
import app.tuxguitar.player.impl.midiport.lv2.LV2ParamsEvent;
import app.tuxguitar.player.impl.midiport.lv2.jni.LV2ControlPortInfo;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UIScrollBarPanelLayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIScale;
import app.tuxguitar.ui.widget.UIScrollBarPanel;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGSynchronizer;
import java.util.List;

public class LV2AudioProcessorDialog
implements TGEventListener {
    private LV2AudioProcessor processor;
    private TGAudioProcessorUICallback callback;
    private TGContext context;
    private UIWindow dialog;
    private UIScale[] scaleParameterValue;
    private UILabel[] labelParameterValue;
    private List<Integer> portIndices;

    public LV2AudioProcessorDialog(TGContext context, LV2AudioProcessor processor, TGAudioProcessorUICallback callback) {
        this.context = context;
        this.processor = processor;
        this.callback = callback;
    }

    public void open(final UIWindow parent) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){
            final /* synthetic */ LV2AudioProcessorDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.openInCurrentThread(parent);
            }
        });
    }

    public void openInCurrentThread(UIWindow parent) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(parent, false, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-lv2.dialog.title", (String[])new String[]{this.processor.getPlugin().getName()}));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)this.dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-lv2.dialog.params.tip"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIScrollBarPanel scrollBarPanel = uiFactory.createScrollBarPanel((UIContainer)group, true, false, false);
        scrollBarPanel.setLayout((UILayout)new UIScrollBarPanelLayout(false, true, true, true, false, true));
        scrollBarPanel.getVScroll().setIncrement(10);
        scrollBarPanel.getVScroll().addSelectionListener(new UISelectionListener(){
            final /* synthetic */ LV2AudioProcessorDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                scrollBarPanel.layout();
            }
        });
        groupLayout.set((UIControl)scrollBarPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(400.0f), Float.valueOf(400.0f), null);
        UITableLayout panelLayout = new UITableLayout();
        UIPanel panel = uiFactory.createPanel((UIContainer)scrollBarPanel, false);
        panel.setLayout((UILayout)panelLayout);
        this.portIndices = this.processor.getPlugin().getControlPortIndices();
        this.scaleParameterValue = new UIScale[this.portIndices.size()];
        this.labelParameterValue = new UILabel[this.portIndices.size()];
        for (int i = 0; i < this.portIndices.size(); ++i) {
            final int index = i;
            final int portIndex = this.portIndices.get(index);
            final LV2ControlPortInfo info = this.processor.getPlugin().getControlPortInfo(portIndex);
            UILabel labelParameterName = uiFactory.createLabel((UIContainer)panel);
            labelParameterName.setText(info.getName() != null ? info.getName() : "");
            panelLayout.set((UIControl)labelParameterName, Integer.valueOf(1 + index), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
            this.scaleParameterValue[index] = uiFactory.createHorizontalScale((UIContainer)panel);
            this.scaleParameterValue[index].setMaximum(100);
            this.scaleParameterValue[index].setMinimum(0);
            this.scaleParameterValue[index].setIncrement(1);
            panelLayout.set((UIControl)this.scaleParameterValue[index], Integer.valueOf(1 + index), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
            this.labelParameterValue[index] = uiFactory.createLabel((UIContainer)panel);
            panelLayout.set((UIControl)this.labelParameterValue[index], Integer.valueOf(1 + index), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
            this.scaleParameterValue[index].addSelectionListener(new UISelectionListener(){
                final /* synthetic */ LV2AudioProcessorDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void onSelect(UISelectionEvent event) {
                    UIScale scale = this.this$0.scaleParameterValue[index];
                    Float value = Float.valueOf(info.getMinimumValue() + (float)scale.getValue() * (info.getMaximumValue() - info.getMinimumValue()) / 100.0f);
                    this.this$0.labelParameterValue[index].setText(Float.toString(value.floatValue()));
                    this.this$0.processor.getInstance().setControlPortValue(portIndex, value.floatValue());
                    this.this$0.callback.onChange(false);
                }
            });
        }
        this.updateItems();
        this.addEventListeners();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                LV2AudioProcessorDialog.this.removeEventListeners();
            }
        });
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)5);
    }

    public void addEventListeners() {
        TGEventManager.getInstance((TGContext)this.context).addListener("lv2-params", (TGEventListener)this);
    }

    public void removeEventListeners() {
        TGEventManager.getInstance((TGContext)this.context).removeListener("lv2-params", (TGEventListener)this);
    }

    public void focus() {
        if (this.isOpen()) {
            this.dialog.moveToTop();
        }
    }

    public void close() {
        if (this.isOpen()) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public boolean isOpen() {
        return this.dialog != null && !this.dialog.isDisposed();
    }

    public void updateItems() {
        for (int i = 0; i < this.portIndices.size(); ++i) {
            int index = this.portIndices.get(i);
            float value = this.processor.getInstance().getControlPortValue(index);
            LV2ControlPortInfo info = this.processor.getPlugin().getControlPortInfo(index);
            this.scaleParameterValue[i].setIgnoreEvents(true);
            this.scaleParameterValue[i].setValue(Math.round((float)((int)((value - info.getMinimumValue()) * 100.0f)) / (info.getMaximumValue() - info.getMinimumValue())));
            this.scaleParameterValue[i].setIgnoreEvents(false);
            this.labelParameterValue[i].setText(Float.toString(value));
        }
    }

    public void updateItemsUiThread() {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            @Override
            public void run() {
                LV2AudioProcessorDialog.this.updateItems();
            }
        });
    }

    public void processEvent(TGEvent event) {
        if ("lv2-params".equals(event.getEventType())) {
            LV2AudioProcessor processor = (LV2AudioProcessor)event.getAttribute("processor");
            if (LV2ParamsEvent.ACTION_RESTORE.equals(event.getAttribute("action")) && this.processor.isOpen() && this.processor.getInstance().equals(processor.getInstance())) {
                this.updateItemsUiThread();
            }
        }
    }
}

