/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.pdf;

import app.tuxguitar.graphics.control.TGController;
import app.tuxguitar.graphics.control.TGFactoryImpl;
import app.tuxguitar.graphics.control.TGLayoutStyles;
import app.tuxguitar.graphics.control.print.TGPrintController;
import app.tuxguitar.graphics.control.print.TGPrintDocument;
import app.tuxguitar.graphics.control.print.TGPrintLayout;
import app.tuxguitar.graphics.control.print.TGPrintSettings;
import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGFileFormatException;
import app.tuxguitar.io.base.TGSongWriter;
import app.tuxguitar.io.base.TGSongWriterHandle;
import app.tuxguitar.io.pdf.PDFDocument;
import app.tuxguitar.io.pdf.PDFLayoutStyles;
import app.tuxguitar.io.pdf.PDFResourceFactory;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.resource.UIInset;
import app.tuxguitar.ui.resource.UIResourceFactory;
import app.tuxguitar.ui.resource.UISize;
import app.tuxguitar.util.TGContext;

public class PDFSongWriter
implements TGSongWriter {
    public static final TGFileFormat FILE_FORMAT = new TGFileFormat("PDF", "application/pdf", new String[]{"pdf"});
    private static final int PAGE_WIDTH = 550;
    private static final int PAGE_HEIGHT = 800;
    private static final int MARGIN_TOP = 20;
    private static final int MARGIN_BOTTOM = 20;
    private static final int MARGIN_LEFT = 20;
    private static final int MARGIN_RIGHT = 20;
    private TGContext context;

    public PDFSongWriter(TGContext context) {
        this.context = context;
    }

    public TGFileFormat getFileFormat() {
        return FILE_FORMAT;
    }

    public TGPrintSettings getDefaultStyles(TGSong song) {
        TGPrintSettings styles = new TGPrintSettings();
        styles.setStyle(125);
        styles.setFromMeasure(1);
        styles.setToMeasure(song.countMeasureHeaders());
        styles.setTrackNumber(-1);
        return styles;
    }

    public void write(TGSongWriterHandle handle) throws TGFileFormatException {
        try {
            TGLayoutStyles styles;
            Integer zoomValue;
            TGPrintSettings settings = (TGPrintSettings)handle.getContext().getAttribute("attribute.print.settings.styles");
            if (settings == null) {
                settings = this.getDefaultStyles(handle.getSong());
            }
            if ((zoomValue = (Integer)handle.getContext().getAttribute("attribute.print.settings.zoom")) == null) {
                zoomValue = 100;
            }
            if ((styles = (TGLayoutStyles)handle.getContext().getAttribute(TGLayoutStyles.class.getName())) == null) {
                styles = new PDFLayoutStyles(this.context);
            }
            TGSongManager manager = new TGSongManager((TGFactory)new TGFactoryImpl());
            TGSong clonedSong = handle.getSong().clone(manager.getFactory());
            PDFResourceFactory factory = new PDFResourceFactory();
            TGPrintController controller = new TGPrintController(clonedSong, manager, (UIResourceFactory)factory, styles);
            UISize pageSize = new UISize(550.0f, 800.0f);
            UIInset pageMargins = new UIInset(20.0f, 20.0f, 20.0f, 20.0f);
            TGPrintLayout layout = new TGPrintLayout((TGController)controller, settings);
            layout.loadStyles((float)zoomValue.intValue() / 100.0f);
            layout.updateSong();
            layout.makeDocument((TGPrintDocument)new PDFDocument(this.context, pageSize, pageMargins, handle.getOutputStream()));
            controller.getResourceBuffer().disposeAllResources();
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }
}

