/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.ui.swt.printer;

import app.tuxguitar.ui.printer.UIPrinter;
import app.tuxguitar.ui.printer.UIPrinterJob;
import app.tuxguitar.ui.resource.UIRectangle;
import app.tuxguitar.ui.resource.UIResourceFactory;
import app.tuxguitar.ui.swt.SWTComponent;
import app.tuxguitar.ui.swt.printer.SWTPrinterJob;
import app.tuxguitar.ui.swt.resource.SWTResourceFactory;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class SWTPrinter
extends SWTComponent<Printer>
implements UIPrinter {
    private PrinterData data;
    private UIResourceFactory resourceFactory;

    public SWTPrinter(PrinterData data) {
        super(new Printer(data));
        this.data = data;
        this.resourceFactory = new SWTResourceFactory((Device)this.getControl());
    }

    public void dispose() {
        ((Printer)this.getControl()).dispose();
    }

    public boolean isDisposed() {
        return ((Printer)this.getControl()).isDisposed();
    }

    public UIResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public Float getDpiScale() {
        Point dpi = ((Printer)this.getControl()).getDPI();
        if (dpi != null) {
            return Float.valueOf((float)dpi.x / 100.0f);
        }
        return Float.valueOf(1.0f);
    }

    public Float getDpiFontScale() {
        return Float.valueOf(1.0f);
    }

    public UIRectangle getBounds() {
        Rectangle area = ((Printer)this.getControl()).getClientArea();
        return new UIRectangle((float)area.x, (float)area.y, (float)area.width, (float)area.height);
    }

    public Integer getStartPage() {
        return this.data.scope == 1 ? Integer.valueOf(this.data.startPage) : null;
    }

    public Integer getEndPage() {
        return this.data.scope == 1 ? Integer.valueOf(this.data.endPage) : null;
    }

    public UIPrinterJob createJob(String name) {
        return new SWTPrinterJob((Printer)this.getControl(), name);
    }
}

