/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.tuner;

import java.util.Objects;
import org.herac.tuxguitar.app.system.icons.TGColorManager;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIPaintEvent;
import org.herac.tuxguitar.ui.event.UIPaintListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGMusicKeyUtils;

public class TGTunerRoughWidget {
    private static final float CANVAS_PACKED_WIDTH = 600.0f;
    private static final float CANVAS_PACKED_HEIGHT = 100.0f;
    private TGContext context;
    private UIPanel panel;
    protected UICanvas composite = null;
    protected float currentFrequency = 0.0f;
    private final int startA = 20;
    private final int endAb = 20;
    private final int boundaryHeight = 16;
    private final int markerHeight = 12;
    private final int markerWidth = 4;

    public TGTunerRoughWidget(TGContext context, UIFactory factory, UILayoutContainer parent) {
        this.context = context;
        this.init(factory, parent);
    }

    private void init(UIFactory factory, UILayoutContainer parent) {
        UITableLayout layout = new UITableLayout();
        this.panel = factory.createPanel((UIContainer)parent, false);
        this.panel.setLayout((UILayout)layout);
        this.panel.setEnabled(false);
        this.composite = factory.createCanvas((UIContainer)this.panel, true);
        this.composite.setBgColor(TGColorManager.getInstance((TGContext)this.context).getColor("white"));
        this.composite.addPaintListener(new UIPaintListener(){

            public void onPaint(UIPaintEvent event) {
                TGTunerRoughWidget.this.paintWidget(event.getPainter());
            }
        });
        layout.set((UIControl)this.composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(600.0f), Float.valueOf(100.0f), null);
    }

    private void paintWidget(UIPainter painter) {
        TGColorManager colorManager = TGColorManager.getInstance((TGContext)this.context);
        UIRectangle compositeSize = this.composite.getBounds();
        painter.setForeground(colorManager.getColor("black"));
        painter.initPath();
        Objects.requireNonNull(this);
        painter.moveTo(20.0f, compositeSize.getHeight() / 2.0f);
        float f = compositeSize.getWidth();
        Objects.requireNonNull(this);
        painter.lineTo(f - 20.0f, compositeSize.getHeight() / 2.0f);
        painter.closePath();
        float f2 = compositeSize.getWidth();
        Objects.requireNonNull(this);
        float f3 = f2 - 20.0f;
        Objects.requireNonNull(this);
        int increment = (int)Math.round((double)(f3 - 20.0f) / 12.0);
        int currentTone = 0;
        Objects.requireNonNull(this);
        int i = 20;
        while (true) {
            float f4 = i;
            float f5 = compositeSize.getWidth() + 1.0f;
            Objects.requireNonNull(this);
            if (!(f4 < f5 - 20.0f)) break;
            painter.initPath();
            painter.moveTo((float)i, compositeSize.getHeight() / 2.0f - (float)(this.boundaryHeight / 2));
            painter.lineTo((float)i, compositeSize.getHeight() / 2.0f + (float)(this.boundaryHeight / 2));
            painter.closePath();
            painter.drawString(TGMusicKeyUtils.sharpKeyNames[currentTone % 12], (float)i, compositeSize.getHeight() / 2.0f - (float)(this.boundaryHeight / 2) - 20.0f);
            ++currentTone;
            i += increment;
        }
        if (this.currentFrequency > 0.0f) {
            painter.setForeground(colorManager.getColor("blue"));
            painter.initPath();
            int n = this.markerWidth / 2;
            Objects.requireNonNull(this);
            int n2 = n + 20;
            float f6 = compositeSize.getWidth();
            Objects.requireNonNull(this);
            float f7 = f6 - 20.0f;
            Objects.requireNonNull(this);
            int markerPos = n2 + (int)Math.round((double)(f7 - 20.0f) / 240.0 * (double)this.getTone(this.currentFrequency));
            painter.moveTo((float)markerPos, compositeSize.getHeight() / 2.0f - (float)(this.markerHeight / 2));
            Objects.requireNonNull(this);
            painter.setLineWidth(4.0f);
            painter.lineTo((float)markerPos, compositeSize.getHeight() / 2.0f + (float)(this.markerHeight / 2));
            painter.closePath();
        }
    }

    public void setCurrentFrequency(double currentFrequency) {
        this.currentFrequency = (float)currentFrequency;
        this.redraw();
    }

    public void redraw() {
        this.composite.redraw();
    }

    protected int getTone(float frequency) {
        float midiTone = (float)(45.0 + 12.0 * (Math.log(frequency / 110.0f) / Math.log(2.0)));
        return Math.round(20.0f * (midiTone % 12.0f));
    }

    public UIControl getControl() {
        return this.panel;
    }

    public boolean isDisposed() {
        return this.panel == null || this.panel.isDisposed();
    }
}

