/*
 * Decompiled with CFR 0.152.
 */
package craigl.spectrumanalyzer;

public class FFT {
    private static final double TWOPI = Math.PI * 2;
    private static final int LOG2_MAXFFTSIZE = 15;
    private static final int MAXFFTSIZE = 32768;
    private int bits;
    private int[] bitreverse = new int[32768];

    public FFT(int bits) {
        this.bits = bits;
        if (bits > 15) {
            System.out.println(bits + " is too big");
            System.exit(1);
        }
        for (int i = (1 << bits) - 1; i >= 0; --i) {
            int k = 0;
            for (int j = 0; j < bits; ++j) {
                k *= 2;
                if ((i & 1 << j) == 0) continue;
                ++k;
            }
            this.bitreverse[i] = k;
        }
    }

    public void doFFT(double[] xr, double[] xi, boolean invFlag) {
        double ti;
        double tr;
        int i;
        int k;
        int n = 1 << this.bits;
        int n2 = n / 2;
        for (int l = 0; l < this.bits; ++l) {
            for (k = 0; k < n; k += n2) {
                for (i = 0; i < n2; ++i) {
                    int p = this.bitreverse[k / n2];
                    double ang = Math.PI * 2 * (double)p / (double)n;
                    double c = Math.cos(ang);
                    double s = Math.sin(ang);
                    int kn2 = k + n2;
                    if (invFlag) {
                        s = -s;
                    }
                    tr = xr[kn2] * c + xi[kn2] * s;
                    ti = xi[kn2] * c - xr[kn2] * s;
                    xr[kn2] = xr[k] - tr;
                    xi[kn2] = xi[k] - ti;
                    int n3 = k;
                    xr[n3] = xr[n3] + tr;
                    int n4 = k++;
                    xi[n4] = xi[n4] + ti;
                }
            }
            n2 /= 2;
        }
        for (k = 0; k < n; ++k) {
            i = this.bitreverse[k];
            if (i <= k) continue;
            tr = xr[k];
            ti = xi[k];
            xr[k] = xr[i];
            xi[k] = xi[i];
            xr[i] = tr;
            xi[i] = ti;
        }
        if (!invFlag) {
            double f = 1.0 / (double)n;
            i = 0;
            while (i < n) {
                int n5 = i;
                xr[n5] = xr[n5] * f;
                int n6 = i++;
                xi[n6] = xi[n6] * f;
            }
        }
    }
}

