/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.converter;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.custom.converter.TGConverter;
import org.herac.tuxguitar.app.tools.custom.converter.TGConverterFormat;
import org.herac.tuxguitar.app.tools.custom.converter.TGConverterListener;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UICloseEvent;
import org.herac.tuxguitar.ui.event.UICloseListener;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UICursor;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIReadOnlyTextBox;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGConverterProcess
implements TGConverterListener,
TGEventListener {
    private static final float SHELL_WIDTH = 650.0f;
    private static final float SHELL_HEIGHT = 350.0f;
    private static final String EOL = "\n";
    private TGContext context;
    private UIWindow dialog;
    private UIReadOnlyTextBox output;
    private UIButton buttonCancel;
    private UIButton buttonClose;
    private TGConverter converter;
    private boolean finished;

    public TGConverterProcess(TGContext context) {
        this.context = context;
    }

    public void start(String initFolder, String destFolder, TGConverterFormat format) {
        this.converter = new TGConverter(this.context, initFolder, destFolder);
        this.converter.setFormat(format);
        this.converter.setListener(this);
        this.showProcess();
        new Thread(new Runnable(){

            @Override
            public void run() throws TGException {
                TGConverterProcess.this.converter.process();
            }
        }).start();
    }

    protected void showProcess() {
        this.finished = false;
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UIWindow uiParent = TGWindow.getInstance((TGContext)this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, false, true);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setBounds(new UIRectangle(0.0f, 0.0f, 650.0f, 350.0f));
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TuxGuitar.getInstance().getSkinManager().removeLoader((TGEventListener)TGConverterProcess.this);
                TuxGuitar.getInstance().getLanguageManager().removeLoader((TGEventListener)TGConverterProcess.this);
            }
        });
        this.dialog.addCloseListener(new UICloseListener(){

            public void onClose(UICloseEvent event) {
                if (TGConverterProcess.this.finished) {
                    TGConverterProcess.this.dialog.dispose();
                }
            }
        });
        this.output = uiFactory.createReadOnlyTextBox((UIContainer)this.dialog, true, true);
        dialogLayout.set((UIControl)this.output, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(false));
        this.buttonCancel = uiFactory.createButton((UIContainer)buttons);
        this.buttonCancel.setEnabled(false);
        this.buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGConverterProcess.this.converter.setCancelled(true);
            }
        });
        buttonsLayout.set((UIControl)this.buttonCancel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        this.buttonClose = uiFactory.createButton((UIContainer)buttons);
        this.buttonClose.setEnabled(false);
        this.buttonClose.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGConverterProcess.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)this.buttonClose, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)this.buttonClose, "margin_right", (Object)Float.valueOf(0.0f));
        this.loadIcons(false);
        this.loadProperties(false);
        TuxGuitar.getInstance().getSkinManager().addLoader((TGEventListener)this);
        TuxGuitar.getInstance().getLanguageManager().addLoader((TGEventListener)this);
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)6);
    }

    public boolean isDisposed() {
        return this.dialog == null || this.dialog.isDisposed();
    }

    public void loadProperties() {
        this.loadProperties(true);
    }

    public void loadProperties(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setText(TuxGuitar.getProperty((String)"batch.converter"));
            this.buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
            this.buttonClose.setText(TuxGuitar.getProperty((String)"close"));
            if (layout) {
                this.dialog.layout();
            }
        }
    }

    public void loadIcons() {
        this.loadIcons(true);
    }

    public void loadIcons(boolean layout) {
        if (!this.isDisposed()) {
            this.dialog.setImage(TuxGuitar.getInstance().getIconManager().getAppIcon());
            if (layout) {
                this.dialog.layout();
            }
        }
    }

    @Override
    public void notifyFileProcess(final String filename) {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){
                final /* synthetic */ TGConverterProcess this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() throws TGException {
                    if (!this.this$0.isDisposed()) {
                        this.this$0.output.append(TuxGuitar.getProperty((String)"batch.converter.messages.converting", (String[])new String[]{filename}));
                    }
                }
            });
        }
    }

    @Override
    public void notifyFileResult(final String filename, final int result) {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){
                final /* synthetic */ TGConverterProcess this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() throws TGException {
                    if (!this.this$0.isDisposed()) {
                        this.this$0.appendLogMessage(result, filename);
                    }
                }
            });
        }
    }

    @Override
    public void notifyStart() {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                @Override
                public void run() throws TGException {
                    if (!TGConverterProcess.this.isDisposed()) {
                        TGConverterProcess.this.finished = false;
                        TGConverterProcess.this.buttonClose.setEnabled(TGConverterProcess.this.finished);
                        TGConverterProcess.this.buttonCancel.setEnabled(!TGConverterProcess.this.finished);
                        TGConverterProcess.this.output.setCursor(UICursor.WAIT);
                    }
                }
            });
        }
    }

    @Override
    public void notifyFinish() {
        if (!this.isDisposed()) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                @Override
                public void run() throws TGException {
                    if (!TGConverterProcess.this.isDisposed()) {
                        TGConverterProcess.this.finished = true;
                        TGConverterProcess.this.buttonClose.setEnabled(TGConverterProcess.this.finished);
                        TGConverterProcess.this.buttonCancel.setEnabled(!TGConverterProcess.this.finished);
                        TGConverterProcess.this.output.setCursor(UICursor.NORMAL);
                    }
                }
            });
        }
    }

    public void appendLogMessage(int result, String fileName) {
        String message = TuxGuitar.getProperty((String)("batch.converter.messages." + (result == 250 ? "ok" : "failed"))) + EOL;
        switch (result) {
            case 401: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.couldnt-write", (String[])new String[]{fileName}) + EOL;
                break;
            }
            case 403: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.bad-file", (String[])new String[]{fileName}) + EOL;
                break;
            }
            case 404: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.file-not-found", (String[])new String[]{fileName}) + EOL;
                break;
            }
            case 500: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.out-of-memory", (String[])new String[]{fileName}) + EOL;
                break;
            }
            case 590: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.exporter-not-found", (String[])new String[]{fileName}) + EOL;
                break;
            }
            case 666: {
                message = message + TuxGuitar.getProperty((String)"batch.converter.messages.unknown-error", (String[])new String[]{fileName}) + EOL;
            }
        }
        this.output.append(message);
    }

    public void processEvent(TGEvent event) {
        if ("ui-skin".equals(event.getEventType())) {
            this.loadIcons();
        } else if ("language".equals(event.getEventType())) {
            this.loadProperties();
        }
    }
}

