/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.lv2.ui;

import java.util.Comparator;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.player.impl.midiport.lv2.LV2PluginValidator;
import org.herac.tuxguitar.player.impl.midiport.lv2.jni.LV2Plugin;
import org.herac.tuxguitar.player.impl.midiport.lv2.jni.LV2World;
import org.herac.tuxguitar.thread.TGThreadManager;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIMouseDoubleClickListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIListBoxSelect;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class LV2AudioProcessorChooser {
    private TGContext context;
    private LV2World world;

    public LV2AudioProcessorChooser(TGContext context, LV2World world) {
        this.context = context;
        this.world = world;
    }

    public void choose(final UIWindow parent, final LV2PluginValidator validator, final LV2AudioProcessorChooserHandler handler) {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){
            final /* synthetic */ LV2AudioProcessorChooser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.chooseInCurrentThread(parent, validator, handler);
            }
        });
    }

    public void chooseInCurrentThread(UIWindow parent, LV2PluginValidator validator, final LV2AudioProcessorChooserHandler handler) {
        List<LV2Plugin> plugins = this.getSortedPlugins();
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(parent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-lv2.chooser.dialog.title"));
        dialog.setImage(TGIconManager.getInstance((TGContext)this.context).getAppIcon());
        UITableLayout pluginGroupLayout = new UITableLayout();
        UILegendPanel pluginGroup = uiFactory.createLegendPanel((UIContainer)dialog);
        pluginGroup.setLayout((UILayout)pluginGroupLayout);
        pluginGroup.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-lv2.chooser.tip"));
        dialogLayout.set((UIControl)pluginGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIListBoxSelect pluginList = uiFactory.createListBoxSelect((UIContainer)pluginGroup);
        pluginGroupLayout.set((UIControl)pluginList, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        pluginGroupLayout.set((UIControl)pluginList, "minimum_packed_width", (Object)Float.valueOf(200.0f));
        pluginGroupLayout.set((UIControl)pluginList, "packed_height", (Object)Float.valueOf(200.0f));
        for (LV2Plugin plugin : plugins) {
            if (!validator.validate(plugin)) continue;
            pluginList.addItem(new UISelectItem(plugin.getName(), (Object)plugin));
        }
        if (plugins.size() > 0) {
            pluginList.setSelectedValue((Object)plugins.get(0));
        }
        pluginList.addMouseDoubleClickListener(new UIMouseDoubleClickListener(){
            final /* synthetic */ LV2AudioProcessorChooser this$0;
            {
                this.this$0 = this$0;
            }

            public void onMouseDoubleClick(UIMouseEvent event) {
                this.this$0.onSelectPlugin(handler, (LV2Plugin)pluginList.getSelectedValue());
                dialog.dispose();
            }
        });
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ LV2AudioProcessorChooser this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                this.this$0.onSelectPlugin(handler, (LV2Plugin)pluginList.getSelectedValue());
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ LV2AudioProcessorChooser this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    public List<LV2Plugin> getSortedPlugins() {
        List<LV2Plugin> plugins = this.world.getPlugins();
        plugins.sort(new Comparator<LV2Plugin>(){

            @Override
            public int compare(LV2Plugin p1, LV2Plugin p2) {
                String n1 = p1.getName();
                String n2 = p2.getName();
                if (n1 == null) {
                    n1 = "";
                }
                if (n2 == null) {
                    n2 = "";
                }
                return n1.compareTo(n2);
            }
        });
        return plugins;
    }

    public void onSelectPlugin(final LV2AudioProcessorChooserHandler handler, final LV2Plugin plugin) {
        TGThreadManager.getInstance((TGContext)this.context).start(new Runnable(){
            final /* synthetic */ LV2AudioProcessorChooser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                handler.onSelectPlugin(plugin);
            }
        });
    }

    public static interface LV2AudioProcessorChooserHandler {
        public void onSelectPlugin(LV2Plugin var1);
    }
}

