/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.sequencer;

import org.herac.tuxguitar.app.transport.TGTransport;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.jack.sequencer.JackSequencer;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.util.TGContext;

public class JackMidiPlayerStarter
implements TGEventListener {
    private TGContext context;
    private JackSequencer jackSequencer;
    private boolean countDownByPass;

    public JackMidiPlayerStarter(TGContext context, JackSequencer jackSequencer) {
        this.context = context;
        this.jackSequencer = jackSequencer;
    }

    private MidiPlayer getPlayer() {
        return MidiPlayer.getInstance((TGContext)this.context);
    }

    public void open() {
        this.getPlayer().addListener((TGEventListener)this);
    }

    public void close() {
        this.getPlayer().removeListener((TGEventListener)this);
    }

    public void start() {
        TGTransport.getInstance((TGContext)this.context).playPause(null, null);
    }

    public void processCountDownStarted() {
        boolean bl = this.countDownByPass = this.jackSequencer.getJackClient().isTransportRunning() && this.getPlayer().getCountDown().isEnabled();
        if (this.countDownByPass) {
            this.getPlayer().getCountDown().setEnabled(false);
        }
    }

    public void processCountDownStopped() {
        if (this.countDownByPass) {
            this.countDownByPass = false;
            this.getPlayer().getCountDown().setEnabled(true);
        }
    }

    public void processEvent(TGEvent event) {
        if ("midi-player-notification".equals(event.getEventType())) {
            int type = (Integer)event.getAttribute("notificationType");
            if (type == 3) {
                this.processCountDownStarted();
            } else if (type == 4) {
                this.processCountDownStopped();
            }
        }
    }
}

