/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.midi.MidiFileException;
import org.herac.tuxguitar.io.midi.MidiFileHeader;
import org.herac.tuxguitar.io.midi.base.MidiEvent;
import org.herac.tuxguitar.io.midi.base.MidiMessage;
import org.herac.tuxguitar.io.midi.base.MidiSequence;
import org.herac.tuxguitar.io.midi.base.MidiTrack;

public class MidiFileReader
implements MidiFileHeader {
    public static boolean CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX = true;
    private static final int STATUS_NONE = 0;
    private static final int STATUS_ONE_BYTE = 1;
    private static final int STATUS_TWO_BYTES = 2;
    private static final int STATUS_SYSEX = 3;
    private static final int STATUS_META = 4;

    public MidiSequence getSequence(InputStream stream) throws MidiFileException, IOException {
        DataInputStream in = new DataInputStream(stream);
        if (in.readInt() != 1297377380) {
            throw new MidiFileException("not a MIDI file: wrong header magic");
        }
        int headerLength = in.readInt();
        if (headerLength < 6) {
            throw new MidiFileException("corrupt MIDI file: wrong header length");
        }
        short type = in.readShort();
        if (type < 0 || type > 2) {
            throw new MidiFileException("corrupt MIDI file: illegal type");
        }
        if (type == 2) {
            throw new MidiFileException("this implementation doesn't support type 2 MIDI files");
        }
        int trackCount = in.readShort();
        if (trackCount <= 0) {
            throw new MidiFileException("corrupt MIDI file: number of tracks must be positive");
        }
        if (type == 0 && trackCount != 1) {
            throw new MidiFileException("corrupt MIDI file: type 0 files must contain exactly one track");
        }
        float divisionType = -1.0f;
        int resolution = -1;
        int division = in.readUnsignedShort();
        if ((division & 0x8000) != 0) {
            int frameType = -(division >>> 8 & 0xFF);
            if (frameType == 24) {
                divisionType = 24.0f;
            } else if (frameType == 25) {
                divisionType = 25.0f;
            } else if (frameType == 29) {
                divisionType = 29.97f;
            } else if (frameType == 30) {
                divisionType = 30.0f;
            } else {
                throw new MidiFileException("corrupt MIDI file: illegal frame division type");
            }
            resolution = division & 0xFF;
        } else {
            divisionType = 0.0f;
            resolution = division & Short.MAX_VALUE;
        }
        in.skip(headerLength - 6);
        MidiSequence sequence = new MidiSequence(divisionType, resolution);
        for (int i = 0; i < trackCount; ++i) {
            MidiTrack track = new MidiTrack();
            sequence.addTrack(track);
            this.readTrack(in, track);
        }
        in.close();
        return sequence;
    }

    private void readTrack(DataInputStream in, MidiTrack track) throws MidiFileException, IOException {
        while (in.readInt() != 1297379947) {
            int chunkLength = in.readInt();
            if (chunkLength % 2 != 0) {
                ++chunkLength;
            }
            in.skip(chunkLength);
        }
        MidiTrackReaderHelper helper = new MidiTrackReaderHelper(0L, in.readInt(), -1);
        while (helper.remainingBytes > 0L) {
            helper.ticks += MidiFileReader.readVariableLengthQuantity(in, helper);
            MidiEvent event = MidiFileReader.readEvent(in, helper);
            if (event == null) continue;
            track.add(event);
        }
    }

    private static MidiEvent readEvent(DataInputStream in, MidiTrackReaderHelper helper) throws MidiFileException, IOException {
        int type;
        int statusByte = MidiFileReader.readUnsignedByte(in, helper);
        int savedByte = 0;
        boolean runningStatusApplies = false;
        if (statusByte < 128) {
            if (helper.runningStatusByte != -1) {
                runningStatusApplies = true;
                savedByte = statusByte;
                statusByte = helper.runningStatusByte;
            } else {
                throw new MidiFileException("corrupt MIDI file: status byte missing");
            }
        }
        if ((type = MidiFileReader.getType(statusByte)) == 1) {
            int data = 0;
            if (runningStatusApplies) {
                data = savedByte;
            } else {
                data = MidiFileReader.readUnsignedByte(in, helper);
                helper.runningStatusByte = statusByte;
            }
            return new MidiEvent(MidiMessage.shortMessage(statusByte & 0xF0, statusByte & 0xF, data), helper.ticks);
        }
        if (type == 2) {
            int data1 = 0;
            if (runningStatusApplies) {
                data1 = savedByte;
            } else {
                data1 = MidiFileReader.readUnsignedByte(in, helper);
                helper.runningStatusByte = statusByte;
            }
            return new MidiEvent(MidiMessage.shortMessage(statusByte & 0xF0, statusByte & 0xF, data1, MidiFileReader.readUnsignedByte(in, helper)), helper.ticks);
        }
        if (type == 3) {
            if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
                helper.runningStatusByte = -1;
            }
            int dataLength = (int)MidiFileReader.readVariableLengthQuantity(in, helper);
            byte[] data = new byte[dataLength];
            for (int i = 0; i < dataLength; ++i) {
                data[i] = (byte)MidiFileReader.readUnsignedByte(in, helper);
            }
        } else if (type == 4) {
            if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
                helper.runningStatusByte = -1;
            }
            int typeByte = MidiFileReader.readUnsignedByte(in, helper);
            int dataLength = (int)MidiFileReader.readVariableLengthQuantity(in, helper);
            byte[] data = new byte[dataLength];
            for (int i = 0; i < dataLength; ++i) {
                data[i] = (byte)MidiFileReader.readUnsignedByte(in, helper);
            }
            return new MidiEvent(MidiMessage.metaMessage(typeByte, data), helper.ticks);
        }
        return null;
    }

    private static int getType(int statusByte) {
        if (statusByte < 240) {
            int command = statusByte & 0xF0;
            if (command == 128 || command == 144 || command == 160 || command == 176 || command == 224) {
                return 2;
            }
            if (command == 192 || command == 208) {
                return 1;
            }
            return 0;
        }
        if (statusByte == 240 || statusByte == 247) {
            return 3;
        }
        if (statusByte == 255) {
            return 4;
        }
        return 0;
    }

    public static long readVariableLengthQuantity(DataInputStream in, MidiTrackReaderHelper helper) throws MidiFileException, IOException {
        int count = 0;
        long value = 0L;
        while (count < 4) {
            int data = MidiFileReader.readUnsignedByte(in, helper);
            ++count;
            value <<= 7;
            value |= (long)(data & 0x7F);
            if (data >= 128) continue;
            return value;
        }
        throw new MidiFileException("not a MIDI file: unterminated variable-length quantity");
    }

    public static int readUnsignedByte(DataInputStream dataInputStream, MidiTrackReaderHelper helper) throws IOException {
        --helper.remainingBytes;
        return dataInputStream.readUnsignedByte();
    }

    private class MidiTrackReaderHelper {
        protected long ticks = 0L;
        protected long remainingBytes;
        protected int runningStatusByte;

        protected MidiTrackReaderHelper(long ticks, long remainingBytes, int runningStatusByte) {
            this.ticks = ticks;
            this.remainingBytes = remainingBytes;
            this.runningStatusByte = runningStatusByte;
        }
    }
}

