/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.widgets;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.ui.UIComponent;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UIPaintEvent;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;

public abstract class TGIconButton {
    private List<UISelectionListener> listeners = new ArrayList<UISelectionListener>();
    private UICanvas canvas;
    private UIImage icon;
    private UIImage hoveredIcon;
    private boolean hovered;

    public TGIconButton(UIFactory factory, UILayoutContainer parent) {
        this.canvas = factory.createCanvas((UIContainer)parent, false);
        this.canvas.addPaintListener(this::paint);
        this.canvas.addMouseUpListener(this::clicked);
        this.canvas.addMouseEnterListener(event -> this.setHovered(true));
        this.canvas.addMouseExitListener(event -> this.setHovered(false));
    }

    private void setHovered(boolean hovered) {
        if (this.hovered != hovered) {
            this.hovered = hovered;
            this.canvas.redraw();
        }
    }

    protected boolean isHovered() {
        return this.hovered;
    }

    protected UIImage getDisplayedImage() {
        if (this.icon == null || this.hovered && this.hoveredIcon != null) {
            return this.hoveredIcon;
        }
        return this.icon;
    }

    private void paint(UIPaintEvent event) {
        UIPainter painter = event.getPainter();
        UIImage image = this.getDisplayedImage();
        if (image != null) {
            this.resizeTo(image);
            painter.drawImage(image, 0.0f, 0.0f);
        }
    }

    private void clicked(UIMouseEvent event) {
        if (this.canvas.isEnabled() && event.getButton() == 1) {
            for (UISelectionListener listener : this.listeners) {
                listener.onSelect(new UISelectionEvent((UIComponent)this.canvas));
            }
        }
    }

    public void setIcon(UIImage icon) {
        if (icon != this.icon) {
            this.icon = icon;
            if (this.getDisplayedImage() == icon) {
                this.resizeTo(icon);
                this.canvas.redraw();
            }
        }
    }

    public void setHoveredIcon(UIImage icon) {
        if (icon != this.hoveredIcon) {
            this.hoveredIcon = icon;
            if (this.getDisplayedImage() == icon) {
                this.resizeTo(icon);
                this.canvas.redraw();
            }
        }
    }

    protected void resizeTo(UIImage image) {
        UILayoutContainer parent;
        UIRectangle area = this.canvas.getBounds();
        float w = image.getWidth();
        float h = image.getHeight();
        if ((w != area.getWidth() || h != area.getHeight()) && (parent = (UILayoutContainer)this.canvas.getParent()) != null) {
            UITableLayout layout = (UITableLayout)parent.getLayout();
            layout.set((UIControl)this.canvas, "packed_width", (Object)Float.valueOf(w));
            layout.set((UIControl)this.canvas, "packed_height", (Object)Float.valueOf(h));
            parent.layout();
        }
    }

    public UICanvas getControl() {
        return this.canvas;
    }

    public void addSelectionListener(UISelectionListener listener) {
        this.listeners.add(listener);
    }
}

