/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar.main;

import org.herac.tuxguitar.app.view.component.table.TGTableViewer;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelManagerDialog;
import org.herac.tuxguitar.app.view.dialog.fretboard.TGFretBoardEditor;
import org.herac.tuxguitar.app.view.dialog.transport.TGTransportDialog;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import org.herac.tuxguitar.app.view.toolbar.main.TGMainToolBar;
import org.herac.tuxguitar.app.view.toolbar.main.TGMainToolBarSection;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.toolbar.UIToolActionItem;
import org.herac.tuxguitar.ui.toolbar.UIToolCheckableItem;
import org.herac.tuxguitar.ui.toolbar.UIToolMenuItem;

public class TGMainToolBarSectionView
extends TGMainToolBarSection {
    private UIToolCheckableItem showEditToolBar;
    private UIToolCheckableItem showTrackTable;
    private UIToolMenuItem menuItem;
    private UIMenuActionItem showFretBoard;
    private UIMenuActionItem showInstruments;
    private UIMenuActionItem showTransport;
    private UIToolActionItem zoomOut;
    private UIToolActionItem zoomReset;
    private UIToolActionItem zoomIn;

    public TGMainToolBarSectionView(TGMainToolBar toolBar) {
        super(toolBar);
    }

    @Override
    public void createSection() {
        this.showEditToolBar = this.getToolBar().getControl().createCheckItem();
        this.showEditToolBar.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-edit-toolbar"));
        this.showTrackTable = this.getToolBar().getControl().createCheckItem();
        this.showTrackTable.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-table-viewer"));
        this.menuItem = this.getToolBar().getControl().createMenuItem();
        this.showInstruments = this.menuItem.getMenu().createActionItem();
        this.showInstruments.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-channels-dialog"));
        this.showTransport = this.menuItem.getMenu().createActionItem();
        this.showTransport.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-transport-dialog"));
        this.showFretBoard = this.menuItem.getMenu().createActionItem();
        this.showFretBoard.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-fretboard-editor"));
        this.zoomOut = this.getToolBar().getControl().createActionItem();
        this.zoomOut.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-decrement-scale"));
        this.zoomReset = this.getToolBar().getControl().createActionItem();
        this.zoomReset.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-reset-scale"));
        this.zoomIn = this.getToolBar().getControl().createActionItem();
        this.zoomIn.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-increment-scale"));
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void loadProperties() {
        this.showEditToolBar.setToolTipText(this.getText("view.show-edit-toolbar"));
        this.showTrackTable.setToolTipText(this.getText("view.show-table-viewer"));
        this.menuItem.setToolTipText(this.getText("view"));
        this.showInstruments.setText(this.getText("view.show-instruments", !TGChannelManagerDialog.getInstance(this.getToolBar().getContext()).isDisposed()));
        this.showTransport.setText(this.getText("view.show-transport", !TGTransportDialog.getInstance(this.getToolBar().getContext()).isDisposed()));
        this.showFretBoard.setText(this.getText("view.show-fretboard", TGFretBoardEditor.getInstance(this.getToolBar().getContext()).isVisible()));
        this.zoomOut.setToolTipText(this.getText("view.zoom.out"));
        this.zoomReset.setToolTipText(this.getText("view.zoom.reset"));
        this.zoomIn.setToolTipText(this.getText("view.zoom.in"));
    }

    @Override
    public void loadIcons() {
        this.showEditToolBar.setImage(this.getIconManager().getToolbarEdit());
        this.showTrackTable.setImage(this.getIconManager().getTableViewer());
        this.menuItem.setImage(this.getIconManager().getFretboard());
        this.showInstruments.setImage(this.getIconManager().getInstruments());
        this.showTransport.setImage(this.getIconManager().getTransport());
        this.showFretBoard.setImage(this.getIconManager().getFretboard());
        this.zoomOut.setImage(this.getIconManager().getZoomOut());
        this.zoomReset.setImage(this.getIconManager().getZoomReset());
        this.zoomIn.setImage(this.getIconManager().getZoomIn());
    }

    @Override
    public void updateItems() {
        this.showEditToolBar.setChecked(TGEditToolBar.getInstance(this.getToolBar().getContext()).isVisible());
        this.showTrackTable.setChecked(TGTableViewer.getInstance(this.getToolBar().getContext()).isVisible());
        this.showInstruments.setText(this.getText("view.show-instruments", !TGChannelManagerDialog.getInstance(this.getToolBar().getContext()).isDisposed()));
        this.showTransport.setText(this.getText("view.show-transport", !TGTransportDialog.getInstance(this.getToolBar().getContext()).isDisposed()));
        this.showFretBoard.setText(this.getText("view.show-fretboard", TGFretBoardEditor.getInstance(this.getToolBar().getContext()).isVisible()));
    }
}

