/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar.main;

import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.view.toolbar.main.TGMainToolBar;
import org.herac.tuxguitar.app.view.toolbar.main.TGMainToolBarSection;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.toolbar.UIToolActionItem;
import org.herac.tuxguitar.util.TGContext;

public class TGMainToolBarSectionTransport
extends TGMainToolBarSection {
    private UIToolActionItem first;
    private UIToolActionItem last;
    private UIToolActionItem previous;
    private UIToolActionItem next;
    private UIToolActionItem stop;
    private UIToolActionItem play;
    private UIToolActionItem mode;
    private boolean isRunning;

    public TGMainToolBarSectionTransport(TGMainToolBar toolBar) {
        super(toolBar);
    }

    @Override
    public void createSection() {
        this.first = this.getToolBar().getControl().createActionItem();
        this.first.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.getToolBar().getContext(), "action.measure.go-first"));
        this.previous = this.getToolBar().getControl().createActionItem();
        this.previous.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.getToolBar().getContext(), "action.measure.go-previous"));
        this.play = this.getToolBar().getControl().createActionItem();
        this.play.addSelectionListener((UISelectionListener)this.createActionProcessor("action.transport.play"));
        this.stop = this.getToolBar().getControl().createActionItem();
        this.stop.addSelectionListener((UISelectionListener)this.createActionProcessor("action.transport.stop"));
        this.next = this.getToolBar().getControl().createActionItem();
        this.next.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.getToolBar().getContext(), "action.measure.go-next"));
        this.last = this.getToolBar().getControl().createActionItem();
        this.last.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.getToolBar().getContext(), "action.measure.go-last"));
        this.mode = this.getToolBar().getControl().createActionItem();
        this.mode.addSelectionListener((UISelectionListener)new TGActionProcessorListener(this.getToolBar().getContext(), "action.gui.open-transport-mode-dialog"));
        this.isRunning = false;
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void updateItems() {
        this.loadIcons(false);
    }

    @Override
    public void loadProperties() {
        this.play.setToolTipText(this.getText("transport.start"));
        this.stop.setToolTipText(this.getText("transport.stop"));
        this.first.setToolTipText(this.getText("transport.first"));
        this.last.setToolTipText(this.getText("transport.last"));
        this.previous.setToolTipText(this.getText("transport.previous"));
        this.next.setToolTipText(this.getText("transport.next"));
        this.mode.setToolTipText(this.getText("transport.mode"));
    }

    @Override
    public void loadIcons() {
        this.loadIcons(true);
    }

    public void loadIcons(boolean force) {
        boolean lastStatusRunning = this.isRunning;
        MidiPlayer player = MidiPlayer.getInstance((TGContext)this.getToolBar().getContext());
        this.isRunning = player.isRunning();
        if (force || lastStatusRunning != this.isRunning) {
            this.first.setImage(this.getIconManager().getTransportIconFirst());
            this.last.setImage(this.getIconManager().getTransportIconLast());
            this.previous.setImage(this.getIconManager().getTransportIconPrevious());
            this.next.setImage(this.getIconManager().getTransportIconNext());
            this.stop.setImage(this.getIconManager().getTransportIconStop());
            if (this.isRunning) {
                this.play.setImage(this.getIconManager().getTransportIconPause());
                this.play.setToolTipText(this.getText("transport.pause"));
            } else {
                this.play.setImage(this.getIconManager().getTransportIconPlay());
                this.play.setToolTipText(this.getText("transport.start"));
            }
        }
        this.mode.setImage(this.getIconManager().getTransportMode());
    }
}

