/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.player.base.MidiPlayerMode;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuCheckableItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;

public class TransportMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem transportMenuItem;
    private UIMenuActionItem play;
    private UIMenuActionItem stop;
    private UIMenuCheckableItem metronome;
    private UIMenuCheckableItem countDown;
    private UIMenuActionItem mode;
    private UIMenuCheckableItem loopSHeader;
    private UIMenuCheckableItem loopEHeader;
    private UIMenuCheckableItem highlightPlayedBeat;
    private boolean isRunning;

    public TransportMenuItem(UIMenu parent) {
        this.transportMenuItem = parent.createSubMenuItem();
    }

    @Override
    public void showItems() {
        this.play = this.transportMenuItem.getMenu().createActionItem();
        this.play.addSelectionListener((UISelectionListener)this.createActionProcessor("action.transport.play"));
        this.stop = this.transportMenuItem.getMenu().createActionItem();
        this.stop.addSelectionListener((UISelectionListener)this.createActionProcessor("action.transport.stop"));
        this.transportMenuItem.getMenu().createSeparator();
        this.metronome = this.transportMenuItem.getMenu().createCheckItem();
        this.metronome.addSelectionListener((UISelectionListener)this.createActionProcessor("action.transport.metronome"));
        this.countDown = this.transportMenuItem.getMenu().createCheckItem();
        this.countDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.transport.count-down"));
        this.mode = this.transportMenuItem.getMenu().createActionItem();
        this.mode.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-transport-mode-dialog"));
        this.transportMenuItem.getMenu().createSeparator();
        this.loopSHeader = this.transportMenuItem.getMenu().createCheckItem();
        this.loopSHeader.addSelectionListener((UISelectionListener)this.createActionProcessor("action.transport.set-loop-start"));
        this.loopEHeader = this.transportMenuItem.getMenu().createCheckItem();
        this.loopEHeader.addSelectionListener((UISelectionListener)this.createActionProcessor("action.transport.set-loop-end"));
        this.transportMenuItem.getMenu().createSeparator();
        this.highlightPlayedBeat = this.transportMenuItem.getMenu().createCheckItem();
        this.highlightPlayedBeat.addSelectionListener((UISelectionListener)this.createActionProcessor("action.transport.highlight-played-beat"));
        this.isRunning = false;
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void update() {
        TGMeasureImpl measure = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getMeasure();
        MidiPlayerMode pm = TuxGuitar.getInstance().getPlayer().getMode();
        this.metronome.setChecked(TuxGuitar.getInstance().getPlayer().isMetronomeEnabled());
        this.countDown.setChecked(TuxGuitar.getInstance().getPlayer().getCountDown().isEnabled());
        this.loopSHeader.setEnabled(pm.isLoop());
        this.loopSHeader.setChecked(measure != null && measure.getNumber() == pm.getLoopSHeader());
        this.loopEHeader.setEnabled(pm.isLoop());
        this.loopEHeader.setChecked(measure != null && measure.getNumber() == pm.getLoopEHeader());
        Tablature tablature = TablatureEditor.getInstance(this.findContext()).getTablature();
        int style = tablature.getViewLayout().getStyle();
        this.highlightPlayedBeat.setChecked((style & 0x80) != 0);
        this.loadIcons(false);
        this.play.setText(TuxGuitar.getProperty(this.isRunning ? "transport.pause" : "transport.start"));
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.transportMenuItem, "transport", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.play, "transport.start", "action.transport.play");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.stop, "transport.stop", "action.transport.stop");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.mode, "transport.mode", "action.gui.open-transport-mode-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.metronome, "transport.metronome", "action.transport.metronome");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.countDown, "transport.count-down", "action.transport.count-down");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.loopSHeader, "transport.set-loop-start", "action.transport.set-loop-start");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.loopEHeader, "transport.set-loop-end", "action.transport.set-loop-end");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.highlightPlayedBeat, "transport.highlight-played-beat", "action.transport.highlight-played-beat");
    }

    public void loadIcons() {
        this.loadIcons(true);
        this.metronome.setImage(TuxGuitar.getInstance().getIconManager().getTransportMetronome());
        this.countDown.setImage(TuxGuitar.getInstance().getIconManager().getTransportCountIn());
        this.mode.setImage(TuxGuitar.getInstance().getIconManager().getTransportMode());
        this.loopSHeader.setImage(TuxGuitar.getInstance().getIconManager().getTransportLoopStart());
        this.loopEHeader.setImage(TuxGuitar.getInstance().getIconManager().getTransportLoopEnd());
        this.highlightPlayedBeat.setImage(TuxGuitar.getInstance().getIconManager().getLayoutHighlightPlayedBeat());
    }

    public void loadIcons(boolean force) {
        boolean lastStatusRunning = this.isRunning;
        this.isRunning = TuxGuitar.getInstance().getPlayer().isRunning();
        if (force || lastStatusRunning != this.isRunning) {
            this.stop.setImage(TuxGuitar.getInstance().getIconManager().getTransportIconStop());
            if (this.isRunning) {
                this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportIconPause());
            } else {
                this.play.setImage(TuxGuitar.getInstance().getIconManager().getTransportIconPlay());
            }
        }
    }
}

