/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.custom.TGCustomTool;
import org.herac.tuxguitar.app.tools.custom.TGCustomToolManager;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;

public class ToolMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem settingsMenuItem;
    private UIMenuActionItem scale;
    private UIMenuActionItem browser;
    private UIMenuActionItem transpose;
    private UIMenuActionItem plugins;
    private UIMenuActionItem config;
    private UIMenuActionItem keyBindings;
    private HashMap<UIMenuActionItem, String> pluginsMap = new HashMap();

    public ToolMenuItem(UIMenu parent) {
        this.settingsMenuItem = parent.createSubMenuItem();
    }

    @Override
    public void showItems() {
        this.transpose = this.settingsMenuItem.getMenu().createActionItem();
        this.transpose.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-transpose-dialog"));
        this.scale = this.settingsMenuItem.getMenu().createActionItem();
        this.scale.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-scale-dialog"));
        this.browser = this.settingsMenuItem.getMenu().createActionItem();
        this.browser.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-browser-dialog"));
        Iterator<TGCustomTool> it = TGCustomToolManager.instance().getCustomTools();
        while (it.hasNext()) {
            TGCustomTool tool = it.next();
            UIMenuActionItem uiMenuItem = this.settingsMenuItem.getMenu().createActionItem();
            this.pluginsMap.put(uiMenuItem, tool.getName());
            uiMenuItem.addSelectionListener((UISelectionListener)this.createActionProcessor(tool.getAction()));
        }
        this.settingsMenuItem.getMenu().createSeparator();
        this.plugins = this.settingsMenuItem.getMenu().createActionItem();
        this.plugins.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-plugin-list-dialog"));
        this.keyBindings = this.settingsMenuItem.getMenu().createActionItem();
        this.keyBindings.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-key-binding-editor"));
        this.config = this.settingsMenuItem.getMenu().createActionItem();
        this.config.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-settings-editor"));
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.settingsMenuItem, "tools", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.transpose, "tools.transpose", "action.gui.open-transpose-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.scale, "tools.scale", "action.gui.open-scale-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.browser, "tools.browser", "action.gui.toggle-browser-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.plugins, "tools.plugins", "action.gui.open-plugin-list-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.keyBindings, "tools.shortcuts", "action.gui.open-key-binding-editor");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.config, "tools.settings", "action.gui.open-settings-editor");
        for (Map.Entry<UIMenuActionItem, String> mapItem : this.pluginsMap.entrySet()) {
            mapItem.getKey().setText(TuxGuitar.getProperty(mapItem.getValue()));
        }
    }

    public void loadIcons() {
        this.browser.setImage(TuxGuitar.getInstance().getIconManager().getBrowserCollection());
        this.plugins.setImage(TuxGuitar.getInstance().getIconManager().getToolsPlugins());
        this.keyBindings.setImage(TuxGuitar.getInstance().getIconManager().getToolsShortcuts());
        this.config.setImage(TuxGuitar.getInstance().getIconManager().getToolsSettings());
    }

    @Override
    public void update() {
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.transpose.setEnabled(!running);
    }
}

