/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.component.tab.edit.EditorKit;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.editor.clipboard.TGClipboard;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuCheckableItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;
import org.herac.tuxguitar.util.TGContext;

public class EditMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem editMenuItem;
    private UIMenuActionItem cut;
    private UIMenuActionItem copy;
    private UIMenuActionItem paste;
    private UIMenuActionItem repeat;
    private UIMenuActionItem undo;
    private UIMenuActionItem redo;
    private UIMenuActionItem selectAll;
    private UIMenuActionItem selectNone;
    private UIMenuSubMenuItem extendSelection;
    private UIMenuActionItem extendSelectionLeft;
    private UIMenuActionItem extendSelectionRight;
    private UIMenuActionItem extendSelectionPrevious;
    private UIMenuActionItem extendSelectionNext;
    private UIMenuActionItem extendSelectionFirst;
    private UIMenuActionItem extendSelectionLast;
    private UIMenuCheckableItem modeSelection;
    private UIMenuCheckableItem modeEdition;
    private UIMenuCheckableItem notNaturalKey;
    private UIMenuCheckableItem voice1;
    private UIMenuCheckableItem voice2;

    public EditMenuItem(UIMenu parent) {
        this.editMenuItem = parent.createSubMenuItem();
    }

    @Override
    public void showItems() {
        this.cut = this.editMenuItem.getMenu().createActionItem();
        this.cut.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.cut"));
        this.copy = this.editMenuItem.getMenu().createActionItem();
        this.copy.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.copy"));
        this.paste = this.editMenuItem.getMenu().createActionItem();
        this.paste.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.paste"));
        this.repeat = this.editMenuItem.getMenu().createActionItem();
        this.repeat.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.repeat"));
        this.editMenuItem.getMenu().createSeparator();
        this.undo = this.editMenuItem.getMenu().createActionItem();
        this.undo.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.undo"));
        this.redo = this.editMenuItem.getMenu().createActionItem();
        this.redo.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.redo"));
        this.editMenuItem.getMenu().createSeparator();
        this.selectAll = this.editMenuItem.getMenu().createActionItem();
        this.selectAll.addSelectionListener((UISelectionListener)this.createActionProcessor("action.selection.select-all"));
        this.selectNone = this.editMenuItem.getMenu().createActionItem();
        this.selectNone.addSelectionListener((UISelectionListener)this.createActionProcessor("action.selection.clear"));
        this.extendSelection = this.editMenuItem.getMenu().createSubMenuItem();
        this.extendSelectionLeft = this.extendSelection.getMenu().createActionItem();
        this.extendSelectionLeft.addSelectionListener((UISelectionListener)this.createActionProcessor("action.selection.extend-left"));
        this.extendSelectionRight = this.extendSelection.getMenu().createActionItem();
        this.extendSelectionRight.addSelectionListener((UISelectionListener)this.createActionProcessor("action.selection.extend-right"));
        this.extendSelectionPrevious = this.extendSelection.getMenu().createActionItem();
        this.extendSelectionPrevious.addSelectionListener((UISelectionListener)this.createActionProcessor("action.selection.extend-previous"));
        this.extendSelectionNext = this.extendSelection.getMenu().createActionItem();
        this.extendSelectionNext.addSelectionListener((UISelectionListener)this.createActionProcessor("action.selection.extend-next"));
        this.extendSelectionFirst = this.extendSelection.getMenu().createActionItem();
        this.extendSelectionFirst.addSelectionListener((UISelectionListener)this.createActionProcessor("action.selection.extend-first"));
        this.extendSelectionLast = this.extendSelection.getMenu().createActionItem();
        this.extendSelectionLast.addSelectionListener((UISelectionListener)this.createActionProcessor("action.selection.extend-last"));
        this.editMenuItem.getMenu().createSeparator();
        this.modeSelection = this.editMenuItem.getMenu().createRadioItem();
        this.modeSelection.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-mouse-mode-selection"));
        this.modeEdition = this.editMenuItem.getMenu().createRadioItem();
        this.modeEdition.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-mouse-mode-edition"));
        this.notNaturalKey = this.editMenuItem.getMenu().createCheckItem();
        this.notNaturalKey.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.set-natural-key"));
        this.editMenuItem.getMenu().createSeparator();
        this.voice1 = this.editMenuItem.getMenu().createRadioItem();
        this.voice1.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.voice-1"));
        this.voice2 = this.editMenuItem.getMenu().createRadioItem();
        this.voice2.addSelectionListener((UISelectionListener)this.createActionProcessor("action.edit.voice-2"));
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void update() {
        EditorKit kit = TuxGuitar.getInstance().getTablatureEditor().getTablature().getEditorKit();
        Tablature tablature = TablatureEditor.getInstance(this.findContext()).getTablature();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.cut.setEnabled(!running && tablature.getSelector().isActive());
        this.copy.setEnabled(!running);
        this.paste.setEnabled(!running && TGClipboard.getInstance((TGContext)this.findContext()).hasContents());
        this.repeat.setEnabled(!running && tablature.getSelector().isActive());
        this.undo.setEnabled(!running && TuxGuitar.getInstance().getUndoableManager().canUndo());
        this.redo.setEnabled(!running && TuxGuitar.getInstance().getUndoableManager().canRedo());
        this.selectAll.setEnabled(!running);
        this.selectNone.setEnabled(!running && tablature.getSelector().isActive());
        this.extendSelection.setEnabled(!running && tablature.getSelector().isActive());
        this.extendSelectionLeft.setEnabled(!running && tablature.getSelector().isActive());
        this.extendSelectionRight.setEnabled(!running && tablature.getSelector().isActive());
        this.extendSelectionPrevious.setEnabled(!running && tablature.getSelector().isActive());
        this.extendSelectionNext.setEnabled(!running && tablature.getSelector().isActive());
        this.extendSelectionFirst.setEnabled(!running && tablature.getSelector().isActive());
        this.extendSelectionLast.setEnabled(!running && tablature.getSelector().isActive());
        this.modeSelection.setChecked(kit.getMouseMode() == 1);
        this.modeSelection.setEnabled(!running);
        this.modeEdition.setChecked(kit.getMouseMode() == 2);
        this.modeEdition.setEnabled(!running);
        this.notNaturalKey.setChecked(!kit.isNatural());
        this.notNaturalKey.setEnabled(!running && kit.getMouseMode() == 2);
        this.voice1.setChecked(kit.getTablature().getCaret().getVoice() == 0);
        this.voice2.setChecked(kit.getTablature().getCaret().getVoice() == 1);
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.editMenuItem, "edit.menu", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.cut, "edit.cut", "action.edit.cut");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.copy, "edit.copy", "action.edit.copy");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.paste, "edit.paste", "action.edit.paste");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.repeat, "edit.repeat", "action.edit.repeat");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.undo, "edit.undo", "action.edit.undo");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.redo, "edit.redo", "action.edit.redo");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.selectAll, "action.selection.select-all", "action.selection.select-all");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.selectNone, "action.selection.clear", "action.selection.clear");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.extendSelection, "edit.selection.extend", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.extendSelectionLeft, "action.selection.extend-left", "action.selection.extend-left");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.extendSelectionRight, "action.selection.extend-right", "action.selection.extend-right");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.extendSelectionPrevious, "action.selection.extend-previous", "action.selection.extend-previous");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.extendSelectionNext, "action.selection.extend-next", "action.selection.extend-next");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.extendSelectionFirst, "action.selection.extend-first", "action.selection.extend-first");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.extendSelectionLast, "action.selection.extend-last", "action.selection.extend-last");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.modeSelection, "edit.mouse-mode-selection", "action.edit.set-mouse-mode-selection");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.modeEdition, "edit.mouse-mode-edition", "action.edit.set-mouse-mode-edition");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.notNaturalKey, "edit.not-natural-key", "action.edit.set-natural-key");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.voice1, "edit.voice-1", "action.edit.voice-1");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.voice2, "edit.voice-2", "action.edit.voice-2");
    }

    public void loadIcons() {
        this.cut.setImage(TuxGuitar.getInstance().getIconManager().getEditCut());
        this.copy.setImage(TuxGuitar.getInstance().getIconManager().getEditCopy());
        this.paste.setImage(TuxGuitar.getInstance().getIconManager().getEditPaste());
        this.repeat.setImage(TuxGuitar.getInstance().getIconManager().getEditRepeat());
        this.undo.setImage(TuxGuitar.getInstance().getIconManager().getEditUndo());
        this.redo.setImage(TuxGuitar.getInstance().getIconManager().getEditRedo());
        this.modeSelection.setImage(TuxGuitar.getInstance().getIconManager().getEditModeSelection());
        this.modeEdition.setImage(TuxGuitar.getInstance().getIconManager().getEditModeEdition());
        this.notNaturalKey.setImage(TuxGuitar.getInstance().getIconManager().getEditModeEditionNotNatural());
        this.voice1.setImage(TuxGuitar.getInstance().getIconManager().getEditVoice1());
        this.voice2.setImage(TuxGuitar.getInstance().getIconManager().getEditVoice2());
    }
}

