/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.DivisionMenuItem;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuCheckableItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;

public class DurationMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem durationMenuItem;
    private UIMenuCheckableItem whole;
    private UIMenuCheckableItem half;
    private UIMenuCheckableItem quarter;
    private UIMenuCheckableItem eighth;
    private UIMenuCheckableItem sixteenth;
    private UIMenuCheckableItem thirtySecond;
    private UIMenuCheckableItem sixtyFourth;
    private UIMenuCheckableItem dotted;
    private UIMenuCheckableItem doubleDotted;
    private UIMenuCheckableItem tiedNote;
    private DivisionMenuItem divisionMenuItem;

    public DurationMenuItem(UIMenuSubMenuItem durationMenuItem) {
        this.durationMenuItem = durationMenuItem;
    }

    public DurationMenuItem(UIMenu parent) {
        this(parent.createSubMenuItem());
    }

    @Override
    public void showItems() {
        this.whole = this.durationMenuItem.getMenu().createCheckItem();
        this.whole.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-whole"));
        this.half = this.durationMenuItem.getMenu().createCheckItem();
        this.half.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-half"));
        this.quarter = this.durationMenuItem.getMenu().createCheckItem();
        this.quarter.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-quarter"));
        this.eighth = this.durationMenuItem.getMenu().createCheckItem();
        this.eighth.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-eighth"));
        this.sixteenth = this.durationMenuItem.getMenu().createCheckItem();
        this.sixteenth.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-sixteenth"));
        this.thirtySecond = this.durationMenuItem.getMenu().createCheckItem();
        this.thirtySecond.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-thirty-second"));
        this.sixtyFourth = this.durationMenuItem.getMenu().createCheckItem();
        this.sixtyFourth.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.set-sixty-fourth"));
        this.durationMenuItem.getMenu().createSeparator();
        this.dotted = this.durationMenuItem.getMenu().createCheckItem();
        this.dotted.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.change-dotted"));
        this.doubleDotted = this.durationMenuItem.getMenu().createCheckItem();
        this.doubleDotted.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.change-double-dotted"));
        this.durationMenuItem.getMenu().createSeparator();
        this.tiedNote = this.durationMenuItem.getMenu().createCheckItem();
        this.tiedNote.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.duration.tied"));
        this.durationMenuItem.getMenu().createSeparator();
        this.divisionMenuItem = new DivisionMenuItem(this.durationMenuItem.getMenu().createSubMenuItem());
        this.divisionMenuItem.showItems();
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void update() {
        Tablature tablature = TuxGuitar.getInstance().getTablatureEditor().getTablature();
        Caret caret = tablature.getCaret();
        TGDuration duration = caret.getDuration();
        TGNote note = caret.getSelectedNote();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.whole.setChecked(duration.getValue() == 1);
        this.whole.setEnabled(!running);
        this.half.setChecked(duration.getValue() == 2);
        this.half.setEnabled(!running);
        this.quarter.setChecked(duration.getValue() == 4);
        this.quarter.setEnabled(!running);
        this.eighth.setChecked(duration.getValue() == 8);
        this.eighth.setEnabled(!running);
        this.sixteenth.setChecked(duration.getValue() == 16);
        this.sixteenth.setEnabled(!running);
        this.thirtySecond.setChecked(duration.getValue() == 32);
        this.thirtySecond.setEnabled(!running);
        this.sixtyFourth.setChecked(duration.getValue() == 64);
        this.sixtyFourth.setEnabled(!running);
        this.dotted.setChecked(duration.isDotted());
        this.dotted.setEnabled(!running);
        this.doubleDotted.setChecked(duration.isDoubleDotted());
        this.doubleDotted.setEnabled(!running);
        this.tiedNote.setChecked(note != null && note.isTiedNote());
        this.tiedNote.setEnabled(!running);
        this.divisionMenuItem.update();
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.durationMenuItem, "duration", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.whole, "duration.whole", "action.note.duration.set-whole");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.half, "duration.half", "action.note.duration.set-half");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.quarter, "duration.quarter", "action.note.duration.set-quarter");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.eighth, "duration.eighth", "action.note.duration.set-eighth");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.sixteenth, "duration.sixteenth", "action.note.duration.set-sixteenth");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.thirtySecond, "duration.thirtysecond", "action.note.duration.set-thirty-second");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.sixtyFourth, "duration.sixtyfourth", "action.note.duration.set-sixty-fourth");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.dotted, "duration.dotted", "action.note.duration.change-dotted");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.doubleDotted, "duration.doubledotted", "action.note.duration.change-double-dotted");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.tiedNote, "duration.tiednote", "action.note.duration.tied");
        this.divisionMenuItem.loadProperties();
    }

    public void loadIcons() {
        this.whole.setImage(TuxGuitar.getInstance().getIconManager().getDuration(1));
        this.half.setImage(TuxGuitar.getInstance().getIconManager().getDuration(2));
        this.quarter.setImage(TuxGuitar.getInstance().getIconManager().getDuration(4));
        this.eighth.setImage(TuxGuitar.getInstance().getIconManager().getDuration(8));
        this.sixteenth.setImage(TuxGuitar.getInstance().getIconManager().getDuration(16));
        this.thirtySecond.setImage(TuxGuitar.getInstance().getIconManager().getDuration(32));
        this.sixtyFourth.setImage(TuxGuitar.getInstance().getIconManager().getDuration(64));
        this.dotted.setImage(TuxGuitar.getInstance().getIconManager().getDurationDotted());
        this.doubleDotted.setImage(TuxGuitar.getInstance().getIconManager().getDurationDoubleDotted());
        this.tiedNote.setImage(TuxGuitar.getInstance().getIconManager().getNoteTied());
        this.divisionMenuItem.loadIcons();
    }
}

