/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;

public class CompositionMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem compositionMenuItem;
    private UIMenuActionItem timeSignature;
    private UIMenuActionItem tempo;
    private UIMenuActionItem clef;
    private UIMenuActionItem keySignature;
    private UIMenuActionItem repeatOpen;
    private UIMenuActionItem repeatClose;
    private UIMenuActionItem repeatAlternative;
    private UIMenuActionItem tripletFeel;
    private UIMenuActionItem properties;

    public CompositionMenuItem(UIMenu parent) {
        this.compositionMenuItem = parent.createSubMenuItem();
    }

    @Override
    public void showItems() {
        this.timeSignature = this.compositionMenuItem.getMenu().createActionItem();
        this.timeSignature.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-time-signature-dialog"));
        this.tempo = this.compositionMenuItem.getMenu().createActionItem();
        this.tempo.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-tempo-dialog"));
        this.clef = this.compositionMenuItem.getMenu().createActionItem();
        this.clef.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-clef-dialog"));
        this.keySignature = this.compositionMenuItem.getMenu().createActionItem();
        this.keySignature.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-key-signature-dialog"));
        this.tripletFeel = this.compositionMenuItem.getMenu().createActionItem();
        this.tripletFeel.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-triplet-feel-dialog"));
        this.compositionMenuItem.getMenu().createSeparator();
        this.repeatOpen = this.compositionMenuItem.getMenu().createActionItem();
        this.repeatOpen.addSelectionListener((UISelectionListener)this.createActionProcessor("action.insert.open-repeat"));
        this.repeatClose = this.compositionMenuItem.getMenu().createActionItem();
        this.repeatClose.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-repeat-close-dialog"));
        this.repeatAlternative = this.compositionMenuItem.getMenu().createActionItem();
        this.repeatAlternative.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-repeat-alternative-dialog"));
        this.compositionMenuItem.getMenu().createSeparator();
        this.properties = this.compositionMenuItem.getMenu().createActionItem();
        this.properties.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-song-info-dialog"));
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void update() {
        boolean isPercussion = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().isPercussion();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.timeSignature.setEnabled(!running);
        this.tempo.setEnabled(!running);
        this.clef.setEnabled(!running && !isPercussion);
        this.keySignature.setEnabled(!running && !isPercussion);
        this.tripletFeel.setEnabled(!running);
        this.repeatOpen.setEnabled(!running);
        this.repeatClose.setEnabled(!running);
        this.repeatAlternative.setEnabled(!running);
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.compositionMenuItem, "composition", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.timeSignature, "composition.timesignature", "action.gui.open-time-signature-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.tempo, "composition.tempo", "action.gui.open-tempo-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.clef, "composition.clef", "action.gui.open-clef-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.keySignature, "composition.keysignature", "action.gui.open-key-signature-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.tripletFeel, "composition.tripletfeel", "action.gui.open-triplet-feel-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.repeatOpen, "repeat.open", "action.insert.open-repeat");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.repeatClose, "repeat.close", "action.gui.open-repeat-close-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.repeatAlternative, "repeat.alternative", "action.gui.open-repeat-alternative-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.properties, "composition.properties", "action.gui.open-song-info-dialog");
    }

    public void loadIcons() {
        this.timeSignature.setImage(TuxGuitar.getInstance().getIconManager().getCompositionTimeSignature());
        this.tempo.setImage(TuxGuitar.getInstance().getIconManager().getCompositionTempo());
        this.clef.setImage(TuxGuitar.getInstance().getIconManager().getCompositionClef());
        this.keySignature.setImage(TuxGuitar.getInstance().getIconManager().getCompositionKeySignature());
        this.tripletFeel.setImage(TuxGuitar.getInstance().getIconManager().getCompositionTripletFeel());
        this.repeatOpen.setImage(TuxGuitar.getInstance().getIconManager().getCompositionRepeatOpen());
        this.repeatClose.setImage(TuxGuitar.getInstance().getIconManager().getCompositionRepeatClose());
        this.repeatAlternative.setImage(TuxGuitar.getInstance().getIconManager().getCompositionRepeatAlternative());
        this.properties.setImage(TuxGuitar.getInstance().getIconManager().getSongProperties());
    }
}

