/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.Caret;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.ChordMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.DurationMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.DynamicMenuItem;
import org.herac.tuxguitar.app.view.menu.impl.NoteEffectsMenuItem;
import org.herac.tuxguitar.graphics.control.TGBeatImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuCheckableItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;
import org.herac.tuxguitar.util.TGNoteRange;

public class BeatMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem noteMenuItem;
    private UIMenuActionItem insertRestBeat;
    private UIMenuActionItem deleteNoteOrRest;
    private UIMenuActionItem cleanBeat;
    private UIMenuActionItem removeVoice;
    private UIMenuActionItem insertText;
    private UIMenuActionItem voiceAuto;
    private UIMenuActionItem voiceUp;
    private UIMenuActionItem voiceDown;
    private UIMenuCheckableItem strokeUp;
    private UIMenuCheckableItem strokeDown;
    private UIMenuActionItem shiftUp;
    private UIMenuActionItem shiftDown;
    private UIMenuActionItem semitoneUp;
    private UIMenuActionItem semitoneDown;
    private UIMenuActionItem moveBeatsLeft;
    private UIMenuActionItem moveBeatsRight;
    private UIMenuActionItem moveBeatsCustom;
    private DurationMenuItem durationMenuItem;
    private DynamicMenuItem dynamicMenuItem;
    private NoteEffectsMenuItem effectMenuItem;
    private ChordMenuItem chordMenuItem;

    public BeatMenuItem(UIMenu parent) {
        this.noteMenuItem = parent.createSubMenuItem();
    }

    @Override
    public void showItems() {
        this.insertRestBeat = this.noteMenuItem.getMenu().createActionItem();
        this.insertRestBeat.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.insert-rest"));
        this.deleteNoteOrRest = this.noteMenuItem.getMenu().createActionItem();
        this.deleteNoteOrRest.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.delete-note-or-rest"));
        this.cleanBeat = this.noteMenuItem.getMenu().createActionItem();
        this.cleanBeat.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.clean-beat"));
        this.noteMenuItem.getMenu().createSeparator();
        this.removeVoice = this.noteMenuItem.getMenu().createActionItem();
        this.removeVoice.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.remove-unused-voice"));
        this.noteMenuItem.getMenu().createSeparator();
        this.durationMenuItem = new DurationMenuItem(this.noteMenuItem.getMenu().createSubMenuItem());
        this.durationMenuItem.showItems();
        this.dynamicMenuItem = new DynamicMenuItem(this.noteMenuItem.getMenu().createSubMenuItem());
        this.dynamicMenuItem.showItems();
        this.effectMenuItem = new NoteEffectsMenuItem(this.noteMenuItem.getMenu().createSubMenuItem());
        this.effectMenuItem.showItems();
        this.chordMenuItem = new ChordMenuItem(this.noteMenuItem.getMenu().createSubMenuItem());
        this.chordMenuItem.showItems();
        this.noteMenuItem.getMenu().createSeparator();
        this.insertText = this.noteMenuItem.getMenu().createActionItem();
        this.insertText.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-text-dialog"));
        this.noteMenuItem.getMenu().createSeparator();
        this.voiceAuto = this.noteMenuItem.getMenu().createActionItem();
        this.voiceAuto.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.voice-auto"));
        this.voiceUp = this.noteMenuItem.getMenu().createActionItem();
        this.voiceUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.voice-up"));
        this.voiceDown = this.noteMenuItem.getMenu().createActionItem();
        this.voiceDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.voice-down"));
        this.noteMenuItem.getMenu().createSeparator();
        this.strokeUp = this.noteMenuItem.getMenu().createCheckItem();
        this.strokeUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-stroke-up-dialog"));
        this.strokeDown = this.noteMenuItem.getMenu().createCheckItem();
        this.strokeDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-stroke-down-dialog"));
        this.noteMenuItem.getMenu().createSeparator();
        this.semitoneUp = this.noteMenuItem.getMenu().createActionItem();
        this.semitoneUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.increment-semitone"));
        this.semitoneDown = this.noteMenuItem.getMenu().createActionItem();
        this.semitoneDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.decrement-semitone"));
        this.noteMenuItem.getMenu().createSeparator();
        this.shiftUp = this.noteMenuItem.getMenu().createActionItem();
        this.shiftUp.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.shift-up"));
        this.shiftDown = this.noteMenuItem.getMenu().createActionItem();
        this.shiftDown.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.general.shift-down"));
        this.noteMenuItem.getMenu().createSeparator();
        this.moveBeatsLeft = this.noteMenuItem.getMenu().createActionItem();
        this.moveBeatsLeft.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.move-left"));
        this.moveBeatsRight = this.noteMenuItem.getMenu().createActionItem();
        this.moveBeatsRight.addSelectionListener((UISelectionListener)this.createActionProcessor("action.beat.general.move-right"));
        this.moveBeatsCustom = this.noteMenuItem.getMenu().createActionItem();
        this.moveBeatsCustom.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-beat-move-dialog"));
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void update() {
        Tablature tablature = TuxGuitar.getInstance().getTablatureEditor().getTablature();
        Caret caret = tablature.getCaret();
        TGBeatImpl beat = caret.getSelectedBeat();
        TGNote note = caret.getSelectedNote();
        boolean restBeat = caret.isRestBeatSelected();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        TGTrackImpl track = caret.getTrack();
        TGNoteRange noteRange = tablature.getCurrentNoteRange();
        boolean atLeastOneNoteSelected = note != null || noteRange != null && !noteRange.isEmpty();
        this.insertRestBeat.setEnabled(!running);
        this.deleteNoteOrRest.setEnabled(!running);
        this.cleanBeat.setEnabled(!running);
        this.removeVoice.setEnabled(!running);
        this.voiceAuto.setEnabled(!running && !restBeat);
        this.voiceUp.setEnabled(!running && !restBeat);
        this.voiceDown.setEnabled(!running && !restBeat);
        this.strokeUp.setEnabled(!running && !restBeat && !track.isPercussion());
        this.strokeUp.setChecked(beat != null && beat.getStroke().getDirection() == 1);
        this.strokeDown.setEnabled(!running && !restBeat && !track.isPercussion());
        this.strokeDown.setChecked(beat != null && beat.getStroke().getDirection() == -1);
        this.semitoneUp.setEnabled(!running && atLeastOneNoteSelected);
        this.semitoneDown.setEnabled(!running && atLeastOneNoteSelected);
        this.shiftUp.setEnabled(!running && atLeastOneNoteSelected);
        this.shiftDown.setEnabled(!running && atLeastOneNoteSelected);
        this.insertText.setEnabled(!running);
        this.moveBeatsLeft.setEnabled(!running);
        this.moveBeatsRight.setEnabled(!running);
        this.moveBeatsCustom.setEnabled(!running);
        this.durationMenuItem.update();
        this.effectMenuItem.update();
        if (track.isPercussion()) {
            this.chordMenuItem.setEnabled(false);
        } else {
            this.chordMenuItem.setEnabled(true);
            this.chordMenuItem.update();
        }
        this.dynamicMenuItem.update();
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.noteMenuItem, "beat", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.cleanBeat, "beat.clean", "action.note.general.clean-beat");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.removeVoice, "beat.voice.remove-unused", "action.beat.general.remove-unused-voice");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.insertRestBeat, "beat.insert-rest", "action.beat.general.insert-rest");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.deleteNoteOrRest, "beat.delete-note-or-rest", "action.beat.general.delete-note-or-rest");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.voiceAuto, "beat.voice-auto", "action.beat.general.voice-auto");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.voiceUp, "beat.voice-up", "action.beat.general.voice-up");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.voiceDown, "beat.voice-down", "action.beat.general.voice-down");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.strokeUp, "beat.stroke-up", "action.gui.open-stroke-up-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.strokeDown, "beat.stroke-down", "action.gui.open-stroke-down-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.semitoneUp, "note.semitone-up", "action.note.general.increment-semitone");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.semitoneDown, "note.semitone-down", "action.note.general.decrement-semitone");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.shiftUp, "note.shift-up", "action.note.general.shift-up");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.shiftDown, "note.shift-down", "action.note.general.shift-down");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.insertText, "text.insert", "action.gui.open-text-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.moveBeatsLeft, "beat.move-left", "action.beat.general.move-left");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.moveBeatsRight, "beat.move-right", "action.beat.general.move-right");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.moveBeatsCustom, "beat.move-custom", "action.gui.open-beat-move-dialog");
        this.durationMenuItem.loadProperties();
        this.chordMenuItem.loadProperties();
        this.effectMenuItem.loadProperties();
        this.dynamicMenuItem.loadProperties();
    }

    public void loadIcons() {
        this.insertText.setImage(TuxGuitar.getInstance().getIconManager().getText());
        this.strokeUp.setImage(TuxGuitar.getInstance().getIconManager().getStrokeUp());
        this.strokeDown.setImage(TuxGuitar.getInstance().getIconManager().getStrokeDown());
    }
}

