/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.main;

import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.table.TGTableViewer;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.main.TGWindowLayout;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIMouseDragListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.resource.UICursor;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDivider;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.util.TGContext;

public class TGWindowDivider
implements UIMouseDragListener {
    private TGContext context;
    private UIDivider divider;

    public TGWindowDivider(TGContext context) {
        this.context = context;
    }

    public void createDivider(UIContainer parent) {
        UIFactory uiFactory = TGApplication.getInstance(this.context).getFactory();
        this.divider = uiFactory.createHorizontalDivider(parent);
        this.divider.addMouseDragListener((UIMouseDragListener)this);
        this.divider.setCursor(UICursor.SIZENS);
    }

    public void onMouseDrag(UIMouseEvent event) {
        UIPanel control = TGTableViewer.getInstance(this.context).getControl();
        TGWindow tgWindow = TGWindow.getInstance(this.context);
        TGWindowLayout tgWindowLayout = (TGWindowLayout)tgWindow.getWindow().getLayout();
        tgWindowLayout.set((UIControl)control, "packed_height", this.computeHeight((UIControl)control, event.getPosition().getY()));
        tgWindow.getWindow().layout();
    }

    public Float computeHeight(UIControl control, float move) {
        return Float.valueOf(Math.max(control.getBounds().getHeight() - move, 0.0f));
    }

    public void setVisible(boolean visible) {
        this.divider.setVisible(visible);
    }

    public UIDivider getControl() {
        return this.divider;
    }
}

