/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.transpose;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIRadioButton;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UIWindow;

public class TGTransposeDialog {
    private static final int TRANSPOSITION_SEMITONES = 12;

    public void show(final TGViewContext context) {
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("tools.transpose"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("tools.transpose"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel transpositionLabel = uiFactory.createLabel((UIContainer)group);
        transpositionLabel.setText(TuxGuitar.getProperty("tools.transpose.semitones") + ":");
        groupLayout.set((UIControl)transpositionLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect transpositionCombo = uiFactory.createDropDownSelect((UIContainer)group);
        for (int i = -12; i <= 12; ++i) {
            transpositionCombo.addItem(new UISelectItem(Integer.toString(i), (Object)i));
        }
        transpositionCombo.setSelectedValue((Object)0);
        groupLayout.set((UIControl)transpositionCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout optionsLayout = new UITableLayout();
        UILegendPanel options = uiFactory.createLegendPanel((UIContainer)dialog);
        options.setLayout((UILayout)optionsLayout);
        options.setText(TuxGuitar.getProperty("options"));
        dialogLayout.set((UIControl)options, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIRadioButton applyToAllMeasuresButton = uiFactory.createRadioButton((UIContainer)options);
        applyToAllMeasuresButton.setText(TuxGuitar.getProperty("tools.transpose.apply-to-track"));
        applyToAllMeasuresButton.setSelected(true);
        optionsLayout.set((UIControl)applyToAllMeasuresButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIRadioButton applyToCurrentMeasureButton = uiFactory.createRadioButton((UIContainer)options);
        applyToCurrentMeasureButton.setText(TuxGuitar.getProperty("tools.transpose.apply-to-measure"));
        optionsLayout.set((UIControl)applyToCurrentMeasureButton, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox applyToAllTracksButton = uiFactory.createCheckBox((UIContainer)options);
        applyToAllTracksButton.setText(TuxGuitar.getProperty("tools.transpose.apply-to-all-tracks"));
        applyToAllTracksButton.setSelected(true);
        optionsLayout.set((UIControl)applyToAllTracksButton, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox applyToChordsButton = uiFactory.createCheckBox((UIContainer)options);
        applyToChordsButton.setText(TuxGuitar.getProperty("tools.transpose.apply-to-chords"));
        applyToChordsButton.setSelected(true);
        optionsLayout.set((UIControl)applyToChordsButton, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox tryKeepStringButton = uiFactory.createCheckBox((UIContainer)options);
        tryKeepStringButton.setText(TuxGuitar.getProperty("tools.transpose.try-keep-strings"));
        tryKeepStringButton.setSelected(true);
        optionsLayout.set((UIControl)tryKeepStringButton, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGTransposeDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                Integer transposition = (Integer)transpositionCombo.getSelectedValue();
                if (transposition != null) {
                    boolean tryKeepString = tryKeepStringButton.isSelected();
                    boolean applyToChords = applyToChordsButton.isSelected();
                    boolean applyToAllTracks = applyToAllTracksButton.isSelected();
                    boolean applyToAllMeasures = applyToAllMeasuresButton.isSelected();
                    this.this$0.transposeNotes(context, transposition, tryKeepString, applyToChords, applyToAllMeasures, applyToAllTracks);
                }
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGTransposeDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public void transposeNotes(TGViewContext context, int transposition, boolean tryKeepString, boolean applyToChords, boolean applyToAllMeasures, boolean applyToAllTracks) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context.getContext(), "action.tools.transpose-notes");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG));
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK));
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE));
        tgActionProcessor.setAttribute("transposition", (Object)transposition);
        tgActionProcessor.setAttribute("tryKeepString", (Object)tryKeepString);
        tgActionProcessor.setAttribute("applyToChords", (Object)applyToChords);
        tgActionProcessor.setAttribute("applyToAllTracks", (Object)applyToAllTracks);
        tgActionProcessor.setAttribute("applyToAllMeasures", (Object)applyToAllMeasures);
        tgActionProcessor.processOnNewThread();
    }
}

