/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.track;

import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.util.TGProcess;
import org.herac.tuxguitar.editor.util.TGSyncProcessLocked;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.chooser.UIColorChooser;
import org.herac.tuxguitar.ui.chooser.UIColorChooserHandler;
import org.herac.tuxguitar.ui.event.UICloseEvent;
import org.herac.tuxguitar.ui.event.UICloseListener;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIFocusEvent;
import org.herac.tuxguitar.ui.event.UIFocusLostListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIColorModel;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIReadOnlyTextField;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UITextField;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGMusicKeyUtils;

public class TGTrackPropertiesDialog
implements TGEventListener {
    private static final float MINIMUM_LEFT_CONTROLS_WIDTH = 180.0f;
    private static final float MINIMUM_BUTTON_WIDTH = 80.0f;
    private static final float MINIMUM_BUTTON_HEIGHT = 25.0f;
    private TGViewContext context;
    private UIWindow dialog;
    private UITextField nameText;
    private UIButton colorButton;
    private UIColor colorButtonBg;
    private UIDropDownSelect<Integer> channelSelect;
    private UIReadOnlyTextField tuningText;
    private TGProcess updateItemsProcess;

    public TGTrackPropertiesDialog(TGViewContext context) {
        this.context = context;
        this.createSyncProcesses();
    }

    public void show() {
        TGTrack track = this.findTrack();
        UIFactory factory = this.getUIFactory();
        UIWindow parent = (UIWindow)this.context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = factory.createWindow(parent, true, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty("track.properties"));
        this.initTrackInfo(track);
        this.initButtons();
        this.initListeners();
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    private void initListeners() {
        this.addListeners();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGTrackPropertiesDialog.this.removeListeners();
            }
        });
        this.dialog.addCloseListener(new UICloseListener(){

            public void onClose(UICloseEvent event) {
                TGTrackPropertiesDialog.this.updateTrackName();
                TGTrackPropertiesDialog.this.dialog.dispose();
            }
        });
    }

    private void initTrackInfo(TGTrack track) {
        final UIFactory factory = this.getUIFactory();
        UITableLayout dialogLayout = (UITableLayout)this.dialog.getLayout();
        UITableLayout legendLayout = new UITableLayout();
        UILegendPanel legendPanel = factory.createLegendPanel((UIContainer)this.dialog);
        legendPanel.setLayout((UILayout)legendLayout);
        legendPanel.setText(TuxGuitar.getProperty("track.properties.general"));
        dialogLayout.set((UIControl)legendPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel nameLabel = factory.createLabel((UIContainer)legendPanel);
        nameLabel.setText(TuxGuitar.getProperty("track.name") + ":");
        legendLayout.set((UIControl)nameLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.nameText = factory.createTextField((UIContainer)legendPanel);
        this.nameText.setText(track.getName());
        this.nameText.addFocusLostListener(new UIFocusLostListener(){

            public void onFocusLost(UIFocusEvent event) {
                TGTrackPropertiesDialog.this.updateTrackName();
            }
        });
        legendLayout.set((UIControl)this.nameText, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        UILabel colorLabel = factory.createLabel((UIContainer)legendPanel);
        colorLabel.setText(TuxGuitar.getProperty("track.color") + ":");
        legendLayout.set((UIControl)colorLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.colorButton = factory.createButton((UIContainer)legendPanel);
        this.colorButton.setText(TuxGuitar.getProperty("choose"));
        this.colorButton.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGTrackPropertiesDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                TGColor tgColor = this.this$0.findTrack().getColor();
                UIColorModel colorModel = new UIColorModel();
                colorModel.setRed(tgColor.getR());
                colorModel.setGreen(tgColor.getG());
                colorModel.setBlue(tgColor.getB());
                UIColorChooser colorChooser = factory.createColorChooser(this.this$0.dialog);
                colorChooser.setDefaultModel(colorModel);
                colorChooser.setText(TuxGuitar.getProperty("choose-color"));
                colorChooser.choose(new UIColorChooserHandler(){

                    public void onSelectColor(UIColorModel selection) {
                        if (selection != null) {
                            this$0.updateTrackColor(selection);
                        }
                    }
                });
            }
        });
        this.colorButton.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGTrackPropertiesDialog.this.disposeColorButtonBackground();
            }
        });
        legendLayout.set((UIControl)this.colorButton, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        UILabel instrumentLabel = factory.createLabel((UIContainer)legendPanel);
        instrumentLabel.setText(TuxGuitar.getProperty("instrument") + ":");
        legendLayout.set((UIControl)instrumentLabel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.channelSelect = factory.createDropDownSelect((UIContainer)legendPanel);
        this.channelSelect.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackPropertiesDialog.this.updateTrackChannel();
            }
        });
        this.updateChannelSelect();
        legendLayout.set(this.channelSelect, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UIButton settings = factory.createButton((UIContainer)legendPanel);
        settings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        settings.setToolTipText(TuxGuitar.getProperty("settings"));
        settings.addSelectionListener((UISelectionListener)this.createOpenViewAction("action.gui.toggle-channels-dialog"));
        legendLayout.set((UIControl)settings, Integer.valueOf(3), Integer.valueOf(3), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UILabel tuningLabel = factory.createLabel((UIContainer)legendPanel);
        tuningLabel.setText(TuxGuitar.getProperty("tuning") + ":");
        legendLayout.set((UIControl)tuningLabel, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.tuningText = factory.createReadOnlyTextField((UIContainer)legendPanel);
        legendLayout.set((UIControl)this.tuningText, Integer.valueOf(4), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UIButton tuningSettings = factory.createButton((UIContainer)legendPanel);
        tuningSettings.setImage(TuxGuitar.getInstance().getIconManager().getSettings());
        tuningSettings.setToolTipText(TuxGuitar.getProperty("settings"));
        tuningSettings.addSelectionListener((UISelectionListener)this.createOpenViewAction("action.gui.open-track-tuning-dialog"));
        legendLayout.set((UIControl)tuningSettings, Integer.valueOf(4), Integer.valueOf(3), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
    }

    public TGActionProcessorListener createOpenViewAction(String actionId) {
        TGActionProcessorListener tgActionProcessor = new TGActionProcessorListener(this.context.getContext(), actionId);
        tgActionProcessor.setAttribute("parent", this.dialog);
        return tgActionProcessor;
    }

    private void initButtons() {
        UIFactory factory = this.getUIFactory();
        UITableLayout dialogLayout = (UITableLayout)this.dialog.getLayout();
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = factory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonClose = factory.createButton((UIContainer)buttons);
        buttonClose.setText(TuxGuitar.getProperty("close"));
        buttonClose.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTrackPropertiesDialog.this.updateTrackName();
                TGTrackPropertiesDialog.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonClose, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonClose, "margin_right", (Object)Float.valueOf(0.0f));
    }

    public void updateItems() {
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.updateChannelSelect();
            this.updateTuningText();
            this.updateColorButton();
        }
    }

    private void updateColorButton() {
        TGColor tgColor = this.findTrack().getColor();
        this.colorButton.setFgColor(null);
        this.disposeColorButtonBackground();
        this.colorButtonBg = this.getUIFactory().createColor(tgColor.getR(), tgColor.getG(), tgColor.getB());
        this.colorButton.setFgColor(this.colorButtonBg);
    }

    private void disposeColorButtonBackground() {
        if (this.colorButtonBg != null && !this.colorButtonBg.isDisposed()) {
            this.colorButtonBg.dispose();
            this.colorButtonBg = null;
        }
    }

    private void updateTuningText() {
        StringBuilder label = new StringBuilder();
        boolean isValid = true;
        List tuning = this.findTrack().getStrings();
        for (int i = 0; i < tuning.size(); ++i) {
            String noteName;
            if (i > 0) {
                label.append(" ");
            }
            isValid &= (noteName = TGMusicKeyUtils.sharpNoteName((int)((TGString)tuning.get(tuning.size() - i - 1)).getValue())) != null;
            label.append(noteName);
        }
        boolean enabled = !this.isPercussionChannel();
        this.tuningText.setText(enabled && isValid ? label.toString() : "");
        this.tuningText.setEnabled(enabled);
    }

    private void updateChannelSelect() {
        this.channelSelect.setIgnoreEvents(true);
        this.channelSelect.removeItems();
        this.channelSelect.addItem(new UISelectItem(TuxGuitar.getProperty("track.instrument.default-select-option"), null));
        List channels = this.findSongManager().getChannels(this.findSong());
        for (TGChannel channel : channels) {
            this.channelSelect.addItem(new UISelectItem(channel.getName(), (Object)channel.getChannelId()));
        }
        this.channelSelect.setSelectedValue((Object)this.findTrack().getChannelId());
        this.channelSelect.setIgnoreEvents(false);
    }

    private int getSelectedChannelId() {
        Integer selectedValue = (Integer)this.channelSelect.getSelectedValue();
        return selectedValue != null ? selectedValue : -1;
    }

    private void updateTrackName() {
        this.updateTrackInfo(this.nameText.getText(), this.findTrack().getColor());
    }

    private void updateTrackColor(UIColorModel selection) {
        TGColor tgColor = this.findSongManager().getFactory().newColor();
        tgColor.setR(selection.getRed());
        tgColor.setG(selection.getGreen());
        tgColor.setB(selection.getBlue());
        this.updateTrackInfo(this.findTrack().getName(), tgColor);
    }

    private void updateTrackInfo(String name, TGColor color) {
        TGSong song = this.findSong();
        TGTrack track = this.findTrack();
        if (this.hasInfoChanges(name, color)) {
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.track.set-info");
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
            tgActionProcessor.setAttribute("name", (Object)name);
            tgActionProcessor.setAttribute("color", (Object)color);
            tgActionProcessor.setAttribute("offset", (Object)track.getOffset());
            tgActionProcessor.process();
        }
    }

    private void updateTrackChannel() {
        TGSong song = this.findSong();
        TGTrack track = this.findTrack();
        Integer channelId = this.getSelectedChannelId();
        if (this.hasChannelChanges(channelId)) {
            TGChannel channel = this.findSongManager().getChannel(song, channelId.intValue());
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.track.set-channel");
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL, (Object)channel);
            tgActionProcessor.process();
        }
    }

    private boolean hasInfoChanges(String name, TGColor color) {
        TGTrack track = this.findTrack();
        if (!name.equals(track.getName())) {
            return true;
        }
        return !color.isEqual(track.getColor());
    }

    private boolean hasChannelChanges(int channelId) {
        return this.findTrack().getChannelId() != channelId;
    }

    private boolean isPercussionChannel() {
        return this.findSongManager().isPercussionChannel(this.findSong(), this.findTrack().getChannelId());
    }

    public void addListeners() {
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    public TGSongManager findSongManager() {
        return (TGSongManager)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
    }

    public TGSong findSong() {
        return (TGSong)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
    }

    public TGTrack findTrack() {
        return (TGTrack)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context.getContext()).getFactory();
    }

    public void createSyncProcesses() {
        this.updateItemsProcess = new TGSyncProcessLocked(this.context.getContext(), new Runnable(){

            @Override
            public void run() {
                TGTrackPropertiesDialog.this.updateItems();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItemsProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }
}

