/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.settings.items;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import org.herac.tuxguitar.app.view.dialog.settings.items.TGSettingsOption;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.chooser.UIColorChooser;
import org.herac.tuxguitar.ui.chooser.UIColorChooserHandler;
import org.herac.tuxguitar.ui.chooser.UIFontChooser;
import org.herac.tuxguitar.ui.chooser.UIFontChooserHandler;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIColorModel;
import org.herac.tuxguitar.ui.resource.UIFontModel;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class StylesOption
extends TGSettingsOption {
    private static final float BUTTON_WIDTH = 200.0f;
    private boolean initialized = false;
    private UIFontModel defaultFontData = new UIFontModel();
    private UIFontModel noteFontData = new UIFontModel();
    private UIFontModel textFontData = new UIFontModel();
    private UIFontModel markerFontData = new UIFontModel();
    private UIFontModel lyricFontData = new UIFontModel();
    private UIFontModel printerDefaultFontData = new UIFontModel();
    private UIFontModel printerNoteFontData = new UIFontModel();
    private UIFontModel printerTextFontData = new UIFontModel();
    private UIFontModel printerLyricFontData = new UIFontModel();
    private UIButton defaultFontButton;
    private UIButton noteFontButton;
    private UIButton textFontButton;
    private UIButton markerFontButton;
    private UIButton lyricFontButton;
    private UIButton printerDefaultFontButton;
    private UIButton printerNoteFontButton;
    private UIButton printerTextFontButton;
    private UIButton printerLyricFontButton;
    private UIColorButton scoreNoteColorButton;
    private UIColorButton tabNoteColorButton;
    private UIColorButton playNoteColorButton;
    private UIColorButton playMeasureColorButton;
    private UIColorButton selectionColorButton;
    private UIColorButton linesColorButton;

    public StylesOption(TGSettingsEditor configEditor, UIToolBar toolBar, UILayoutContainer parent) {
        super(configEditor, toolBar, parent, TuxGuitar.getProperty("settings.config.styles"));
    }

    @Override
    public void createOption() {
        UIFactory uiFactory = this.getUIFactory();
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.styles"));
        this.getToolItem().setImage(TuxGuitar.getInstance().getIconManager().getOptionStyle());
        this.getToolItem().addSelectionListener((UISelectionListener)this);
        this.showLabel((UILayoutContainer)this.getPanel(), TuxGuitar.getProperty("settings.config.styles.general"), true, 1, 1);
        UIPanel mainSection = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        mainSection.setLayout((UILayout)new UITableLayout());
        this.indent((UIControl)mainSection, 2, 1);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.font.default") + ":", false, 1, 1);
        this.defaultFontButton = this.createFontButton((UILayoutContainer)mainSection, this.defaultFontData, 1, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.font.note") + ":", false, 2, 1);
        this.noteFontButton = this.createFontButton((UILayoutContainer)mainSection, this.noteFontData, 2, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.font.lyric") + ":", false, 3, 1);
        this.lyricFontButton = this.createFontButton((UILayoutContainer)mainSection, this.lyricFontData, 3, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.font.text") + ":", false, 4, 1);
        this.textFontButton = this.createFontButton((UILayoutContainer)mainSection, this.textFontData, 4, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.font.marker") + ":", false, 5, 1);
        this.markerFontButton = this.createFontButton((UILayoutContainer)mainSection, this.markerFontData, 5, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.color.score-note") + ":", false, 6, 1);
        this.scoreNoteColorButton = this.createColorButton((UILayoutContainer)mainSection, TuxGuitar.getProperty("choose"), 6, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.color.tab-note") + ":", false, 7, 1);
        this.tabNoteColorButton = this.createColorButton((UILayoutContainer)mainSection, TuxGuitar.getProperty("choose"), 7, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.color.play-note") + ":", false, 8, 1);
        this.playNoteColorButton = this.createColorButton((UILayoutContainer)mainSection, TuxGuitar.getProperty("choose"), 8, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.color.play-measure") + ":", false, 9, 1);
        this.playMeasureColorButton = this.createColorButton((UILayoutContainer)mainSection, TuxGuitar.getProperty("choose"), 9, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.color.selection") + ":", false, 10, 1);
        this.selectionColorButton = this.createColorButton((UILayoutContainer)mainSection, TuxGuitar.getProperty("choose"), 10, 2);
        this.showLabel((UILayoutContainer)mainSection, TuxGuitar.getProperty("settings.config.styles.color.lines") + ":", false, 11, 1);
        this.linesColorButton = this.createColorButton((UILayoutContainer)mainSection, TuxGuitar.getProperty("choose"), 11, 2);
        this.showLabel((UILayoutContainer)this.getPanel(), TuxGuitar.getProperty("settings.config.styles.printer"), true, 3, 1);
        UIPanel printerSection = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        printerSection.setLayout((UILayout)new UITableLayout());
        this.indent((UIControl)printerSection, 4, 1);
        this.showLabel((UILayoutContainer)printerSection, TuxGuitar.getProperty("settings.config.styles.font.default") + ":", false, 1, 1);
        this.printerDefaultFontButton = this.createFontButton((UILayoutContainer)printerSection, this.printerDefaultFontData, 1, 2);
        this.showLabel((UILayoutContainer)printerSection, TuxGuitar.getProperty("settings.config.styles.font.note") + ":", false, 2, 1);
        this.printerNoteFontButton = this.createFontButton((UILayoutContainer)printerSection, this.printerNoteFontData, 2, 2);
        this.showLabel((UILayoutContainer)printerSection, TuxGuitar.getProperty("settings.config.styles.font.lyric") + ":", false, 3, 1);
        this.printerLyricFontButton = this.createFontButton((UILayoutContainer)printerSection, this.printerLyricFontData, 3, 2);
        this.showLabel((UILayoutContainer)printerSection, TuxGuitar.getProperty("settings.config.styles.font.text") + ":", false, 4, 1);
        this.printerTextFontButton = this.createFontButton((UILayoutContainer)printerSection, this.printerTextFontData, 4, 2);
        this.loadConfig();
    }

    public UIColorButton createColorButton(UILayoutContainer parent, String text, int row, int col) {
        UIColorButton button = new UIColorButton(this.getWindow(), (UIContainer)parent, text);
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set(button.getControl(), Integer.valueOf(row), Integer.valueOf(col), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(200.0f), null, null);
        return button;
    }

    public UIButton createFontButton(UILayoutContainer parent, UIFontModel fontModel, int row, int col) {
        UIButton uiButton = this.getUIFactory().createButton((UIContainer)parent);
        uiButton.setText("-");
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set((UIControl)uiButton, Integer.valueOf(row), Integer.valueOf(col), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(200.0f), null, null);
        this.addFontButtonListeners(uiButton, fontModel);
        return uiButton;
    }

    private void addFontButtonListeners(final UIButton button, final UIFontModel fontModel) {
        button.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ StylesOption this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                if (this.this$0.initialized) {
                    UIFontModel defaultModel = new UIFontModel();
                    this.this$0.copyFontData(fontModel, defaultModel);
                    UIFontChooser uiFontChooser = this.this$0.getUIFactory().createFontChooser(this.this$0.getWindow());
                    uiFontChooser.setDefaultModel(defaultModel);
                    uiFontChooser.choose(new UIFontChooserHandler(){

                        public void onSelectFont(UIFontModel selection) {
                            if (selection != null) {
                                this$0.loadFontData(selection, fontModel, button);
                            }
                        }
                    });
                }
            }
        });
    }

    protected void loadFontData(UIFontModel src, UIFontModel dst, UIButton button) {
        this.copyFontData(src, dst);
        this.setButtonFontData(button, dst);
    }

    protected void loadColor(UIColorButton button, UIColorModel rgb) {
        button.loadColor(rgb);
    }

    protected void setButtonFontData(UIButton button, UIFontModel fontModel) {
        Object text = fontModel.getName();
        if (fontModel.isBold()) {
            text = (String)text + " Bold";
        }
        if (fontModel.isItalic()) {
            text = (String)text + " Italic";
        }
        text = (String)text + " " + fontModel.getHeight();
        button.setText((String)text);
    }

    protected void copyFontData(UIFontModel src, UIFontModel dst) {
        dst.setName(src.getName());
        dst.setHeight(src.getHeight());
        dst.setBold(src.isBold());
        dst.setItalic(src.isItalic());
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                final UIFontModel defaultFontData = StylesOption.this.getConfig().getFontModelConfigValue("font.default");
                final UIFontModel noteFontData = StylesOption.this.getConfig().getFontModelConfigValue("font.note");
                final UIFontModel textFontData = StylesOption.this.getConfig().getFontModelConfigValue("font.text");
                final UIFontModel markerFontData = StylesOption.this.getConfig().getFontModelConfigValue("font.marker");
                final UIFontModel lyricFontData = StylesOption.this.getConfig().getFontModelConfigValue("font.lyric");
                final UIFontModel printerDefaultFontData = StylesOption.this.getConfig().getFontModelConfigValue("font.printer.default");
                final UIFontModel printerNoteFontData = StylesOption.this.getConfig().getFontModelConfigValue("font.printer.note");
                final UIFontModel printerTextFontData = StylesOption.this.getConfig().getFontModelConfigValue("font.printer.text");
                final UIFontModel printerLyricFontData = StylesOption.this.getConfig().getFontModelConfigValue("font.printer.lyric");
                final UIColorModel scoreNoteRGB = StylesOption.this.getConfig().getColorModelConfigValue("color.score.note");
                final UIColorModel tabNoteRGB = StylesOption.this.getConfig().getColorModelConfigValue("color.tab.note");
                final UIColorModel playNoteRGB = StylesOption.this.getConfig().getColorModelConfigValue("color.play.note");
                final UIColorModel playMeasureRGB = StylesOption.this.getConfig().getColorModelConfigValue("color.background.playing");
                final UIColorModel selectionRGB = StylesOption.this.getConfig().getColorModelConfigValue("color.selection");
                final UIColorModel linesRGB = StylesOption.this.getConfig().getColorModelConfigValue("color.line");
                TGSynchronizer.getInstance((TGContext)StylesOption.this.getViewContext().getContext()).executeLater(new Runnable(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        if (!this.this$1.StylesOption.this.isDisposed()) {
                            this.this$1.StylesOption.this.loadFontData(defaultFontData, this.this$1.StylesOption.this.defaultFontData, this.this$1.StylesOption.this.defaultFontButton);
                            this.this$1.StylesOption.this.loadFontData(noteFontData, this.this$1.StylesOption.this.noteFontData, this.this$1.StylesOption.this.noteFontButton);
                            this.this$1.StylesOption.this.loadFontData(textFontData, this.this$1.StylesOption.this.textFontData, this.this$1.StylesOption.this.textFontButton);
                            this.this$1.StylesOption.this.loadFontData(markerFontData, this.this$1.StylesOption.this.markerFontData, this.this$1.StylesOption.this.markerFontButton);
                            this.this$1.StylesOption.this.loadFontData(lyricFontData, this.this$1.StylesOption.this.lyricFontData, this.this$1.StylesOption.this.lyricFontButton);
                            this.this$1.StylesOption.this.loadFontData(printerDefaultFontData, this.this$1.StylesOption.this.printerDefaultFontData, this.this$1.StylesOption.this.printerDefaultFontButton);
                            this.this$1.StylesOption.this.loadFontData(printerNoteFontData, this.this$1.StylesOption.this.printerNoteFontData, this.this$1.StylesOption.this.printerNoteFontButton);
                            this.this$1.StylesOption.this.loadFontData(printerTextFontData, this.this$1.StylesOption.this.printerTextFontData, this.this$1.StylesOption.this.printerTextFontButton);
                            this.this$1.StylesOption.this.loadFontData(printerLyricFontData, this.this$1.StylesOption.this.printerLyricFontData, this.this$1.StylesOption.this.printerLyricFontButton);
                            this.this$1.StylesOption.this.scoreNoteColorButton.loadColor(scoreNoteRGB);
                            this.this$1.StylesOption.this.tabNoteColorButton.loadColor(tabNoteRGB);
                            this.this$1.StylesOption.this.playNoteColorButton.loadColor(playNoteRGB);
                            this.this$1.StylesOption.this.playMeasureColorButton.loadColor(playMeasureRGB);
                            this.this$1.StylesOption.this.selectionColorButton.loadColor(selectionRGB);
                            this.this$1.StylesOption.this.linesColorButton.loadColor(linesRGB);
                            this.this$1.StylesOption.this.initialized = true;
                            this.this$1.StylesOption.this.pack();
                        }
                    }
                });
            }
        }).start();
    }

    @Override
    public void updateConfig() {
        if (this.initialized) {
            this.getConfig().setValue("font.default", this.defaultFontData);
            this.getConfig().setValue("font.note", this.noteFontData);
            this.getConfig().setValue("font.text", this.textFontData);
            this.getConfig().setValue("font.marker", this.markerFontData);
            this.getConfig().setValue("font.lyric", this.lyricFontData);
            this.getConfig().setValue("font.printer.default", this.printerDefaultFontData);
            this.getConfig().setValue("font.printer.note", this.printerNoteFontData);
            this.getConfig().setValue("font.printer.text", this.printerTextFontData);
            this.getConfig().setValue("font.printer.lyric", this.printerLyricFontData);
            this.getConfig().setValue("color.score.note", this.scoreNoteColorButton.getValue());
            this.getConfig().setValue("color.tab.note", this.tabNoteColorButton.getValue());
            this.getConfig().setValue("color.play.note", this.playNoteColorButton.getValue());
            this.getConfig().setValue("color.background.playing", this.playMeasureColorButton.getValue());
            this.getConfig().setValue("color.selection", this.selectionColorButton.getValue());
            this.getConfig().setValue("color.line", this.linesColorButton.getValue());
        }
    }

    @Override
    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setValue("font.default", this.getDefaults().getValue("font.default"));
            this.getConfig().setValue("font.note", this.getDefaults().getValue("font.note"));
            this.getConfig().setValue("font.text", this.getDefaults().getValue("font.text"));
            this.getConfig().setValue("font.marker", this.getDefaults().getValue("font.marker"));
            this.getConfig().setValue("font.lyric", this.getDefaults().getValue("font.lyric"));
            this.getConfig().setValue("font.printer.default", this.getDefaults().getValue("font.printer.default"));
            this.getConfig().setValue("font.printer.note", this.getDefaults().getValue("font.printer.note"));
            this.getConfig().setValue("font.printer.text", this.getDefaults().getValue("font.printer.text"));
            this.getConfig().setValue("font.printer.lyric", this.getDefaults().getValue("font.printer.lyric"));
            this.getConfig().setValue("color.score.note", this.getDefaults().getValue("color.score.note"));
            this.getConfig().setValue("color.tab.note", this.getDefaults().getValue("color.tab.note"));
            this.getConfig().setValue("color.play.note", this.getDefaults().getValue("color.play.note"));
            this.getConfig().setValue("color.background.playing", this.getDefaults().getValue("color.background.playing"));
            this.getConfig().setValue("color.selection", this.getDefaults().getValue("color.selection"));
            this.getConfig().setValue("color.line", this.getDefaults().getValue("color.line"));
        }
    }

    private class UIColorButton {
        private UIWindow window;
        private UIButton button;
        private UIColor color;
        private UIColorModel value;

        public UIColorButton(UIWindow window, UIContainer parent, String text) {
            this.window = window;
            this.value = new UIColorModel();
            this.button = StylesOption.this.getUIFactory().createButton(parent);
            this.button.setText(text);
            this.addListeners();
        }

        public void loadColor(UIColorModel cm) {
            this.value.setRed(cm.getRed());
            this.value.setGreen(cm.getGreen());
            this.value.setBlue(cm.getBlue());
            UIColor color = StylesOption.this.getUIFactory().createColor(this.value);
            this.button.setFgColor(color);
            this.disposeColor();
            this.color = color;
        }

        public void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        public void addListeners() {
            this.button.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    UIColorChooser dlg = StylesOption.this.getUIFactory().createColorChooser(UIColorButton.this.window);
                    dlg.setDefaultModel(UIColorButton.this.value);
                    dlg.setText(TuxGuitar.getProperty("choose-color"));
                    dlg.choose(new UIColorChooserHandler(){

                        public void onSelectColor(UIColorModel model) {
                            if (model != null) {
                                UIColorButton.this.loadColor(model);
                            }
                        }
                    });
                }
            });
            this.button.addDisposeListener(new UIDisposeListener(){

                public void onDispose(UIDisposeEvent event) {
                    UIColorButton.this.disposeColor();
                }
            });
        }

        public UIControl getControl() {
            return this.button;
        }

        public UIColorModel getValue() {
            return this.value;
        }
    }
}

