/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.message;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIImageView;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.ui.widget.UIWrapLabel;
import org.herac.tuxguitar.util.TGContext;

public class TGMessageDialog {
    public static final String ATTRIBUTE_STYLE = "style";
    public static final String ATTRIBUTE_TITLE = "title";
    public static final String ATTRIBUTE_MESSAGE = "message";
    public static final Integer STYLE_INFO = 1;
    public static final Integer STYLE_WARNING = 2;
    public static final Integer STYLE_ERROR = 3;
    public static final Float WRAP_WIDTH = Float.valueOf(400.0f);

    public void show(TGViewContext context) {
        String title = (String)context.getAttribute(ATTRIBUTE_TITLE);
        String message = (String)context.getAttribute(ATTRIBUTE_MESSAGE);
        Integer style = (Integer)context.getAttribute(ATTRIBUTE_STYLE);
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(title);
        UITableLayout panelLayout = new UITableLayout();
        UIPanel uiPanel = uiFactory.createPanel((UIContainer)dialog, false);
        uiPanel.setLayout((UILayout)panelLayout);
        dialogLayout.set((UIControl)uiPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIImageView uiIcon = uiFactory.createImageView((UIContainer)uiPanel);
        uiIcon.setImage(this.resolveImage(context.getContext(), style));
        panelLayout.set((UIControl)uiIcon, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UIWrapLabel uiMessage = uiFactory.createWrapLabel((UIContainer)uiPanel);
        uiMessage.setText(message);
        panelLayout.set((UIControl)uiMessage, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        panelLayout.set((UIControl)uiMessage, "packed_width", (Object)WRAP_WIDTH);
        UITableLayout buttonsLayout = new UITableLayout();
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGMessageDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        TGDialogUtil.openDialog(dialog, 5);
    }

    public UIImage resolveImage(TGContext context, Integer style) {
        if (STYLE_ERROR.equals(style)) {
            return TGIconManager.getInstance(context).getStatusError();
        }
        if (STYLE_WARNING.equals(style)) {
            return TGIconManager.getInstance(context).getStatusWarning();
        }
        return TGIconManager.getInstance(context).getStatusInfo();
    }
}

