/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.matrix;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.config.TGConfigDefaults;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.dialog.matrix.TGMatrixEditor;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.chooser.UIColorChooser;
import org.herac.tuxguitar.ui.chooser.UIColorChooserHandler;
import org.herac.tuxguitar.ui.chooser.UIFontChooser;
import org.herac.tuxguitar.ui.chooser.UIFontChooserHandler;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIColorModel;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.resource.UIFontModel;
import org.herac.tuxguitar.ui.resource.UIResource;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.properties.TGProperties;

public class TGMatrixConfig {
    private static final float MINIMUM_CONTROL_WIDTH = 180.0f;
    private static final float MINIMUM_BUTTON_WIDTH = 80.0f;
    private static final float MINIMUM_BUTTON_HEIGHT = 25.0f;
    private TGContext context;
    private UIFont font;
    private UIColor[] colorLines;
    private UIColor colorForeground;
    private UIColor colorBorder;
    private UIColor colorPosition;
    private UIColor colorNote;
    private UIColor colorPlay;

    public TGMatrixConfig(TGContext context) {
        this.context = context;
    }

    public UIFont getFont() {
        return this.font;
    }

    public UIColor getColorForeground() {
        return this.colorForeground;
    }

    public UIColor getColorBorder() {
        return this.colorBorder;
    }

    public UIColor getColorPosition() {
        return this.colorPosition;
    }

    public UIColor getColorNote() {
        return this.colorNote;
    }

    public UIColor getColorPlay() {
        return this.colorPlay;
    }

    public UIColor[] getColorLines() {
        return this.colorLines;
    }

    public UIColor getColorLine(int index) {
        return this.colorLines[index];
    }

    public UIFont createFont(UIFactory factory, UIFontModel fm) {
        return TGApplication.getInstance(this.context).getFactory().createFont(fm.getName(), fm.getHeight(), fm.isBold(), fm.isItalic());
    }

    public UIColor createColor(UIFactory factory, UIColorModel cm) {
        return TGApplication.getInstance(this.context).getFactory().createColor(cm.getRed(), cm.getGreen(), cm.getBlue());
    }

    public void load() {
        UIFactory factory = TGApplication.getInstance(this.context).getFactory();
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        this.font = this.createFont(factory, config.getFontModelConfigValue("matrix.font"));
        this.colorForeground = this.createColor(factory, config.getColorModelConfigValue("matrix.color.foreground"));
        this.colorBorder = this.createColor(factory, config.getColorModelConfigValue("matrix.color.border"));
        this.colorPosition = this.createColor(factory, config.getColorModelConfigValue("matrix.color.position"));
        this.colorNote = this.createColor(factory, config.getColorModelConfigValue("matrix.color.note"));
        this.colorPlay = this.createColor(factory, config.getColorModelConfigValue("matrix.color.play-note"));
        this.colorLines = new UIColor[]{this.createColor(factory, config.getColorModelConfigValue("matrix.color.line-1")), this.createColor(factory, config.getColorModelConfigValue("matrix.color.line-2")), this.createColor(factory, config.getColorModelConfigValue("matrix.color.line-3"))};
    }

    public void defaults() {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        TGProperties defaults = TGConfigDefaults.createDefaults();
        config.setValue("matrix.font", defaults.getValue("matrix.font"));
        config.setValue("matrix.color.foreground", defaults.getValue("matrix.color.foreground"));
        config.setValue("matrix.color.border", defaults.getValue("matrix.color.border"));
        config.setValue("matrix.color.position", defaults.getValue("matrix.color.position"));
        config.setValue("matrix.color.note", defaults.getValue("matrix.color.note"));
        config.setValue("matrix.color.play-note", defaults.getValue("matrix.color.play-note"));
        config.setValue("matrix.color.line-1", defaults.getValue("matrix.color.line-1"));
        config.setValue("matrix.color.line-2", defaults.getValue("matrix.color.line-2"));
        config.setValue("matrix.color.line-3", defaults.getValue("matrix.color.line-3"));
    }

    public void save(UIFontModel fontData, UIColorModel rgbForeground, UIColorModel rgbBorder, UIColorModel rgbPosition, UIColorModel rgbNote, UIColorModel rgbPlay, UIColorModel[] rgbLines) {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        config.setValue("matrix.font", fontData);
        config.setValue("matrix.color.foreground", rgbForeground);
        config.setValue("matrix.color.border", rgbBorder);
        config.setValue("matrix.color.position", rgbPosition);
        config.setValue("matrix.color.note", rgbNote);
        config.setValue("matrix.color.play-note", rgbPlay);
        config.setValue("matrix.color.line-1", rgbLines[0]);
        config.setValue("matrix.color.line-2", rgbLines[1]);
        config.setValue("matrix.color.line-3", rgbLines[2]);
    }

    public void dispose() {
        this.dispose((UIResource)this.font);
        this.dispose((UIResource)this.colorForeground);
        this.dispose((UIResource)this.colorBorder);
        this.dispose((UIResource)this.colorPosition);
        this.dispose((UIResource)this.colorNote);
        this.dispose((UIResource)this.colorPlay);
        this.dispose((UIResource[])this.colorLines);
    }

    protected void dispose(UIResource[] resources) {
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                this.dispose(resources[i]);
            }
        }
    }

    protected void dispose(UIResource resource) {
        if (resource != null) {
            resource.dispose();
        }
    }

    public void configure(UIWindow parent) {
        UIFactory factory = this.getUIFactory();
        UITableLayout windowLayout = new UITableLayout();
        final UIWindow window = factory.createWindow(parent, true, false);
        window.setLayout((UILayout)windowLayout);
        window.setText(TuxGuitar.getProperty("matrix.settings"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = factory.createLegendPanel((UIContainer)window);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("matrix.settings"));
        windowLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        int groupRow = 0;
        final UIFontModel fontData = this.getFontChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("matrix.font") + ":", this.font, ++groupRow);
        final UIColorModel rgbForeground = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("matrix.foreground-color") + ":", this.colorForeground, ++groupRow);
        final UIColorModel[] rgbLines = new UIColorModel[]{this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("matrix.line-color-1") + ":", this.colorLines[0], ++groupRow), this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("matrix.line-color-2") + ":", this.colorLines[1], ++groupRow), this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("matrix.line-color-over") + ":", this.colorLines[2], ++groupRow)};
        final UIColorModel rgbBorder = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("matrix.border-color") + ":", this.colorBorder, ++groupRow);
        final UIColorModel rgbPosition = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("matrix.position-color") + ":", this.colorPosition, ++groupRow);
        final UIColorModel rgbNote = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("matrix.note-color") + ":", this.colorNote, ++groupRow);
        final UIColorModel rgbPlay = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("matrix.play-note-color") + ":", this.colorPlay, ++groupRow);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = factory.createPanel((UIContainer)window, false);
        buttons.setLayout((UILayout)buttonsLayout);
        windowLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonDefaults = factory.createButton((UIContainer)buttons);
        buttonDefaults.setText(TuxGuitar.getProperty("defaults"));
        buttonDefaults.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGMatrixConfig this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                window.dispose();
                this.this$0.defaults();
                this.this$0.applyChanges();
            }
        });
        buttonsLayout.set((UIControl)buttonDefaults, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonOK = factory.createButton((UIContainer)buttons);
        buttonOK.setDefaultButton();
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGMatrixConfig this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                window.dispose();
                this.this$0.save(fontData, rgbForeground, rgbBorder, rgbPosition, rgbNote, rgbPlay, rgbLines);
                this.this$0.applyChanges();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = factory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGMatrixConfig this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                window.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(window, 5);
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    protected void applyChanges() {
        this.dispose();
        this.load();
        TGMatrixEditor.getInstance(this.context).reloadFromConfig();
    }

    private UIFontModel getFontChooser(final UIWindow window, UILayoutContainer parent, String title, UIFont font, int row) {
        final UIFactory factory = this.getUIFactory();
        final UIFontModel selection = new UIFontModel(font.getName(), font.getHeight(), font.isBold(), font.isItalic());
        UITableLayout layout = (UITableLayout)parent.getLayout();
        UILabel label = factory.createLabel((UIContainer)parent);
        label.setText(title);
        layout.set((UIControl)label, Integer.valueOf(row), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton button = factory.createButton((UIContainer)parent);
        button.setText(TuxGuitar.getProperty("choose"));
        button.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGMatrixConfig this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                UIFontChooser uiFontChooser = factory.createFontChooser(window);
                uiFontChooser.setDefaultModel(selection);
                uiFontChooser.choose(new UIFontChooserHandler(){

                    public void onSelectFont(UIFontModel model) {
                        if (model != null) {
                            selection.setName(model.getName());
                            selection.setHeight(model.getHeight());
                            selection.setBold(model.isBold());
                            selection.setItalic(model.isItalic());
                        }
                    }
                });
            }
        });
        layout.set((UIControl)button, Integer.valueOf(row), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        return selection;
    }

    private UIColorModel getColorChooser(UIWindow window, UILayoutContainer parent, String title, UIColor rgb, int row) {
        UIFactory factory = this.getUIFactory();
        UITableLayout layout = (UITableLayout)parent.getLayout();
        UILabel label = factory.createLabel((UIContainer)parent);
        label.setText(title);
        layout.set((UIControl)label, Integer.valueOf(row), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        ButtonColor button = new ButtonColor(window, (UIContainer)parent, TuxGuitar.getProperty("choose"));
        button.loadColor(new UIColorModel(rgb.getRed(), rgb.getGreen(), rgb.getBlue()));
        layout.set(button.getControl(), Integer.valueOf(row), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        return button.getValue();
    }

    private class ButtonColor {
        private UIWindow window;
        private UIButton button;
        private UIColor color;
        private UIColorModel value;

        public ButtonColor(UIWindow window, UIContainer parent, String text) {
            this.window = window;
            this.value = new UIColorModel();
            this.button = TGMatrixConfig.this.getUIFactory().createButton(parent);
            this.button.setText(text);
            this.addListeners();
        }

        public void loadColor(UIColorModel cm) {
            this.value.setRed(cm.getRed());
            this.value.setGreen(cm.getGreen());
            this.value.setBlue(cm.getBlue());
            UIColor color = TGMatrixConfig.this.getUIFactory().createColor(this.value);
            this.button.setFgColor(color);
            this.disposeColor();
            this.color = color;
        }

        public void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        public void addListeners() {
            this.button.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    UIColorChooser dlg = TGMatrixConfig.this.getUIFactory().createColorChooser(ButtonColor.this.window);
                    dlg.setDefaultModel(ButtonColor.this.value);
                    dlg.setText(TuxGuitar.getProperty("choose-color"));
                    dlg.choose(new UIColorChooserHandler(){

                        public void onSelectColor(UIColorModel model) {
                            if (model != null) {
                                ButtonColor.this.loadColor(model);
                            }
                        }
                    });
                }
            });
            this.button.addDisposeListener(new UIDisposeListener(){

                public void onDispose(UIDisposeEvent event) {
                    ButtonColor.this.disposeColor();
                }
            });
        }

        public UIControl getControl() {
            return this.button;
        }

        public UIColorModel getValue() {
            return this.value;
        }
    }
}

