/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.harmonic;

import java.util.Iterator;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.effect.TGChangeHarmonicNoteAction;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIRadioButton;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGNoteRange;

public class TGHarmonicDialog {
    private static final String TYPE_DATA = "type";
    public static final float WIDTH = 400.0f;
    protected UIDropDownSelect<Integer> harmonicType;
    protected UIDropDownSelect<Integer> harmonicDataCombo;
    protected UIRadioButton[] typeButtons;

    public void show(final TGViewContext context) {
        final TGNoteRange noteRange = (TGNoteRange)context.getAttribute("note-range");
        if (noteRange != null && !noteRange.isEmpty()) {
            boolean atLeastOneHarmonic;
            TGNote nextNote;
            UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
            UIWindow uiParent = (UIWindow)context.getAttribute("parent");
            UITableLayout dialogLayout = new UITableLayout();
            final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
            dialog.setLayout((UILayout)dialogLayout);
            dialog.setText(TuxGuitar.getProperty("effects.harmonic-editor"));
            UITableLayout groupLayout = new UITableLayout();
            UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
            group.setLayout((UILayout)groupLayout);
            group.setText(TuxGuitar.getProperty("effects.harmonic.type-of-harmonic"));
            dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), null, null, Float.valueOf(400.0f), null, null);
            this.typeButtons = new UIRadioButton[5];
            UISelectionListener listener = new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGHarmonicDialog.this.updateCombo(TGHarmonicDialog.this.getHarmonic());
                }
            };
            String label = "[N.H] " + TuxGuitar.getProperty("effects.harmonic.natural");
            this.initButton(uiFactory, (UILayoutContainer)group, listener, 0, 1, label);
            label = "[A.H] " + TuxGuitar.getProperty("effects.harmonic.artificial");
            this.initButton(uiFactory, (UILayoutContainer)group, listener, 1, 2, label);
            label = "[T.H] " + TuxGuitar.getProperty("effects.harmonic.tapped");
            this.initButton(uiFactory, (UILayoutContainer)group, listener, 2, 3, label);
            label = "[P.H] " + TuxGuitar.getProperty("effects.harmonic.pinch");
            this.initButton(uiFactory, (UILayoutContainer)group, listener, 3, 4, label);
            label = "[S.H] " + TuxGuitar.getProperty("effects.harmonic.semi");
            this.initButton(uiFactory, (UILayoutContainer)group, listener, 4, 5, label);
            this.harmonicDataCombo = uiFactory.createDropDownSelect((UIContainer)group);
            groupLayout.set(this.harmonicDataCombo, Integer.valueOf(6), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
            UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
            buttons.setLayout((UILayout)buttonsLayout);
            dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
            UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
            buttonOK.setDefaultButton();
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.addSelectionListener(new UISelectionListener(){
                final /* synthetic */ TGHarmonicDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void onSelect(UISelectionEvent event) {
                    this.this$0.changeHarmonic(context.getContext(), noteRange, this.this$0.getHarmonic());
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonClean = uiFactory.createButton((UIContainer)buttons);
            buttonClean.setText(TuxGuitar.getProperty("clean"));
            Iterator it = noteRange.getNotes().iterator();
            for (atLeastOneHarmonic = false; it.hasNext() && !atLeastOneHarmonic; atLeastOneHarmonic |= nextNote.getEffect().isHarmonic()) {
                nextNote = (TGNote)it.next();
            }
            buttonClean.setEnabled(atLeastOneHarmonic);
            buttonClean.addSelectionListener(new UISelectionListener(){
                final /* synthetic */ TGHarmonicDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void onSelect(UISelectionEvent event) {
                    this.this$0.changeHarmonic(context.getContext(), noteRange, null);
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonClean, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new UISelectionListener(){
                final /* synthetic */ TGHarmonicDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void onSelect(UISelectionEvent event) {
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
            this.initDefaults(noteRange);
            TGDialogUtil.openDialog(dialog, 5);
        }
    }

    private void initButton(UIFactory uiFactory, UILayoutContainer parent, UISelectionListener listener, int index, int type, String label) {
        this.typeButtons[index] = uiFactory.createRadioButton((UIContainer)parent);
        this.typeButtons[index].setText(label);
        this.typeButtons[index].setData(TYPE_DATA, (Object)type);
        this.typeButtons[index].addSelectionListener(listener);
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set((UIControl)this.typeButtons[index], Integer.valueOf(index + 1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
    }

    private void initDefaults(TGNoteRange noteRange) {
        TGEffectHarmonic harmonic = null;
        TGFactory factory = TuxGuitar.getInstance().getSongManager().getFactory();
        boolean allNaturalHarmonicValid = noteRange.getNotes().stream().allMatch(n -> this.isNaturalValid((TGNote)n));
        this.typeButtons[0].setEnabled(allNaturalHarmonicValid);
        Iterator it = noteRange.getNotes().iterator();
        while (it.hasNext() && harmonic == null) {
            TGNote n2 = (TGNote)it.next();
            if (!n2.getEffect().isHarmonic() || !allNaturalHarmonicValid && n2.getEffect().getHarmonic().getType() == 1) continue;
            harmonic = n2.getEffect().getHarmonic().clone(factory);
        }
        if (harmonic == null) {
            harmonic = factory.newEffectHarmonic();
            harmonic.setType(allNaturalHarmonicValid ? 1 : 2);
        }
        for (int i = 0; i < this.typeButtons.length; ++i) {
            int data = (Integer)this.typeButtons[i].getData(TYPE_DATA);
            this.typeButtons[i].setSelected(data == harmonic.getType());
        }
        this.updateCombo(harmonic);
    }

    private boolean isNaturalValid(TGNote note) {
        boolean naturalValid = false;
        for (int i = 0; i < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++i) {
            if (note.getValue() % 12 != TGEffectHarmonic.NATURAL_FREQUENCIES[i][0] % 12) continue;
            naturalValid = true;
            break;
        }
        return naturalValid;
    }

    private int getSelectedType() {
        for (int i = 0; i < this.typeButtons.length; ++i) {
            if (!this.typeButtons[i].isSelected()) continue;
            return (Integer)this.typeButtons[i].getData(TYPE_DATA);
        }
        return 0;
    }

    private void updateCombo(TGEffectHarmonic harmonic) {
        int type = harmonic == null ? 1 : harmonic.getType();
        this.harmonicDataCombo.removeItems();
        this.harmonicDataCombo.setEnabled(type != 1);
        if (type != 1) {
            String label = this.getTypeLabel(type);
            for (int i = 0; i < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++i) {
                this.harmonicDataCombo.addItem(new UISelectItem(label + "(" + Integer.toString(TGEffectHarmonic.NATURAL_FREQUENCIES[i][0]) + ")", (Object)i));
            }
            this.harmonicDataCombo.setSelectedValue((Object)harmonic.getData());
        }
    }

    private String getTypeLabel(int type) {
        if (type == 1) {
            return "N.H";
        }
        if (type == 2) {
            return "A.H";
        }
        if (type == 3) {
            return "T.H";
        }
        if (type == 4) {
            return "P.H";
        }
        if (type == 5) {
            return "S.H";
        }
        return new String();
    }

    private TGEffectHarmonic getHarmonic() {
        int type = this.getSelectedType();
        if (type > 0) {
            Integer data = (Integer)this.harmonicDataCombo.getSelectedValue();
            TGEffectHarmonic effect = TuxGuitar.getInstance().getSongManager().getFactory().newEffectHarmonic();
            effect.setType(type);
            effect.setData(data != null ? data : 0);
            return effect;
        }
        return null;
    }

    private void changeHarmonic(TGContext context, TGNoteRange noteRange, TGEffectHarmonic effect) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.note.effect.change-harmonic");
        tgActionProcessor.setAttribute("note-range", (Object)noteRange);
        tgActionProcessor.setAttribute(TGChangeHarmonicNoteAction.ATTRIBUTE_EFFECT, (Object)effect);
        tgActionProcessor.process();
    }
}

