/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.fretboard;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.config.TGConfigDefaults;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.dialog.fretboard.TGFretBoardEditor;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.chooser.UIColorChooser;
import org.herac.tuxguitar.ui.chooser.UIColorChooserHandler;
import org.herac.tuxguitar.ui.chooser.UIFontChooser;
import org.herac.tuxguitar.ui.chooser.UIFontChooserHandler;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIColorModel;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.resource.UIFontModel;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.properties.TGProperties;

public class TGFretBoardConfig {
    private static final float MINIMUM_CONTROL_WIDTH = 180.0f;
    private static final float MINIMUM_BUTTON_WIDTH = 80.0f;
    private static final float MINIMUM_BUTTON_HEIGHT = 25.0f;
    public static final int DISPLAY_TEXT_NOTE = 1;
    public static final int DISPLAY_TEXT_SCALE = 2;
    public static final int DIRECTION_RIGHT = 0;
    public static final int DIRECTION_LEFT = 1;
    private TGContext context;
    private int style;
    private int direction;
    private UIFont font;
    private UIColor colorBackground;
    private UIColor colorString;
    private UIColor colorFretPoint;
    private UIColor colorNote;
    private UIColor colorScale;
    private UIColor colorNoteText;
    private UIColor colorScaleText;

    public TGFretBoardConfig(TGContext context) {
        this.context = context;
    }

    public int getStyle() {
        return this.style;
    }

    public UIFont getFont() {
        return this.font;
    }

    public UIColor getColorBackground() {
        return this.colorBackground;
    }

    public UIColor getColorString() {
        return this.colorString;
    }

    public UIColor getColorFretPoint() {
        return this.colorFretPoint;
    }

    public UIColor getColorNote() {
        return this.colorNote;
    }

    public UIColor getColorScale() {
        return this.colorScale;
    }

    public UIColor getColorNoteText() {
        return this.colorNoteText;
    }

    public UIColor getColorScaleText() {
        return this.colorScaleText;
    }

    public int getDirection() {
        return this.direction;
    }

    public UIFont createFont(UIFactory factory, UIFontModel fm) {
        return TGApplication.getInstance(this.context).getFactory().createFont(fm.getName(), fm.getHeight(), fm.isBold(), fm.isItalic());
    }

    public UIColor createColor(UIFactory factory, UIColorModel cm) {
        return TGApplication.getInstance(this.context).getFactory().createColor(cm.getRed(), cm.getGreen(), cm.getBlue());
    }

    public void load() {
        UIFactory factory = TGApplication.getInstance(this.context).getFactory();
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        this.style = config.getIntegerValue("fretboard.style");
        this.direction = config.getIntegerValue("fretboard.direction", 0);
        this.font = this.createFont(factory, config.getFontModelConfigValue("fretboard.font"));
        this.colorBackground = this.createColor(factory, config.getColorModelConfigValue("fretboard.color.background"));
        this.colorString = this.createColor(factory, config.getColorModelConfigValue("fretboard.color.string"));
        this.colorFretPoint = this.createColor(factory, config.getColorModelConfigValue("fretboard.color.fret-point"));
        this.colorNote = this.createColor(factory, config.getColorModelConfigValue("fretboard.color.note"));
        this.colorScale = this.createColor(factory, config.getColorModelConfigValue("fretboard.color.scale"));
        this.colorNoteText = this.createColor(factory, this.colorForeground(this.colorNote));
        this.colorScaleText = this.createColor(factory, this.colorForeground(this.colorScale));
    }

    private UIColorModel colorForeground(UIColor colorBackground) {
        int brightness = colorBackground.getRed() + colorBackground.getGreen() + colorBackground.getBlue();
        if (brightness > 384) {
            return new UIColorModel(0, 0, 0);
        }
        return new UIColorModel(255, 255, 255);
    }

    public void defaults() {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        TGProperties defaults = TGConfigDefaults.createDefaults();
        config.setValue("fretboard.style", defaults.getValue("fretboard.style"));
        config.setValue("fretboard.direction", defaults.getValue("fretboard.direction"));
        config.setValue("fretboard.font", defaults.getValue("fretboard.font"));
        config.setValue("fretboard.color.background", defaults.getValue("fretboard.color.background"));
        config.setValue("fretboard.color.string", defaults.getValue("fretboard.color.string"));
        config.setValue("fretboard.color.fret-point", defaults.getValue("fretboard.color.fret-point"));
        config.setValue("fretboard.color.note", defaults.getValue("fretboard.color.note"));
        config.setValue("fretboard.color.scale", defaults.getValue("fretboard.color.scale"));
    }

    public void save(int style, int direction, UIFontModel fm, UIColorModel rgbBackground, UIColorModel rgbString, UIColorModel rgbFretPoint, UIColorModel rgbNote, UIColorModel rgbScale) {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        config.setValue("fretboard.style", style);
        config.setValue("fretboard.direction", direction);
        config.setValue("fretboard.font", fm);
        config.setValue("fretboard.color.background", rgbBackground);
        config.setValue("fretboard.color.string", rgbString);
        config.setValue("fretboard.color.fret-point", rgbFretPoint);
        config.setValue("fretboard.color.note", rgbNote);
        config.setValue("fretboard.color.scale", rgbScale);
    }

    public void saveDirection(int direction) {
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        config.setValue("fretboard.direction", direction);
        this.direction = direction;
    }

    public void dispose() {
        this.font.dispose();
        this.colorBackground.dispose();
        this.colorString.dispose();
        this.colorFretPoint.dispose();
        this.colorNote.dispose();
        this.colorScale.dispose();
        this.colorNoteText.dispose();
        this.colorScaleText.dispose();
    }

    public void configure(UIWindow parent, boolean isPercussion) {
        UIFactory factory = this.getUIFactory();
        UITableLayout windowLayout = new UITableLayout();
        final UIWindow window = factory.createWindow(parent, true, false);
        window.setLayout((UILayout)windowLayout);
        window.setText(TuxGuitar.getProperty("fretboard.settings"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = factory.createLegendPanel((UIContainer)window);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("fretboard.settings"));
        windowLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        int groupRow = 0;
        final UIFontModel fontData = this.getFontChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("fretboard.font") + ":", this.font, ++groupRow);
        final UIColorModel rgbBackground = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("fretboard.background-color") + ":", this.colorBackground, ++groupRow);
        final UIColorModel rgbString = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("fretboard.string-color") + ":", this.colorString, ++groupRow);
        final UIColorModel rgbFretPoint = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("fretboard.fretpoint-color") + ":", this.colorFretPoint, ++groupRow);
        final UIColorModel rgbNote = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("fretboard.note-color") + ":", this.colorNote, ++groupRow);
        final UIColorModel rgbScale = this.getColorChooser(window, (UILayoutContainer)group, TuxGuitar.getProperty("fretboard.scale-note-color") + ":", this.colorScale, ++groupRow);
        UILabel directionLabel = factory.createLabel((UIContainer)group);
        directionLabel.setText(TuxGuitar.getProperty("fretboard.direction") + ":");
        groupLayout.set((UIControl)directionLabel, Integer.valueOf(++groupRow), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIDropDownSelect directionCombo = factory.createDropDownSelect((UIContainer)group);
        directionCombo.addItem(new UISelectItem(TuxGuitar.getProperty("fretboard.right-mode"), (Object)0));
        directionCombo.addItem(new UISelectItem(TuxGuitar.getProperty("fretboard.left-mode"), (Object)1));
        directionCombo.setSelectedItem(new UISelectItem(null, (Object)this.direction));
        groupLayout.set((UIControl)directionCombo, Integer.valueOf(groupRow), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        groupLayout = new UITableLayout();
        group = factory.createLegendPanel((UIContainer)window);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("fretboard.settings.options"));
        windowLayout.set((UIControl)group, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox displayTextNote = factory.createCheckBox((UIContainer)group);
        displayTextNote.setText(TuxGuitar.getProperty("fretboard.display-note-text"));
        displayTextNote.setSelected(!isPercussion && (this.style & 1) != 0);
        displayTextNote.setEnabled(!isPercussion);
        groupLayout.set((UIControl)displayTextNote, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox displayTextScale = factory.createCheckBox((UIContainer)group);
        displayTextScale.setText(TuxGuitar.getProperty("fretboard.display-scale-text"));
        displayTextScale.setSelected(!isPercussion && (this.style & 2) != 0);
        displayTextScale.setEnabled(!isPercussion);
        groupLayout.set((UIControl)displayTextScale, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = factory.createPanel((UIContainer)window, false);
        buttons.setLayout((UILayout)buttonsLayout);
        windowLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonDefaults = factory.createButton((UIContainer)buttons);
        buttonDefaults.setText(TuxGuitar.getProperty("defaults"));
        buttonDefaults.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGFretBoardConfig this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                window.dispose();
                this.this$0.defaults();
                this.this$0.applyChanges();
            }
        });
        buttonsLayout.set((UIControl)buttonDefaults, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonOK = factory.createButton((UIContainer)buttons);
        buttonOK.setDefaultButton();
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGFretBoardConfig this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                int style = 0;
                style |= displayTextNote.isSelected() ? 1 : 0;
                style |= displayTextScale.isSelected() ? 2 : 0;
                Integer direction = (Integer)directionCombo.getSelectedValue();
                if (direction == null) {
                    direction = 0;
                }
                window.dispose();
                this.this$0.save(style, direction, fontData, rgbBackground, rgbString, rgbFretPoint, rgbNote, rgbScale);
                this.this$0.applyChanges();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = factory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGFretBoardConfig this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                window.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(window, 5);
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    protected void applyChanges() {
        this.dispose();
        this.load();
        TGFretBoardEditor.getInstance(this.context).getFretBoard().reloadFromConfig();
    }

    private UIColorModel getColorChooser(UIWindow window, UILayoutContainer parent, String title, UIColor rgb, int row) {
        UIFactory factory = this.getUIFactory();
        UITableLayout layout = (UITableLayout)parent.getLayout();
        UILabel label = factory.createLabel((UIContainer)parent);
        label.setText(title);
        layout.set((UIControl)label, Integer.valueOf(row), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        ButtonColor button = new ButtonColor(window, (UIContainer)parent, TuxGuitar.getProperty("choose"));
        button.loadColor(new UIColorModel(rgb.getRed(), rgb.getGreen(), rgb.getBlue()));
        layout.set(button.getControl(), Integer.valueOf(row), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        return button.getValue();
    }

    private UIFontModel getFontChooser(final UIWindow window, UILayoutContainer parent, String title, UIFont font, int row) {
        final UIFactory factory = this.getUIFactory();
        final UIFontModel selection = new UIFontModel(font.getName(), font.getHeight(), font.isBold(), font.isItalic());
        UITableLayout layout = (UITableLayout)parent.getLayout();
        UILabel label = factory.createLabel((UIContainer)parent);
        label.setText(title);
        layout.set((UIControl)label, Integer.valueOf(row), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton button = factory.createButton((UIContainer)parent);
        button.setText(TuxGuitar.getProperty("choose"));
        button.addSelectionListener(new UISelectionListener(){
            final /* synthetic */ TGFretBoardConfig this$0;
            {
                this.this$0 = this$0;
            }

            public void onSelect(UISelectionEvent event) {
                UIFontChooser uiFontChooser = factory.createFontChooser(window);
                uiFontChooser.setDefaultModel(selection);
                uiFontChooser.choose(new UIFontChooserHandler(){

                    public void onSelectFont(UIFontModel model) {
                        if (model != null) {
                            selection.setName(model.getName());
                            selection.setHeight(model.getHeight());
                            selection.setBold(model.isBold());
                            selection.setItalic(model.isItalic());
                        }
                    }
                });
            }
        });
        layout.set((UIControl)button, Integer.valueOf(row), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        return selection;
    }

    private class ButtonColor {
        private UIWindow window;
        private UIButton button;
        private UIColor color;
        private UIColorModel value;

        public ButtonColor(UIWindow window, UIContainer parent, String text) {
            this.window = window;
            this.value = new UIColorModel();
            this.button = TGFretBoardConfig.this.getUIFactory().createButton(parent);
            this.button.setText(text);
            this.addListeners();
        }

        public void loadColor(UIColorModel cm) {
            this.value.setRed(cm.getRed());
            this.value.setGreen(cm.getGreen());
            this.value.setBlue(cm.getBlue());
            UIColor color = TGFretBoardConfig.this.getUIFactory().createColor(this.value);
            this.button.setFgColor(color);
            this.disposeColor();
            this.color = color;
        }

        public void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        public void addListeners() {
            this.button.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    UIColorChooser dlg = TGFretBoardConfig.this.getUIFactory().createColorChooser(ButtonColor.this.window);
                    dlg.setDefaultModel(ButtonColor.this.value);
                    dlg.setText(TuxGuitar.getProperty("choose-color"));
                    dlg.choose(new UIColorChooserHandler(){

                        public void onSelectColor(UIColorModel model) {
                            if (model != null) {
                                ButtonColor.this.loadColor(model);
                            }
                        }
                    });
                }
            });
            this.button.addDisposeListener(new UIDisposeListener(){

                public void onDispose(UIDisposeEvent event) {
                    ButtonColor.this.disposeColor();
                }
            });
        }

        public UIControl getControl() {
            return this.button;
        }

        public UIColorModel getValue() {
            return this.value;
        }
    }
}

