/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.documentation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.resource.TGResourceManager;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.widget.UIBrowser;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;

public class TGDocumentationDialog {
    private static final String RESOURCE_PATH = "help";
    private static final String TEMPORAL_PATH = System.getProperty("java.io.tmpdir") + File.separator + "tuxguitar-" + System.getProperty("user.name");
    private TGViewContext context;

    public TGDocumentationDialog(TGViewContext context) {
        this.context = context;
    }

    public void show() {
        boolean isEmbeddedBrowserAvailable;
        UIFactory uiFactory = TGApplication.getInstance(this.context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)this.context.getAttribute("parent");
        UIWindow dialog = uiFactory.createWindow(uiParent, false, true);
        UIBrowser browser = null;
        URL url = null;
        try {
            url = this.getIndexUrl();
        }
        catch (Throwable throwable) {
            throw new TGException(throwable);
        }
        if (url == null) {
            return;
        }
        try {
            browser = uiFactory.createBrowser(dialog);
            browser.loadUrl(url);
            isEmbeddedBrowserAvailable = true;
        }
        catch (Throwable throwable) {
            isEmbeddedBrowserAvailable = false;
        }
        if (isEmbeddedBrowserAvailable) {
            UITableLayout dialogLayout = new UITableLayout();
            dialog.setLayout((UILayout)dialogLayout);
            dialog.setText(TuxGuitar.getProperty("help.doc"));
            dialog.setBounds(new UIRectangle(new UISize(820.0f, 660.0f)));
            dialogLayout.set((UIControl)browser, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            TGDialogUtil.openDialog(dialog, 6);
        } else {
            TGApplication.getInstance(this.context.getContext()).getApplication().openUrl(url);
        }
    }

    private URL getIndexUrl() throws Throwable {
        URL url = TGResourceManager.getInstance((TGContext)this.context.getContext()).getResource("help/index.html");
        if (url != null && !TGFileUtils.isLocalFile(url)) {
            String path = TEMPORAL_PATH + File.separator + RESOURCE_PATH;
            this.copyTemporalResources(path, RESOURCE_PATH, TGFileUtils.getFileNames(this.context.getContext(), RESOURCE_PATH));
            url = new File(path + File.separator + "index.html").toURI().toURL();
        }
        return url;
    }

    private void copyTemporalResources(String dstPath, String resourcePath, String[] resources) throws Throwable {
        if (resources != null) {
            for (int i = 0; i < resources.length; ++i) {
                InputStream in;
                File file = new File(dstPath + File.separator + resources[i]);
                file.getParentFile().mkdirs();
                String resource = resourcePath + "/" + resources[i];
                String[] children = TGFileUtils.getFileNames(this.context.getContext(), resource);
                if (children != null && children.length > 0) {
                    this.copyTemporalResources(file.getAbsolutePath(), resource, children);
                    continue;
                }
                if (file.exists() || (in = TGResourceManager.getInstance((TGContext)this.context.getContext()).getResourceAsStream(resource)) == null) continue;
                FileOutputStream out = new FileOutputStream(file);
                int len = 0;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                out.flush();
                ((OutputStream)out).close();
                in.close();
            }
        }
    }
}

