/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordDialog;
import org.herac.tuxguitar.graphics.control.TGChordImpl;
import org.herac.tuxguitar.graphics.control.TGResourceBuffer;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UIPaintEvent;
import org.herac.tuxguitar.ui.event.UIPaintListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIFont;
import org.herac.tuxguitar.ui.resource.UIFontModel;
import org.herac.tuxguitar.ui.resource.UIPainter;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UIResourceFactory;
import org.herac.tuxguitar.ui.widget.UICanvas;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIScrollBar;
import org.herac.tuxguitar.ui.widget.UIScrollBarPanel;

public class TGChordList {
    private static final int SCROLL_INCREMENT = 25;
    private static final float MIN_HEIGHT = 160.0f;
    private static final float CHORD_FIRST_FRET_SPACING = 12.0f;
    private static final float CHORD_STRING_SPACING = 8.0f;
    private static final float CHORD_FRET_SPACING = 10.0f;
    private static final float CHORD_NOTE_SIZE = 6.0f;
    private static final float CHORD_LINE_WIDTH = 1.0f;
    private TGChordDialog dialog;
    private TGBeat beat;
    private TGResourceBuffer resourceBuffer;
    private List<TGChord> graphicChords = new ArrayList<TGChord>();
    private float height;
    private TGChordImpl selectedChord;
    private UIScrollBarPanel control;
    private UICanvas canvas;
    private UIFont font;

    public TGChordList(TGChordDialog dialog, UIContainer parent, TGBeat beat) {
        this.resourceBuffer = new TGResourceBuffer();
        this.dialog = dialog;
        this.beat = beat;
        this.createControl(parent);
    }

    public void createControl(UIContainer parent) {
        UIFactory uiFactory = this.dialog.getUIFactory();
        UITableLayout scrollBarLayout = new UITableLayout(Float.valueOf(0.0f));
        this.control = uiFactory.createScrollBarPanel(parent, true, false, true);
        this.control.setLayout((UILayout)scrollBarLayout);
        this.canvas = uiFactory.createCanvas((UIContainer)this.control, false);
        this.canvas.setBgColor(this.dialog.getColor("widget.chordEditor.backgroundColor"));
        this.canvas.addPaintListener(new UIPaintListener(){

            public void onPaint(UIPaintEvent event) {
                TGChordList.this.paintChords(event.getPainter());
            }
        });
        this.canvas.addMouseUpListener(new UIMouseUpListener(){

            public void onMouseUp(UIMouseEvent event) {
                TGChordList.this.getComposite().setFocus();
                TGChordList.this.getDialog().getEditor().setChord((TGChord)TGChordList.this.getChord(event.getPosition().getX(), event.getPosition().getY(), true));
                TGChordList.this.redraw();
            }
        });
        scrollBarLayout.set((UIControl)this.canvas, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, Float.valueOf(160.0f), Float.valueOf(0.0f));
        UIScrollBar uiScrollBar = this.control.getVScroll();
        uiScrollBar.setIncrement(25);
        uiScrollBar.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordList.this.redraw();
            }
        });
        this.control.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGChordList.this.disposeChords();
                TGChordList.this.disposeFont();
            }
        });
    }

    public void redraw() {
        this.canvas.redraw();
    }

    private void fillBackground(UIPainter painter) {
        UIRectangle bounds = this.canvas.getBounds();
        painter.setBackground(this.dialog.getColor("widget.chordEditor.backgroundColor"));
        painter.initPath(2);
        painter.addRectangle(0.0f, 0.0f, bounds.getWidth(), bounds.getHeight());
        painter.closePath();
    }

    private void paintChords(UIPainter painter) {
        this.fillBackground(painter);
        float maxHeight = 0.0f;
        float fromX = 15.0f;
        float fromY = 10.0f;
        float vScroll = this.control.getVScroll().getValue();
        for (TGChordImpl tGChordImpl : this.graphicChords) {
            UIColor color = this.getChordColor(tGChordImpl);
            tGChordImpl.registerBuffer(this.resourceBuffer);
            tGChordImpl.setBackgroundColor(this.dialog.getColor("widget.chordEditor.backgroundColor"));
            tGChordImpl.setColor(color);
            tGChordImpl.setNoteColor(color);
            tGChordImpl.setTonicColor(this.dialog.getColor("widget.chordEditor.tonicColor"));
            tGChordImpl.setFirstFretSpacing(12.0f);
            tGChordImpl.setStringSpacing(8.0f);
            tGChordImpl.setFretSpacing(10.0f);
            tGChordImpl.setNoteSize(6.0f);
            tGChordImpl.setLineWidth(1.0f);
            tGChordImpl.setFirstFretFont(this.getFont());
            tGChordImpl.setStyle(32);
            tGChordImpl.update(painter, (UIResourceFactory)this.getDialog().getUIFactory(), this.resourceBuffer);
            if (fromX + tGChordImpl.getWidth() >= this.control.getBounds().getX() + this.control.getBounds().getWidth() - 20.0f) {
                fromX = 15.0f;
                fromY += tGChordImpl.getHeight() + 10.0f;
            }
            tGChordImpl.setEditing(true);
            tGChordImpl.setPosX(fromX);
            tGChordImpl.setPosY(fromY - vScroll);
            tGChordImpl.paint(painter, tGChordImpl.getWidth() / 2.0f, 0.0f);
            fromX += tGChordImpl.getWidth() + 10.0f;
            maxHeight = Math.max(maxHeight, tGChordImpl.getHeight());
        }
        this.height = fromY + maxHeight + 10.0f;
        this.updateScroll();
    }

    private UIColor getChordColor(TGChordImpl chord) {
        if (this.selectedChord != null && this.selectedChord.equals(chord)) {
            return this.dialog.getColor("widget.chordEditor.selectionColor");
        }
        return this.dialog.getColor("widget.chordEditor.foregroundColor");
    }

    public void updateScroll() {
        UIRectangle bounds = this.canvas.getBounds();
        UIScrollBar uiScrollBar = this.control.getVScroll();
        uiScrollBar.setMaximum(Math.max(Math.round(this.height - bounds.getHeight()), 0));
        uiScrollBar.setThumb(Math.round(bounds.getHeight()));
    }

    private UIFont getFont() {
        if (this.font == null || this.font.isDisposed()) {
            UIFont font = this.control.getFont();
            UIFontModel model = new UIFontModel(font != null ? font.getName() : "Sans", 7.0f, true, false);
            this.font = this.dialog.getUIFactory().createFont(model);
        }
        return this.font;
    }

    private TGChordImpl getChord(float x, float y, boolean setAsSelected) {
        for (TGChordImpl tGChordImpl : this.graphicChords) {
            float x1 = tGChordImpl.getPosX();
            float x2 = x1 + tGChordImpl.getWidth();
            float y1 = tGChordImpl.getPosY();
            float y2 = y1 + tGChordImpl.getHeight();
            if (!(x > x1) || !(x < x2) || !(y > y1) || !(y < y2)) continue;
            if (setAsSelected) {
                if (this.selectedChord != null) {
                    this.selectedChord.dispose();
                }
                this.selectedChord = tGChordImpl;
                tGChordImpl.dispose();
            }
            return tGChordImpl;
        }
        return null;
    }

    public void setChords(List<TGChord> chords) {
        this.disposeChords();
        this.selectedChord = null;
        for (TGChordImpl tGChordImpl : chords) {
            tGChordImpl.setTonic(((Integer)this.dialog.getSelector().getTonicList().getSelectedValue()).intValue());
            tGChordImpl.setBeat(this.beat);
            this.graphicChords.add((TGChord)tGChordImpl);
        }
        this.redraw();
    }

    public void disposeFont() {
        if (this.font != null) {
            this.font.dispose();
        }
    }

    public void disposeChords() {
        this.graphicChords.clear();
        this.resourceBuffer.disposeAllResources();
    }

    public UIScrollBarPanel getControl() {
        return this.control;
    }

    public UICanvas getComposite() {
        return this.canvas;
    }

    public TGChordDialog getDialog() {
        return this.dialog;
    }
}

