/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.channel;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.util.TGContinousControlSelectionListener;
import org.herac.tuxguitar.app.util.TGContinuousControl;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelHandle;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelManagerDialog;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelSettingsDialog;
import org.herac.tuxguitar.player.base.MidiInstrument;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UIFocusEvent;
import org.herac.tuxguitar.ui.event.UIFocusLostListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UIKnob;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UITextField;
import org.herac.tuxguitar.util.TGContext;

public class TGChannelItem
implements TGContinuousControl {
    private static final int MINIMUM_KNOB_VALUE = 0;
    private static final int MAXIMUM_KNOB_VALUE = 127;
    private static final int MINIMUM_KNOB_INCREMENT = 4;
    private TGChannel channel;
    private TGChannelManagerDialog dialog;
    private TGChannelSettingsDialog channelUI;
    private UIPanel composite;
    private UITextField nameText;
    private UIDropDownSelect<Short> programCombo;
    private UIDropDownSelect<Short> bankCombo;
    private UIButton setupChannelButton;
    private UIButton removeChannelButton;
    private UICheckBox percussionButton;
    private UIKnob volumeScale;
    private UIKnob balanceScale;
    private UIKnob reverbScale;
    private UIKnob chorusScale;
    private UIKnob tremoloScale;
    private UIKnob phaserScale;

    public TGChannelItem(TGChannelManagerDialog dialog) {
        this.dialog = dialog;
    }

    public void show(UIContainer parent) {
        UIFactory uiFactory = this.dialog.getUIFactory();
        UITableLayout uiLayout = new UITableLayout(Float.valueOf(0.0f));
        this.composite = uiFactory.createPanel(parent, true);
        this.composite.setLayout((UILayout)uiLayout);
        this.composite.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGChannelItem.this.disposeChannelUI();
            }
        });
        UITableLayout col1Layout = new UITableLayout();
        UIPanel col1Panel = uiFactory.createPanel((UIContainer)this.composite, false);
        col1Panel.setLayout((UILayout)col1Layout);
        uiLayout.set((UIControl)col1Panel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.nameText = uiFactory.createTextField((UIContainer)col1Panel);
        this.nameText.addFocusLostListener(new UIFocusLostListener(){

            public void onFocusLost(UIFocusEvent event) {
                TGChannelItem.this.checkForNameModified();
            }
        });
        col1Layout.set((UIControl)this.nameText, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(250.0f), null, null);
        this.programCombo = uiFactory.createDropDownSelect((UIContainer)col1Panel);
        this.programCombo.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChannelItem.this.updateChannel(false);
            }
        });
        col1Layout.set(this.programCombo, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.bankCombo = uiFactory.createDropDownSelect((UIContainer)col1Panel);
        this.bankCombo.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChannelItem.this.updateChannel(false);
            }
        });
        col1Layout.set(this.bankCombo, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout col2Layout = new UITableLayout();
        UIPanel col2Panel = uiFactory.createPanel((UIContainer)this.composite, false);
        col2Panel.setLayout((UILayout)col2Layout);
        uiLayout.set((UIControl)col2Panel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.percussionButton = uiFactory.createCheckBox((UIContainer)col2Panel);
        this.percussionButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChannelItem.this.updateChannel(true);
            }
        });
        col2Layout.set((UIControl)this.percussionButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout col3Layout = new UITableLayout();
        UIPanel col3Panel = uiFactory.createPanel((UIContainer)this.composite, false);
        col3Panel.setLayout((UILayout)col3Layout);
        uiLayout.set((UIControl)col3Panel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        UITableLayout actionButtonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel actionButtonsComposite = uiFactory.createPanel((UIContainer)col3Panel, false);
        actionButtonsComposite.setLayout((UILayout)actionButtonsLayout);
        col3Layout.set((UIControl)actionButtonsComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.setupChannelButton = uiFactory.createButton((UIContainer)actionButtonsComposite);
        this.setupChannelButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChannelItem.this.setupChannel();
            }
        });
        actionButtonsLayout.set((UIControl)this.setupChannelButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        this.removeChannelButton = uiFactory.createButton((UIContainer)actionButtonsComposite);
        this.removeChannelButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChannelItem.this.removeChannel();
            }
        });
        actionButtonsLayout.set((UIControl)this.removeChannelButton, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        UITableLayout controllerScalesLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel controllerScalesComposite = uiFactory.createPanel((UIContainer)col3Panel, false);
        controllerScalesComposite.setLayout((UILayout)controllerScalesLayout);
        col3Layout.set((UIControl)controllerScalesComposite, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(false), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        TGContinousControlSelectionListener scaleSelectionListener = new TGContinousControlSelectionListener(this);
        this.volumeScale = uiFactory.createKnob((UIContainer)controllerScalesComposite);
        this.volumeScale.setMinimum(0);
        this.volumeScale.setMaximum(127);
        this.volumeScale.setIncrement(4);
        this.volumeScale.addSelectionListener((UISelectionListener)scaleSelectionListener);
        controllerScalesLayout.set((UIControl)this.volumeScale, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.balanceScale = uiFactory.createKnob((UIContainer)controllerScalesComposite);
        this.balanceScale.setMinimum(0);
        this.balanceScale.setMaximum(127);
        this.balanceScale.setIncrement(4);
        this.balanceScale.addSelectionListener((UISelectionListener)scaleSelectionListener);
        controllerScalesLayout.set((UIControl)this.balanceScale, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.reverbScale = uiFactory.createKnob((UIContainer)controllerScalesComposite);
        this.reverbScale.setMinimum(0);
        this.reverbScale.setMaximum(127);
        this.reverbScale.setIncrement(4);
        this.reverbScale.addSelectionListener((UISelectionListener)scaleSelectionListener);
        controllerScalesLayout.set((UIControl)this.reverbScale, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.chorusScale = uiFactory.createKnob((UIContainer)controllerScalesComposite);
        this.chorusScale.setMinimum(0);
        this.chorusScale.setMaximum(127);
        this.chorusScale.setIncrement(4);
        this.chorusScale.addSelectionListener((UISelectionListener)scaleSelectionListener);
        controllerScalesLayout.set((UIControl)this.chorusScale, Integer.valueOf(1), Integer.valueOf(4), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.tremoloScale = uiFactory.createKnob((UIContainer)controllerScalesComposite);
        this.tremoloScale.setMinimum(0);
        this.tremoloScale.setMaximum(127);
        this.tremoloScale.setIncrement(4);
        this.tremoloScale.addSelectionListener((UISelectionListener)scaleSelectionListener);
        controllerScalesLayout.set((UIControl)this.tremoloScale, Integer.valueOf(1), Integer.valueOf(5), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.phaserScale = uiFactory.createKnob((UIContainer)controllerScalesComposite);
        this.phaserScale.setMinimum(0);
        this.phaserScale.setMaximum(127);
        this.phaserScale.setIncrement(4);
        this.phaserScale.addSelectionListener((UISelectionListener)scaleSelectionListener);
        controllerScalesLayout.set((UIControl)this.phaserScale, Integer.valueOf(1), Integer.valueOf(6), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.loadIcons();
        this.loadProperties();
        this.updateItems();
    }

    public void loadChannel(TGChannel channel) {
        boolean updated;
        boolean bl = updated = this.channel == null || !this.channel.equals(channel);
        if (updated) {
            this.disposeChannelUI();
        }
        this.channel = channel;
        this.updateItems();
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            this.percussionButton.setText(TuxGuitar.getProperty("instrument.percussion-channel"));
            this.removeChannelButton.setText(TuxGuitar.getProperty("remove"));
            this.setupChannelButton.setToolTipText(TuxGuitar.getProperty("settings"));
            this.volumeScale.setToolTipText(TuxGuitar.getProperty("instrument.volume"));
            this.balanceScale.setToolTipText(TuxGuitar.getProperty("instrument.balance"));
            this.reverbScale.setToolTipText(TuxGuitar.getProperty("instrument.reverb"));
            this.chorusScale.setToolTipText(TuxGuitar.getProperty("instrument.chorus"));
            this.tremoloScale.setToolTipText(TuxGuitar.getProperty("instrument.tremolo"));
            this.phaserScale.setToolTipText(TuxGuitar.getProperty("instrument.phaser"));
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            this.setupChannelButton.setImage(TGIconManager.getInstance(this.getContext()).getSettings());
        }
    }

    public void updateItems() {
        if (!this.isDisposed() && this.getChannel() != null) {
            this.updateIgnoreEvents(true);
            boolean playerRunning = this.getHandle().isPlayerRunning();
            boolean anyPercussionChannel = this.getHandle().isAnyPercussionChannel();
            boolean anyTrackConnectedToChannel = this.getHandle().isAnyTrackConnectedToChannel(this.getChannel());
            this.nameText.setText(this.getChannel().getName());
            this.percussionButton.setSelected(this.getChannel().isPercussionChannel());
            this.percussionButton.setEnabled(!anyTrackConnectedToChannel && (!anyPercussionChannel || this.getChannel().isPercussionChannel()));
            this.removeChannelButton.setEnabled(!anyTrackConnectedToChannel);
            this.setupChannelButton.setEnabled(this.dialog.getChannelSettingsHandlerManager().isChannelSettingsHandlerAvailable());
            this.volumeScale.setValue((int)this.getChannel().getVolume());
            this.balanceScale.setValue((int)this.getChannel().getBalance());
            this.reverbScale.setValue((int)this.getChannel().getReverb());
            this.chorusScale.setValue((int)this.getChannel().getChorus());
            this.tremoloScale.setValue((int)this.getChannel().getTremolo());
            this.phaserScale.setValue((int)this.getChannel().getPhaser());
            this.updateBankCombo(playerRunning);
            this.updateProgramCombo(playerRunning);
            this.updateIgnoreEvents(false);
        }
    }

    private void updateIgnoreEvents(boolean ignoreEvents) {
        this.nameText.setIgnoreEvents(ignoreEvents);
        this.percussionButton.setIgnoreEvents(ignoreEvents);
        this.removeChannelButton.setIgnoreEvents(ignoreEvents);
        this.setupChannelButton.setIgnoreEvents(ignoreEvents);
        this.volumeScale.setIgnoreEvents(ignoreEvents);
        this.balanceScale.setIgnoreEvents(ignoreEvents);
        this.reverbScale.setIgnoreEvents(ignoreEvents);
        this.chorusScale.setIgnoreEvents(ignoreEvents);
        this.tremoloScale.setIgnoreEvents(ignoreEvents);
        this.phaserScale.setIgnoreEvents(ignoreEvents);
        this.bankCombo.setIgnoreEvents(ignoreEvents);
        this.programCombo.setIgnoreEvents(ignoreEvents);
    }

    private void updateBankCombo(boolean playerRunning) {
        if (!this.isDisposed() && this.getChannel() != null) {
            if (this.bankCombo.getItemCount() == 0) {
                String bankPrefix = TuxGuitar.getProperty("instrument.bank");
                for (short i = 0; i < 128; i = (short)(i + 1)) {
                    this.bankCombo.addItem(new UISelectItem(bankPrefix + " #" + i, (Object)i));
                }
            }
            if (this.getChannel().getBank() >= 0 && this.getChannel().getBank() < this.bankCombo.getItemCount()) {
                this.bankCombo.setSelectedValue((Object)this.getChannel().getBank());
            }
            this.bankCombo.setEnabled(!this.getChannel().isPercussionChannel());
        }
    }

    private void updateProgramCombo(boolean playerRunning) {
        if (!this.isDisposed() && this.getChannel() != null) {
            String programNamesKey = "programNames";
            List<String> programNames = this.getProgramNames();
            List cachedProgramNames = (List)this.programCombo.getData(programNamesKey);
            if (cachedProgramNames == null || this.isDifferentList(programNames, cachedProgramNames)) {
                this.programCombo.removeItems();
                this.programCombo.setData(programNamesKey, programNames);
                Short i = 0;
                while (i < programNames.size()) {
                    this.programCombo.addItem(new UISelectItem(programNames.get(i.shortValue()), (Object)i));
                    Short s = i;
                    i = (short)(i + 1);
                }
            }
            if (this.getChannel().getProgram() >= 0 && this.getChannel().getProgram() < this.programCombo.getItemCount()) {
                this.programCombo.setSelectedValue((Object)this.getChannel().getProgram());
            }
        }
    }

    private List<String> getProgramNames() {
        MidiInstrument[] instruments;
        ArrayList<String> programNames = new ArrayList<String>();
        if (!this.getChannel().isPercussionChannel() && (instruments = MidiPlayer.getInstance((TGContext)this.getContext()).getInstruments()) != null) {
            int count = instruments.length;
            if (count > 128) {
                count = 128;
            }
            for (int i = 0; i < count; ++i) {
                programNames.add(instruments[i].getName());
            }
        }
        if (programNames.isEmpty()) {
            String programPrefix = TuxGuitar.getProperty("instrument.program");
            for (int i = 0; i < 128; ++i) {
                programNames.add(programPrefix + " #" + i);
            }
        }
        return programNames;
    }

    private boolean isDifferentList(List<? extends Object> list1, List<? extends Object> list2) {
        if (list1.size() != list2.size()) {
            return true;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return true;
        }
        return false;
    }

    public void checkForNameModified() {
        if (this.getChannel() != null && !this.isDisposed() && !this.nameText.getText().equals(this.getChannel().getName())) {
            this.updateChannel(false);
        }
    }

    @Override
    public TGContext getContext() {
        return this.dialog.getContext();
    }

    public TGChannelHandle getHandle() {
        return this.dialog.getHandle();
    }

    public TGChannel getChannel() {
        return this.channel;
    }

    public UIPanel getComposite() {
        return this.composite;
    }

    public boolean isDisposed() {
        return this.getComposite() == null || this.getComposite().isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.getComposite().dispose();
        }
    }

    @Override
    public void doActionWhenStable() {
        this.updateChannel(false);
    }

    public void updateChannel(boolean percussionChanged) {
        if (this.getChannel() != null && !this.isDisposed()) {
            boolean percussionChannel = this.percussionButton.isSelected();
            short bank = this.getChannel().getBank();
            short program = this.getChannel().getProgram();
            if (percussionChanged) {
                bank = percussionChannel ? (short)128 : 0;
                program = percussionChannel ? (short)0 : 25;
            } else {
                Short programSelection;
                Short bankSelection;
                if (!percussionChannel && (bankSelection = (Short)this.bankCombo.getSelectedValue()) != null) {
                    bank = bankSelection;
                }
                if ((programSelection = (Short)this.programCombo.getSelectedValue()) != null) {
                    program = programSelection;
                }
            }
            this.getHandle().updateChannel(this.getChannel().getChannelId(), bank, program, (short)this.volumeScale.getValue(), (short)this.balanceScale.getValue(), (short)this.chorusScale.getValue(), (short)this.reverbScale.getValue(), (short)this.phaserScale.getValue(), (short)this.tremoloScale.getValue(), this.nameText.getText());
        }
    }

    public void removeChannel() {
        if (this.getChannel() != null && !this.isDisposed()) {
            this.getHandle().removeChannel(this.getChannel());
        }
    }

    public void setupChannel() {
        if (this.getChannel() != null && !this.isDisposed()) {
            if (this.channelUI == null) {
                this.channelUI = this.dialog.getChannelSettingsHandlerManager().findChannelSettingsDialog(this.getChannel());
            }
            if (this.channelUI != null) {
                if (this.channelUI.isOpen()) {
                    this.channelUI.close();
                } else {
                    this.channelUI.open(this.dialog.getWindow());
                }
            }
        }
    }

    public void disposeChannelUI() {
        if (this.channelUI != null && this.channelUI.isOpen()) {
            this.channelUI.close();
        }
        this.channelUI = null;
    }
}

