/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.table;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.transport.TGTransport;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.component.table.TGTable;
import org.herac.tuxguitar.app.view.component.table.TGTableCanvasPainter;
import org.herac.tuxguitar.app.view.component.table.TGTableColorModel;
import org.herac.tuxguitar.app.view.component.table.TGTableMixer;
import org.herac.tuxguitar.app.view.component.table.TGTableRow;
import org.herac.tuxguitar.app.view.component.table.TGTableRowButtonsCell;
import org.herac.tuxguitar.app.view.component.table.TGTableRowCell;
import org.herac.tuxguitar.app.view.component.table.TGTableRowTextCell;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.menu.impl.TrackMenu;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.util.TGProcess;
import org.herac.tuxguitar.editor.util.TGSyncProcess;
import org.herac.tuxguitar.editor.util.TGSyncProcessLocked;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.graphics.control.TGTrackImpl;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIMouseDoubleClickListener;
import org.herac.tuxguitar.ui.event.UIMouseDownListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UIResizeEvent;
import org.herac.tuxguitar.ui.event.UIResizeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UIScrollBarPanelLayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIPopupMenu;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIScrollBar;
import org.herac.tuxguitar.ui.widget.UIScrollBarPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGTableViewer
implements TGEventListener {
    private TGContext context;
    private UIPanel composite;
    private UIScrollBarPanel trackTableComposite;
    private UIScrollBarPanel volumeComposite;
    private TGTableMixer mixer;
    private UIScrollBar hScroll;
    private UIScrollBar vScroll;
    private TrackMenu menu;
    private TGTable table;
    private TGProcess redrawProcess;
    private TGProcess redrawPlayModeProcess;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateMenuItemsProcess;
    private TGTableColorModel colorModel;
    private int selectedTrack;
    private int selectedMeasure;
    private int trackCount = 0;
    private boolean autoSizeEnabled;
    private boolean update;
    private boolean followScroll;
    private boolean resetTexts;

    public TGTableViewer(TGContext context) {
        this.context = context;
        this.createSyncProcesses();
        this.addListeners();
    }

    public void addListeners() {
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
        TuxGuitar.getInstance().getSkinManager().addLoader(this);
    }

    public void init(UIContainer parent, boolean visible) {
        this.composite = this.getUIFactory().createPanel(parent, false);
        UITableLayout uiLayout = new UITableLayout();
        this.composite.setLayout((UILayout)uiLayout);
        this.volumeComposite = this.getUIFactory().createScrollBarPanel((UIContainer)this.composite, true, false, false);
        uiLayout.set((UIControl)this.volumeComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.volumeComposite.setLayout((UILayout)new UIScrollBarPanelLayout(false, true, false, true, false, true));
        this.mixer = new TGTableMixer(this.volumeComposite, this.getUIFactory(), this.context);
        this.trackTableComposite = this.getUIFactory().createScrollBarPanel((UIContainer)this.composite, true, true, true);
        uiLayout.set((UIControl)this.trackTableComposite, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.addColorModel();
        this.loadConfig();
        this.addLayout();
        this.addTable();
        this.addHScroll();
        this.addVScroll();
        this.updateVisibility(visible);
    }

    private void addLayout() {
        this.trackTableComposite.setLayout((UILayout)new UIScrollBarPanelLayout(false, true, true, true, false, true));
    }

    private void addHScroll() {
        this.hScroll = this.trackTableComposite.getHScroll();
        this.hScroll.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTableViewer.this.redrawProcess.process();
            }
        });
    }

    private void addVScroll() {
        this.vScroll = this.trackTableComposite.getVScroll();
        this.vScroll.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTableViewer.this.trackTableComposite.layout();
            }
        });
        this.volumeComposite.getVScroll().addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTableViewer.this.volumeComposite.layout();
            }
        });
    }

    private void addTable() {
        UIMouseUpListener listener = this.mouseFocusListener();
        this.table = new TGTable(this.context, this, (UILayoutContainer)this.trackTableComposite);
        this.table.getColumnNumber().getControl().addMouseUpListener(listener);
        this.table.getColumnSoloMute().getControl().addMouseUpListener(listener);
        this.table.getColumnName().getControl().addMouseUpListener(listener);
        this.table.getColumnInstrument().getControl().addMouseUpListener(listener);
        this.table.getColumnCanvas().getControl().addMouseUpListener(listener);
        this.table.getColumnCanvas().getControl().addResizeListener(new UIResizeListener(){

            public void onResize(UIResizeEvent event) {
                TGTableViewer.this.updateHScroll();
            }
        });
        this.fireUpdate(true);
        this.loadProperties();
    }

    private void addColorModel() {
        this.colorModel = new TGTableColorModel();
    }

    public void loadProperties() {
        this.table.getColumnNumber().setTitle(TuxGuitar.getProperty("track.number"));
        this.table.getColumnSoloMute().setTitle(TuxGuitar.getProperty("track.short-solo-mute"));
        this.table.getColumnName().setTitle(TuxGuitar.getProperty("track.name"));
        this.table.getColumnInstrument().setTitle(TuxGuitar.getProperty("track.instrument"));
        this.loadMenuProperties();
    }

    public void loadIcons() {
        this.loadMenuIcons();
        int rows = this.table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TGTableRow row = this.table.getRow(i);
            row.getSoloMute().loadIcons();
        }
        this.table.getColumnCanvas().loadIcons();
    }

    public void fireUpdate(boolean newSong) {
        this.update = true;
        if (newSong) {
            this.trackCount = 0;
        }
    }

    public void updateItems() {
        this.resetTexts = true;
        this.followScroll = true;
    }

    public void updateHScroll() {
        TGTrackImpl track = this.getEditor().getTablature().getCaret().getTrack();
        if (track == null) {
            return;
        }
        int width = Math.round((float)track.countMeasures() * this.table.getRowHeight());
        int canvasWidth = Math.round(this.table.getColumnCanvas().getControl().getBounds().getWidth());
        this.hScroll.setIncrement(Math.round(this.table.getRowHeight()));
        this.hScroll.setMaximum(Math.max(width - canvasWidth, 0));
        this.hScroll.setThumb(canvasWidth);
    }

    public void updateVScroll() {
        this.vScroll.setIncrement(Math.round(this.table.getRowHeight()));
    }

    public TGContext getContext() {
        return this.context;
    }

    public TGTable getTable() {
        return this.table;
    }

    public TGTableColorModel getColorModel() {
        return this.colorModel;
    }

    public int getHScrollSelection() {
        return this.hScroll.getValue();
    }

    public UISize getTableHScrollSize() {
        return this.trackTableComposite.getHScroll().getSize();
    }

    public UISize getTableVScrollSize() {
        return this.trackTableComposite.getVScroll().getSize();
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    public TablatureEditor getEditor() {
        return TuxGuitar.getInstance().getTablatureEditor();
    }

    private String getInstrument(TGTrack track) {
        TGSong song = TuxGuitar.getInstance().getDocumentManager().getSong();
        TGChannel channel = TuxGuitar.getInstance().getSongManager().getChannel(song, track.getChannelId());
        if (channel != null) {
            return channel.getName() != null ? channel.getName() : new String();
        }
        return new String();
    }

    private void updateTable() {
        if (this.update) {
            int i;
            this.updateTableMenu();
            TGSong song = TuxGuitar.getInstance().getDocumentManager().getSong();
            this.mixer.update(song);
            int count = song.countTracks();
            this.table.removeRowsAfter(count);
            for (i = this.table.getRowCount(); i < count; ++i) {
                this.table.createRow();
            }
            for (i = 0; i < count; ++i) {
                final TGTrack track = song.getTrack(i);
                final TGTableRow row = this.table.getRow(i);
                if (row == null) continue;
                this.updateTableTextRow(row.getNumber(), track, Integer.toString(track.getNumber()));
                this.updateTableButtonsRow(row.getSoloMute(), track);
                this.updateTableTextRow(row.getName(), track, track.getName());
                this.updateTableTextRow(row.getInstrument(), track, this.getInstrument(track));
                row.setMouseUpListenerLabel(new UIMouseUpListener(){
                    final /* synthetic */ TGTableViewer this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onMouseUp(UIMouseEvent event) {
                        row.getPainter().setFocus();
                    }
                });
                row.setMouseDownListenerLabel(new UIMouseDownListener(){
                    final /* synthetic */ TGTableViewer this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onMouseDown(UIMouseEvent event) {
                        TGEditorManager.getInstance((TGContext)this.this$0.getContext()).asyncRunLocked(new Runnable(){

                            @Override
                            public void run() {
                                if (track.getNumber() != this$0.getEditor().getTablature().getCaret().getTrack().getNumber()) {
                                    TGActionProcessor tgActionProcessor = new TGActionProcessor(this$0.getContext(), "action.track.goto");
                                    tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
                                    tgActionProcessor.process();
                                }
                            }
                        });
                    }
                });
                row.setMouseDoubleClickListenerLabel(new UIMouseDoubleClickListener(){
                    final /* synthetic */ TGTableViewer this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onMouseDoubleClick(UIMouseEvent event) {
                        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.this$0.context, "action.track.goto");
                        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
                        tgActionProcessor.setOnFinish(new Runnable(){

                            @Override
                            public void run() {
                                new TGActionProcessor(TuxGuitar.getInstance().getContext(), "action.gui.open-track-properties-dialog").process();
                            }
                        });
                        tgActionProcessor.process();
                    }
                });
                row.setMouseUpListenerCanvas(new UIMouseUpListener(){
                    final /* synthetic */ TGTableViewer this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onMouseUp(UIMouseEvent event) {
                        row.getPainter().setFocus();
                    }
                });
                row.setMouseDownListenerCanvas(new UIMouseDownListener(){
                    final /* synthetic */ TGTableViewer this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onMouseDown(final UIMouseEvent event) {
                        new TGSyncProcessLocked(this.this$0.getContext(), new Runnable(){
                            final /* synthetic */ 9 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                int index = (int)((event.getPosition().getX() + (float)this.this$1.this$0.getHScrollSelection()) / this.this$1.this$0.getTable().getRowHeight());
                                if (index >= 0 && index < this.this$1.track.countMeasures()) {
                                    TGMeasure measure = this.this$1.track.getMeasure(index);
                                    TGBeat beat = TuxGuitar.getInstance().getSongManager().getMeasureManager().getFirstBeat(measure.getBeats());
                                    if (beat != null) {
                                        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.this$1.this$0.context, "action.caret.move-to");
                                        if (MidiPlayer.getInstance((TGContext)this.this$1.this$0.getContext()).isRunning()) {
                                            tgActionProcessor.setAttribute("keep-selection", (Object)true);
                                        }
                                        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)this.this$1.track);
                                        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
                                        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
                                        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)this.this$1.track.getString(1));
                                        tgActionProcessor.process();
                                    }
                                }
                            }
                        }).process();
                    }
                });
                row.setPaintListenerCanvas(new TGTableCanvasPainter(this, track));
            }
            this.table.update();
            this.selectedTrack = 0;
            this.selectedMeasure = 0;
            this.updateVScroll();
            if (!this.resizeTable(count) && this.trackCount != count) {
                this.getControl().layout();
            }
            this.trackCount = count;
        }
        this.update = false;
    }

    private boolean resizeTable(int trackCount) {
        UIWindow uiWindow = TGWindow.getInstance(this.context).getWindow();
        if (!this.autoSizeEnabled) {
            Float packedHeight = (Float)this.composite.getLayout().get((UIControl)this.trackTableComposite, "packed_height");
            if (packedHeight == null) {
                uiWindow.getLayout().set((UIControl)this.composite, "packed_height", (Object)Float.valueOf(150.0f));
                uiWindow.layout();
                return true;
            }
        } else if (this.trackCount != trackCount) {
            float tableHeight = this.composite.getLayout().computePackedSize((UILayoutContainer)this.trackTableComposite).getHeight();
            uiWindow.getLayout().set((UIControl)this.composite, "packed_height", (Object)Float.valueOf(tableHeight += this.getTableHScrollSize().getHeight()));
            uiWindow.layout();
            return true;
        }
        return false;
    }

    private void updateTableRow(TGTableRowCell cell, TGTrack track) {
        cell.setData(TGTrack.class.getName(), track);
        cell.setMenu((UIPopupMenu)this.menu.getMenu());
    }

    private void updateTableTextRow(TGTableRowTextCell cell, TGTrack track, String label) {
        cell.setText(label);
        this.updateTableRow(cell, track);
    }

    private void updateTableButtonsRow(TGTableRowButtonsCell cell, TGTrack track) {
        cell.setSolo(track.isSolo());
        cell.setMute(track.isMute());
        this.updateTableRow(cell, track);
    }

    private void updateTableMenu() {
        this.disposeMenu();
        this.createTrackMenu();
    }

    private void updateMenuItems() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.update();
        }
    }

    private void loadMenuProperties() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.loadProperties();
        }
    }

    private void loadMenuIcons() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.loadIcons();
        }
    }

    private void resetTextsValues() {
        int rows = this.table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TGTableRow row = this.table.getRow(i);
            row.getNumber().setText(Integer.toString(((TGTrack)row.getNumber().getData(TGTrack.class.getName())).getNumber()));
            row.getSoloMute().setSolo(((TGTrack)row.getSoloMute().getData(TGTrack.class.getName())).isSolo());
            row.getSoloMute().setMute(((TGTrack)row.getSoloMute().getData(TGTrack.class.getName())).isMute());
            row.getName().setText(((TGTrack)row.getName().getData(TGTrack.class.getName())).getName());
            row.getInstrument().setText(this.getInstrument((TGTrack)row.getInstrument().getData(TGTrack.class.getName())));
        }
        this.mixer.updateInstrumentsNames();
    }

    private void redrawRows(int selectedTrack) {
        int rows = this.table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TGTableRow row = this.table.getRow(i);
            row.getPainter().redraw();
            if (this.selectedTrack == selectedTrack) continue;
            if (selectedTrack - 1 == i) {
                row.setBgColor(this.colorModel.getColor(7));
                row.setFgColor(this.colorModel.getColor(8));
                continue;
            }
            if (i % 2 == 0) {
                row.setBgColor(this.colorModel.getColor(5));
                row.setFgColor(this.colorModel.getColor(6));
                continue;
            }
            row.setBgColor(this.colorModel.getColor(3));
            row.setFgColor(this.colorModel.getColor(4));
        }
    }

    public void redraw() {
        if (!this.isDisposed()) {
            this.updateTable();
            int selectedTrack = this.getEditor().getTablature().getCaret().getTrack().getNumber();
            this.redrawRows(selectedTrack);
            this.selectedTrack = selectedTrack;
            this.selectedMeasure = 0;
            this.updateHScroll();
            if (this.resetTexts) {
                this.resetTextsValues();
            }
            if (this.followScroll) {
                this.followHorizontalScroll(this.getEditor().getTablature().getCaret().getMeasure().getNumber(), 0);
                this.followScroll = false;
            }
            this.trackTableComposite.redraw();
            if (this.resetTexts) {
                this.resetTexts = false;
                this.getControl().layout();
            }
            this.table.getColumnCanvas().getControl().redraw();
        }
    }

    public void redrawPlayingMode() {
        TGMeasureImpl measure;
        if (!this.isDisposed() && (measure = TGTransport.getInstance(this.context).getCache().getPlayMeasure()) != null && measure.getTrack() != null) {
            this.updateTable();
            int selectedTrack = measure.getTrack().getNumber();
            int selectedMeasure = measure.getNumber();
            if (this.selectedTrack != selectedTrack || this.selectedMeasure != selectedMeasure) {
                this.redrawRows(selectedTrack);
                this.followHorizontalScroll(selectedMeasure, 3);
                this.table.getColumnCanvas().getControl().redraw();
            }
            this.selectedTrack = selectedTrack;
            this.selectedMeasure = selectedMeasure;
        }
    }

    private void followHorizontalScroll(int selectedMeasure, int nbMeasuresMargin) {
        int hScrollSelection = this.hScroll.getValue();
        int hScrollThumb = this.hScroll.getThumb();
        float measureSize = this.table.getRowHeight();
        float measurePosition = (float)selectedMeasure * measureSize - measureSize;
        while ((float)hScrollThumb < (float)(4 * nbMeasuresMargin) * measureSize) {
            --nbMeasuresMargin;
        }
        if (measurePosition - (float)hScrollSelection < 0.0f) {
            this.hScroll.setValue(Math.max(Math.round(measurePosition), 0));
        } else if (measurePosition + (float)(1 + nbMeasuresMargin) * measureSize - (float)hScrollSelection > (float)hScrollThumb) {
            this.hScroll.setValue(Math.max(Math.round(measurePosition - (float)nbMeasuresMargin * measureSize), 0));
        }
    }

    public void loadConfig() {
        this.autoSizeEnabled = TuxGuitar.getInstance().getConfig().getBooleanValue("table.auto-size");
        this.colorModel.resetColors(this.context);
        this.trackCount = 0;
    }

    public UIPanel getControl() {
        return this.composite;
    }

    public void createTrackMenu() {
        this.menu = new TrackMenu((UIMenu)this.getUIFactory().createPopupMenu(TGWindow.getInstance(this.context).getWindow()));
        this.menu.showItems();
        this.menu.update();
    }

    public void disposeMenu() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.getControl().dispose();
            this.disposeMenu();
        }
    }

    public boolean isDisposed() {
        return this.getControl() == null || this.getControl().isDisposed();
    }

    protected int getSelectedTrack() {
        return this.selectedTrack;
    }

    public void createSyncProcesses() {
        this.redrawProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTableViewer.this.redraw();
            }
        });
        this.redrawPlayModeProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTableViewer.this.redrawPlayingMode();
            }
        });
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            @Override
            public void run() {
                TGTableViewer.this.loadProperties();
            }
        });
        this.loadIconsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTableViewer.this.loadIcons();
            }
        });
        this.updateMenuItemsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTableViewer.this.updateMenuItems();
            }
        });
    }

    private UIMouseUpListener mouseFocusListener() {
        return new UIMouseUpListener(){

            public void onMouseUp(UIMouseEvent event) {
                TGTableRow row;
                TGTable table = TGTableViewer.this.getTable();
                if (table != null && (row = table.getRow(TGTableViewer.this.getSelectedTrack() - 1)) != null) {
                    row.getPainter().setFocus();
                }
            }
        };
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 1) {
            this.redrawProcess.process();
        } else if (type == 3) {
            this.redrawPlayModeProcess.process();
        }
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItems();
            this.updateMenuItemsProcess.process();
        } else if (type == 3 || type == 7) {
            this.fireUpdate(false);
        } else if (type == 4) {
            this.fireUpdate(true);
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-redraw".equals(event.getEventType())) {
            this.processRedrawEvent(event);
        } else if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        } else if ("ui-skin".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        }
    }

    public static TGTableViewer getInstance(TGContext context) {
        return (TGTableViewer)TGSingletonUtil.getInstance((TGContext)context, (String)TGTableViewer.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGTableViewer>(){

            public TGTableViewer createInstance(TGContext context) {
                return new TGTableViewer(context);
            }
        });
    }

    public void updateVisibility(boolean visible) {
        this.getControl().setVisible(visible);
        TGWindow window = TGWindow.getInstance(this.context);
        window.getTableDivider().setVisible(visible);
        window.getWindow().layout();
    }

    public void toggleVisibility() {
        this.updateVisibility(!this.isVisible());
    }

    public boolean isVisible() {
        return this.getControl().isVisible();
    }
}

