/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.table;

import org.herac.tuxguitar.app.view.component.table.TGTableRow;
import org.herac.tuxguitar.ui.event.UIMouseDoubleClickListener;
import org.herac.tuxguitar.ui.event.UIMouseDownListener;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.menu.UIPopupMenu;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIPanel;

public abstract class TGTableRowCell {
    private TGTableRow row;
    private UIPanel cell;
    private UITableLayout layout;

    public TGTableRowCell(TGTableRow row) {
        this.row = row;
        this.cell = this.row.getTable().getUIFactory().createPanel((UIContainer)this.row.getControl(), false);
        this.row.getTable().appendListeners((UIControl)this.cell);
        this.layout = new UITableLayout();
        this.layout.set("margin_top", (Object)Float.valueOf(0.0f));
        this.layout.set("margin_bottom", (Object)Float.valueOf(0.0f));
        this.cell.setLayout((UILayout)this.layout);
    }

    protected TGTableRow getRow() {
        return this.row;
    }

    public UITableLayout getLayout() {
        return this.layout;
    }

    public void setBgColor(UIColor background) {
        this.cell.setBgColor(background);
    }

    public void setFgColor(UIColor foreground) {
        this.cell.setFgColor(foreground);
    }

    public void setMenu(UIPopupMenu menu) {
        this.cell.setPopupMenu(menu);
    }

    public void setData(String key, Object data) {
        this.cell.setData(key, data);
    }

    public <T> T getData(String key) {
        return (T)this.cell.getData(key);
    }

    public void addMouseDownListener(UIMouseDownListener listener) {
        this.cell.addMouseDownListener(listener);
    }

    public void addMouseUpListener(UIMouseUpListener listener) {
        this.cell.addMouseUpListener(listener);
    }

    public void addMouseDoubleClickListener(UIMouseDoubleClickListener listener) {
        this.cell.addMouseDoubleClickListener(listener);
    }

    public UIPanel getControl() {
        return this.cell;
    }

    public void dispose() {
        this.row.dispose();
    }
}

