/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.table;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.component.table.TGTable;
import org.herac.tuxguitar.app.view.component.table.TGTableRow;
import org.herac.tuxguitar.app.view.component.table.TGTableRowCell;
import org.herac.tuxguitar.app.view.widgets.TGIconCheckButton;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.ui.event.UIMouseDownListener;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.menu.UIPopupMenu;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.util.TGContext;

public class TGTableRowButtonsCell
extends TGTableRowCell {
    private TGIconCheckButton soloButton;
    private TGIconCheckButton muteButton;
    private TGContext context;

    public TGTableRowButtonsCell(TGTableRow row) {
        super(row);
        this.context = row.getTable().getContext();
        TGTable table = row.getTable();
        this.soloButton = new TGIconCheckButton(table.getUIFactory(), (UILayoutContainer)this.getControl());
        this.muteButton = new TGIconCheckButton(table.getUIFactory(), (UILayoutContainer)this.getControl());
        table.appendListeners((UIControl)this.soloButton.getControl());
        table.appendListeners((UIControl)this.muteButton.getControl());
        this.soloButton.addSelectionListener(this.createClickListener("action.track.change-solo"));
        this.muteButton.addSelectionListener(this.createClickListener("action.track.change-mute"));
        this.getLayout().set((UIControl)this.soloButton.getControl(), Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(2.0f));
        this.getLayout().set((UIControl)this.muteButton.getControl(), Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(2.0f));
        this.loadProperties();
        this.loadIcons();
    }

    private UISelectionListener createClickListener(String action) {
        return event -> {
            TGTable table = this.getRow().getTable();
            Tablature tablature = table.getViewer().getEditor().getTablature();
            TGTrack track = tablature.getSongManager().getTrack(tablature.getSong(), table.getRowIndex(this.getRow()) + 1);
            TGActionProcessor processor = new TGActionProcessor(this.context, action);
            processor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
            processor.process();
        };
    }

    @Override
    public void setBgColor(UIColor background) {
        super.setBgColor(background);
        this.soloButton.getControl().setBgColor(background);
        this.muteButton.getControl().setBgColor(background);
    }

    @Override
    public void setFgColor(UIColor foreground) {
        super.setFgColor(foreground);
        this.soloButton.getControl().setFgColor(foreground);
        this.muteButton.getControl().setFgColor(foreground);
    }

    @Override
    public void setMenu(UIPopupMenu menu) {
        super.setMenu(menu);
        this.soloButton.getControl().setPopupMenu(menu);
        this.muteButton.getControl().setPopupMenu(menu);
    }

    @Override
    public void addMouseDownListener(UIMouseDownListener listener) {
        super.addMouseDownListener(listener);
        this.soloButton.getControl().addMouseDownListener(listener);
        this.muteButton.getControl().addMouseDownListener(listener);
    }

    @Override
    public void addMouseUpListener(UIMouseUpListener listener) {
        super.addMouseUpListener(listener);
        this.soloButton.getControl().addMouseUpListener(listener);
        this.muteButton.getControl().addMouseUpListener(listener);
    }

    public void setSolo(boolean solo) {
        this.soloButton.setSelected(solo);
    }

    public void setMute(boolean mute) {
        this.muteButton.setSelected(mute);
    }

    private void loadProperties() {
        this.soloButton.getControl().setToolTipText(TuxGuitar.getProperty("track.solo"));
        this.muteButton.getControl().setToolTipText(TuxGuitar.getProperty("track.mute"));
    }

    public void loadIcons() {
        TGIconManager iconManager = TGIconManager.getInstance(this.context);
        this.soloButton.setIcon(iconManager.getSoloDisabledDim());
        this.soloButton.setSelectedIcon(iconManager.getSoloDim());
        this.soloButton.setHoveredIcon(iconManager.getSoloDisabled());
        this.soloButton.setSelectedHoveredIcon(iconManager.getSolo());
        this.muteButton.setIcon(iconManager.getMuteDisabledDim());
        this.muteButton.setSelectedIcon(iconManager.getMuteDim());
        this.muteButton.setHoveredIcon(iconManager.getMuteDisabled());
        this.muteButton.setSelectedHoveredIcon(iconManager.getMute());
    }
}

