/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.table;

import org.herac.tuxguitar.app.view.component.table.TGTable;
import org.herac.tuxguitar.app.view.component.table.TGTableHeader;
import org.herac.tuxguitar.ui.event.UIMouseDragListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.widget.UIControl;

public class TGTableDividerListener
implements UIMouseDragListener {
    public static final String LEFT_CONTROL = "leftControl";
    public static final String RIGHT_CONTROL = "rightControl";
    private TGTable table;
    private TGTableHeader leftColumn;
    private TGTableHeader rightColumn;
    private final boolean atEnd;

    public TGTableDividerListener(TGTable table, TGTableHeader leftColumn, TGTableHeader rightColumn, boolean atEnd) {
        this.table = table;
        this.leftColumn = leftColumn;
        this.rightColumn = rightColumn;
        this.atEnd = atEnd;
    }

    public void onMouseDrag(UIMouseEvent event) {
        float move = event.getPosition().getX();
        Float leftWidth = this.computeWidth(this.leftColumn.getControl(), move, false);
        Float rightWidth = this.computeWidth(this.rightColumn.getControl(), -move, this.atEnd);
        if (leftWidth != null && rightWidth != null) {
            UITableLayout uiLayout = (UITableLayout)this.table.getColumnControl().getLayout();
            uiLayout.set(this.leftColumn.getControl(), "minimum_packed_width", (Object)leftWidth);
            if (!this.atEnd) {
                uiLayout.set(this.rightColumn.getControl(), "minimum_packed_width", (Object)rightWidth);
            }
            this.table.update();
        }
    }

    private Float computeWidth(UIControl control, float move, boolean atEnd) {
        float minWidth;
        if (atEnd) {
            minWidth = 2.0f * this.table.getRowHeight();
            minWidth += this.table.getViewer().getTableVScrollSize().getWidth();
        } else {
            UISize currentPackedSize = control.getPackedSize();
            control.computePackedSize(null, null);
            UISize computedPackedSize = control.getPackedSize();
            control.computePackedSize(Float.valueOf(currentPackedSize.getWidth()), Float.valueOf(currentPackedSize.getHeight()));
            minWidth = computedPackedSize.getWidth();
        }
        float newWidth = control.getBounds().getWidth() + move;
        if (newWidth >= minWidth) {
            return Float.valueOf(newWidth);
        }
        return null;
    }
}

